/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.lang.ref.ReferenceQueue;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.AbstractMap;
/*     */ import java.util.AbstractSet;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class WeakValueHashMap<K, V> extends AbstractMap<K, V>
/*     */ {
/*     */   private Map<K, WeakValueRef<K, V>> hash;
/*  50 */   private ReferenceQueue<V> queue = new ReferenceQueue();
/*     */ 
/*     */   public WeakValueHashMap(int initialCapacity, float loadFactor)
/*     */   {
/*  67 */     this.hash = new HashMap(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public WeakValueHashMap(int initialCapacity)
/*     */   {
/*  83 */     this.hash = new HashMap(initialCapacity);
/*     */   }
/*     */ 
/*     */   public WeakValueHashMap()
/*     */   {
/*  93 */     this.hash = new HashMap();
/*     */   }
/*     */ 
/*     */   public WeakValueHashMap(Map<K, V> t)
/*     */   {
/* 108 */     this(Math.max(2 * t.size(), 11), 0.75F);
/* 109 */     putAll(t);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 115 */     processQueue();
/* 116 */     return this.hash.size();
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/* 122 */     processQueue();
/* 123 */     return this.hash.containsKey(key);
/*     */   }
/*     */ 
/*     */   public V get(Object key)
/*     */   {
/* 129 */     processQueue();
/* 130 */     WeakValueRef ref = (WeakValueRef)this.hash.get(key);
/* 131 */     if (ref != null)
/* 132 */       return ref.get();
/* 133 */     return null;
/*     */   }
/*     */ 
/*     */   public V put(K key, V value)
/*     */   {
/* 139 */     processQueue();
/* 140 */     WeakValueRef ref = WeakValueRef.access$000(key, value, this.queue);
/* 141 */     WeakValueRef result = (WeakValueRef)this.hash.put(key, ref);
/* 142 */     if (result != null)
/* 143 */       return result.get();
/* 144 */     return null;
/*     */   }
/*     */ 
/*     */   public V remove(Object key)
/*     */   {
/* 150 */     processQueue();
/* 151 */     WeakValueRef result = (WeakValueRef)this.hash.remove(key);
/* 152 */     if (result != null)
/* 153 */       return result.get();
/* 154 */     return null;
/*     */   }
/*     */ 
/*     */   public Set<Map.Entry<K, V>> entrySet()
/*     */   {
/* 160 */     processQueue();
/* 161 */     return new EntrySet(null);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 167 */     processQueue();
/* 168 */     this.hash.clear();
/*     */   }
/*     */ 
/*     */   private void processQueue()
/*     */   {
/* 177 */     WeakValueRef ref = (WeakValueRef)this.queue.poll();
/* 178 */     while (ref != null)
/*     */     {
/* 181 */       if (ref == this.hash.get(ref.key)) {
/* 182 */         this.hash.remove(ref.key);
/*     */       }
/* 184 */       ref = (WeakValueRef)this.queue.poll();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class WeakValueRef<K, V> extends WeakReference<V>
/*     */     implements Map.Entry<K, V>
/*     */   {
/*     */     public K key;
/*     */ 
/*     */     private static <K, V> WeakValueRef<K, V> create(K key, V val, ReferenceQueue<V> q)
/*     */     {
/* 264 */       if (val == null) {
/* 265 */         return null;
/*     */       }
/* 267 */       return new WeakValueRef(key, val, q);
/*     */     }
/*     */ 
/*     */     private WeakValueRef(K key, V val, ReferenceQueue<V> q)
/*     */     {
/* 279 */       super(q);
/* 280 */       this.key = key;
/*     */     }
/*     */ 
/*     */     public K getKey()
/*     */     {
/* 285 */       return this.key;
/*     */     }
/*     */ 
/*     */     public V getValue()
/*     */     {
/* 290 */       return get();
/*     */     }
/*     */ 
/*     */     public V setValue(V value)
/*     */     {
/* 295 */       throw new UnsupportedOperationException("setValue");
/*     */     }
/*     */   }
/*     */ 
/*     */   private class EntrySetIterator
/*     */     implements Iterator<Map.Entry<K, V>>
/*     */   {
/*     */     private Iterator<Map.Entry<K, WeakValueHashMap.WeakValueRef<K, V>>> delegate;
/*     */ 
/*     */     public EntrySetIterator()
/*     */     {
/* 221 */       this.delegate = delegate;
/*     */     }
/*     */ 
/*     */     public boolean hasNext()
/*     */     {
/* 226 */       return this.delegate.hasNext();
/*     */     }
/*     */ 
/*     */     public Map.Entry<K, V> next()
/*     */     {
/* 231 */       Map.Entry next = (Map.Entry)this.delegate.next();
/* 232 */       return (Map.Entry)next.getValue();
/*     */     }
/*     */ 
/*     */     public void remove()
/*     */     {
/* 237 */       throw new UnsupportedOperationException("remove");
/*     */     }
/*     */   }
/*     */ 
/*     */   private class EntrySet extends AbstractSet<Map.Entry<K, V>>
/*     */   {
/*     */     private EntrySet()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Iterator<Map.Entry<K, V>> iterator()
/*     */     {
/* 196 */       return new WeakValueHashMap.EntrySetIterator(WeakValueHashMap.this, WeakValueHashMap.this.hash.entrySet().iterator());
/*     */     }
/*     */ 
/*     */     public int size()
/*     */     {
/* 202 */       return WeakValueHashMap.this.size();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.WeakValueHashMap
 * JD-Core Version:    0.6.0
 */