/*     */ package org.jboss.util.file;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileFilter;
/*     */ 
/*     */ public class FileSuffixFilter
/*     */   implements FileFilter
/*     */ {
/*     */   protected final String[] suffixes;
/*     */   protected final boolean ignoreCase;
/*     */ 
/*     */   public FileSuffixFilter(String[] suffixes, boolean ignoreCase)
/*     */   {
/*  51 */     this.ignoreCase = ignoreCase;
/*  52 */     if (ignoreCase) {
/*  53 */       this.suffixes = new String[suffixes.length];
/*  54 */       for (int i = 0; i < suffixes.length; i++)
/*  55 */         this.suffixes[i] = suffixes[i].toLowerCase();
/*     */     }
/*     */     else
/*     */     {
/*  59 */       this.suffixes = suffixes;
/*     */     }
/*     */   }
/*     */ 
/*     */   public FileSuffixFilter(String[] suffixes)
/*     */   {
/*  70 */     this(suffixes, false);
/*     */   }
/*     */ 
/*     */   public FileSuffixFilter(String suffix, boolean ignoreCase)
/*     */   {
/*  82 */     this(new String[] { suffix }, ignoreCase);
/*     */   }
/*     */ 
/*     */   public FileSuffixFilter(String suffix)
/*     */   {
/*  91 */     this(suffix, false);
/*     */   }
/*     */ 
/*     */   public boolean accept(File file)
/*     */   {
/* 101 */     boolean success = false;
/*     */ 
/* 103 */     for (int i = 0; (i < this.suffixes.length) && (!success); i++) {
/* 104 */       if (this.ignoreCase)
/* 105 */         success = file.getName().toLowerCase().endsWith(this.suffixes[i]);
/*     */       else {
/* 107 */         success = file.getName().endsWith(this.suffixes[i]);
/*     */       }
/*     */     }
/* 110 */     return success;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.file.FileSuffixFilter
 * JD-Core Version:    0.6.0
 */