/*     */ package org.jboss.util.file;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.net.JarURLConnection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Iterator;
/*     */ import java.util.jar.JarEntry;
/*     */ import java.util.jar.JarFile;
/*     */ import java.util.zip.ZipEntry;
/*     */ 
/*     */ public class JarArchiveBrowser
/*     */   implements Iterator
/*     */ {
/*     */   JarFile zip;
/*     */   Enumeration entries;
/*     */   JarEntry next;
/*     */   ArchiveBrowser.Filter filter;
/*     */ 
/*     */   public JarArchiveBrowser(JarURLConnection url, ArchiveBrowser.Filter filter)
/*     */   {
/*  51 */     this.filter = filter;
/*     */     try
/*     */     {
/*  54 */       this.zip = url.getJarFile();
/*  55 */       this.entries = this.zip.entries();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  59 */       throw new RuntimeException(e);
/*     */     }
/*  61 */     setNext();
/*     */   }
/*     */ 
/*     */   public JarArchiveBrowser(File f, ArchiveBrowser.Filter filter)
/*     */   {
/*  66 */     this.filter = filter;
/*     */     try
/*     */     {
/*  69 */       this.zip = new JarFile(f);
/*  70 */       this.entries = this.zip.entries();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  74 */       throw new RuntimeException(e);
/*     */     }
/*  76 */     setNext();
/*     */   }
/*     */ 
/*     */   public boolean hasNext()
/*     */   {
/*  81 */     return this.next != null;
/*     */   }
/*     */ 
/*     */   private void setNext()
/*     */   {
/*  86 */     this.next = null;
/*  87 */     while ((this.entries.hasMoreElements()) && (this.next == null))
/*     */     {
/*     */       do
/*     */       {
/*  91 */         this.next = ((JarEntry)this.entries.nextElement());
/*  92 */       }while ((this.entries.hasMoreElements()) && (this.next.isDirectory()));
/*  93 */       if (this.next.isDirectory()) this.next = null;
/*     */ 
/*  95 */       if ((this.next == null) || (this.filter.accept(this.next.getName())))
/*     */         continue;
/*  97 */       this.next = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object next()
/*     */   {
/* 104 */     ZipEntry entry = this.next;
/* 105 */     setNext();
/*     */     try
/*     */     {
/* 109 */       return this.zip.getInputStream(entry);
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 113 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public void remove()
/*     */   {
/* 119 */     throw new RuntimeException("Illegal operation on ArchiveBrowser");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.file.JarArchiveBrowser
 * JD-Core Version:    0.6.0
 */