/*    */ package org.jboss.util.file;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.net.JarURLConnection;
/*    */ import java.net.URL;
/*    */ import java.util.Iterator;
/*    */ 
/*    */ public class JarProtocolArchiveBrowserFactory
/*    */   implements ArchiveBrowserFactory
/*    */ {
/*    */   public Iterator create(URL url, ArchiveBrowser.Filter filter)
/*    */   {
/* 43 */     if (url.toString().endsWith("!/"))
/*    */     {
/*    */       try
/*    */       {
/* 47 */         return new JarArchiveBrowser((JarURLConnection)url.openConnection(), filter);
/*    */       }
/*    */       catch (IOException e)
/*    */       {
/* 51 */         throw new RuntimeException("Unable to browse url: " + url, e);
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 58 */       return new JarStreamBrowser(url.openStream(), filter);
/*    */     }
/*    */     catch (IOException e) {
/*    */     }
/* 62 */     throw new RuntimeException("Unable to browse url: " + url, e);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.file.JarProtocolArchiveBrowserFactory
 * JD-Core Version:    0.6.0
 */