/*     */ package org.jboss.util.graph;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Comparator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ 
/*     */ public class Graph<T>
/*     */ {
/*     */   public static final int VISIT_COLOR_WHITE = 1;
/*     */   public static final int VISIT_COLOR_GREY = 2;
/*     */   public static final int VISIT_COLOR_BLACK = 3;
/*     */   private List<Vertex<T>> verticies;
/*     */   private List<Edge<T>> edges;
/*     */   private Vertex<T> rootVertex;
/*     */ 
/*     */   public Graph()
/*     */   {
/*  55 */     this.verticies = new ArrayList();
/*  56 */     this.edges = new ArrayList();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/*  65 */     return this.verticies.size() == 0;
/*     */   }
/*     */ 
/*     */   public boolean addVertex(Vertex<T> v)
/*     */   {
/*  75 */     boolean added = false;
/*  76 */     if (!this.verticies.contains(v))
/*     */     {
/*  78 */       added = this.verticies.add(v);
/*     */     }
/*  80 */     return added;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*  89 */     return this.verticies.size();
/*     */   }
/*     */ 
/*     */   public Vertex<T> getRootVertex()
/*     */   {
/*  98 */     return this.rootVertex;
/*     */   }
/*     */ 
/*     */   public void setRootVertex(Vertex<T> root)
/*     */   {
/* 108 */     this.rootVertex = root;
/* 109 */     if (!this.verticies.contains(root))
/* 110 */       addVertex(root);
/*     */   }
/*     */ 
/*     */   public Vertex<T> getVertex(int n)
/*     */   {
/* 120 */     return (Vertex)this.verticies.get(n);
/*     */   }
/*     */ 
/*     */   public List<Vertex<T>> getVerticies()
/*     */   {
/* 130 */     return this.verticies;
/*     */   }
/*     */ 
/*     */   public boolean addEdge(Vertex<T> from, Vertex<T> to, int cost)
/*     */     throws IllegalArgumentException
/*     */   {
/* 146 */     if (!this.verticies.contains(from))
/* 147 */       throw new IllegalArgumentException("from is not in graph");
/* 148 */     if (!this.verticies.contains(to)) {
/* 149 */       throw new IllegalArgumentException("to is not in graph");
/*     */     }
/* 151 */     Edge e = new Edge(from, to, cost);
/* 152 */     if (from.findEdge(to) != null) {
/* 153 */       return false;
/*     */     }
/*     */ 
/* 156 */     from.addEdge(e);
/* 157 */     to.addEdge(e);
/* 158 */     this.edges.add(e);
/* 159 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean insertBiEdge(Vertex<T> from, Vertex<T> to, int cost)
/*     */     throws IllegalArgumentException
/*     */   {
/* 176 */     return (addEdge(from, to, cost)) && (addEdge(to, from, cost));
/*     */   }
/*     */ 
/*     */   public List<Edge<T>> getEdges()
/*     */   {
/* 185 */     return this.edges;
/*     */   }
/*     */ 
/*     */   public boolean removeVertex(Vertex<T> v)
/*     */   {
/* 195 */     if (!this.verticies.contains(v)) {
/* 196 */       return false;
/*     */     }
/* 198 */     this.verticies.remove(v);
/* 199 */     if (v == this.rootVertex) {
/* 200 */       this.rootVertex = null;
/*     */     }
/*     */ 
/* 203 */     for (int n = 0; n < v.getOutgoingEdgeCount(); n++)
/*     */     {
/* 205 */       Edge e = v.getOutgoingEdge(n);
/* 206 */       v.remove(e);
/* 207 */       Vertex to = e.getTo();
/* 208 */       to.remove(e);
/* 209 */       this.edges.remove(e);
/*     */     }
/* 211 */     for (int n = 0; n < v.getIncomingEdgeCount(); n++)
/*     */     {
/* 213 */       Edge e = v.getIncomingEdge(n);
/* 214 */       v.remove(e);
/* 215 */       Vertex predecessor = e.getFrom();
/* 216 */       predecessor.remove(e);
/*     */     }
/* 218 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean removeEdge(Vertex<T> from, Vertex<T> to)
/*     */   {
/* 229 */     Edge e = from.findEdge(to);
/* 230 */     if (e == null) {
/* 231 */       return false;
/*     */     }
/*     */ 
/* 234 */     from.remove(e);
/* 235 */     to.remove(e);
/* 236 */     this.edges.remove(e);
/* 237 */     return true;
/*     */   }
/*     */ 
/*     */   public void clearMark()
/*     */   {
/* 248 */     for (Vertex w : this.verticies)
/* 249 */       w.clearMark();
/*     */   }
/*     */ 
/*     */   public void clearEdges()
/*     */   {
/* 259 */     for (Edge e : this.edges)
/* 260 */       e.clearMark();
/*     */   }
/*     */ 
/*     */   public void depthFirstSearch(Vertex<T> v, Visitor<T> visitor)
/*     */   {
/* 271 */     VisitorEX wrapper = new VisitorEX(visitor)
/*     */     {
/*     */       public void visit(Graph<T> g, Vertex<T> v) throws RuntimeException
/*     */       {
/* 275 */         if (this.val$visitor != null)
/* 276 */           this.val$visitor.visit(g, v);
/*     */       }
/*     */     };
/* 279 */     depthFirstSearch(v, wrapper);
/*     */   }
/*     */ 
/*     */   public <E extends Exception> void depthFirstSearch(Vertex<T> v, VisitorEX<T, E> visitor)
/*     */     throws Exception
/*     */   {
/* 293 */     if (visitor != null)
/* 294 */       visitor.visit(this, v);
/* 295 */     v.visit();
/* 296 */     for (int i = 0; i < v.getOutgoingEdgeCount(); i++)
/*     */     {
/* 298 */       Edge e = v.getOutgoingEdge(i);
/* 299 */       if (e.getTo().visited())
/*     */         continue;
/* 301 */       depthFirstSearch(e.getTo(), visitor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void breadthFirstSearch(Vertex<T> v, Visitor<T> visitor)
/*     */   {
/* 315 */     VisitorEX wrapper = new VisitorEX(visitor)
/*     */     {
/*     */       public void visit(Graph<T> g, Vertex<T> v) throws RuntimeException
/*     */       {
/* 319 */         if (this.val$visitor != null)
/* 320 */           this.val$visitor.visit(g, v);
/*     */       }
/*     */     };
/* 323 */     breadthFirstSearch(v, wrapper);
/*     */   }
/*     */ 
/*     */   public <E extends Exception> void breadthFirstSearch(Vertex<T> v, VisitorEX<T, E> visitor)
/*     */     throws Exception
/*     */   {
/* 339 */     LinkedList q = new LinkedList();
/*     */ 
/* 341 */     q.add(v);
/* 342 */     if (visitor != null)
/* 343 */       visitor.visit(this, v);
/* 344 */     v.visit();
/* 345 */     while (!q.isEmpty())
/*     */     {
/* 347 */       v = (Vertex)q.removeFirst();
/* 348 */       for (int i = 0; i < v.getOutgoingEdgeCount(); i++)
/*     */       {
/* 350 */         Edge e = v.getOutgoingEdge(i);
/* 351 */         Vertex to = e.getTo();
/* 352 */         if (to.visited())
/*     */           continue;
/* 354 */         q.add(to);
/* 355 */         if (visitor != null)
/* 356 */           visitor.visit(this, to);
/* 357 */         to.visit();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void dfsSpanningTree(Vertex<T> v, DFSVisitor<T> visitor)
/*     */   {
/* 371 */     v.visit();
/* 372 */     if (visitor != null) {
/* 373 */       visitor.visit(this, v);
/*     */     }
/* 375 */     for (int i = 0; i < v.getOutgoingEdgeCount(); i++)
/*     */     {
/* 377 */       Edge e = v.getOutgoingEdge(i);
/* 378 */       if (e.getTo().visited())
/*     */         continue;
/* 380 */       if (visitor != null)
/* 381 */         visitor.visit(this, v, e);
/* 382 */       e.mark();
/* 383 */       dfsSpanningTree(e.getTo(), visitor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Vertex<T> findVertexByName(String name)
/*     */   {
/* 397 */     Vertex match = null;
/* 398 */     for (Vertex v : this.verticies)
/*     */     {
/* 400 */       if (name.equals(v.getName()))
/*     */       {
/* 402 */         match = v;
/* 403 */         break;
/*     */       }
/*     */     }
/* 406 */     return match;
/*     */   }
/*     */ 
/*     */   public Vertex<T> findVertexByData(T data, Comparator<T> compare)
/*     */   {
/* 419 */     Vertex match = null;
/* 420 */     for (Vertex v : this.verticies)
/*     */     {
/* 422 */       if (compare.compare(data, v.getData()) == 0)
/*     */       {
/* 424 */         match = v;
/* 425 */         break;
/*     */       }
/*     */     }
/* 428 */     return match;
/*     */   }
/*     */ 
/*     */   public Edge<T>[] findCycles()
/*     */   {
/* 442 */     ArrayList cycleEdges = new ArrayList();
/*     */ 
/* 444 */     for (int n = 0; n < this.verticies.size(); n++)
/*     */     {
/* 446 */       Vertex v = getVertex(n);
/* 447 */       v.setMarkState(1);
/*     */     }
/* 449 */     for (int n = 0; n < this.verticies.size(); n++)
/*     */     {
/* 451 */       Vertex v = getVertex(n);
/* 452 */       visit(v, cycleEdges);
/*     */     }
/*     */ 
/* 455 */     Edge[] cycles = new Edge[cycleEdges.size()];
/* 456 */     cycleEdges.toArray(cycles);
/* 457 */     return cycles;
/*     */   }
/*     */ 
/*     */   private void visit(Vertex<T> v, ArrayList<Edge<T>> cycleEdges)
/*     */   {
/* 462 */     v.setMarkState(2);
/* 463 */     int count = v.getOutgoingEdgeCount();
/* 464 */     for (int n = 0; n < count; n++)
/*     */     {
/* 466 */       Edge e = v.getOutgoingEdge(n);
/* 467 */       Vertex u = e.getTo();
/* 468 */       if (u.getMarkState() == 2)
/*     */       {
/* 471 */         cycleEdges.add(e);
/*     */       } else {
/* 473 */         if (u.getMarkState() != 1)
/*     */           continue;
/* 475 */         visit(u, cycleEdges);
/*     */       }
/*     */     }
/* 478 */     v.setMarkState(3);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 483 */     StringBuffer tmp = new StringBuffer("Graph[");
/* 484 */     for (Vertex v : this.verticies)
/* 485 */       tmp.append(v);
/* 486 */     tmp.append(']');
/* 487 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.graph.Graph
 * JD-Core Version:    0.6.0
 */