/*     */ package org.jboss.util.naming;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Map;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameAlreadyBoundException;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ 
/*     */ public class NonSerializableFactory
/*     */   implements ObjectFactory
/*     */ {
/*  90 */   private static Map wrapperMap = Collections.synchronizedMap(new HashMap());
/*     */ 
/*     */   public static synchronized void bind(String key, Object target)
/*     */     throws NameAlreadyBoundException
/*     */   {
/* 104 */     if (wrapperMap.containsKey(key) == true)
/* 105 */       throw new NameAlreadyBoundException(key + " already exists in the NonSerializableFactory map");
/* 106 */     wrapperMap.put(key, target);
/*     */   }
/*     */ 
/*     */   public static void rebind(String key, Object target)
/*     */   {
/* 119 */     wrapperMap.put(key, target);
/*     */   }
/*     */ 
/*     */   public static void unbind(String key)
/*     */     throws NameNotFoundException
/*     */   {
/* 130 */     if (wrapperMap.remove(key) == null)
/* 131 */       throw new NameNotFoundException(key + " was not found in the NonSerializableFactory map");
/*     */   }
/*     */ 
/*     */   public static void unbind(Name name)
/*     */     throws NameNotFoundException
/*     */   {
/* 142 */     String key = name.toString();
/* 143 */     if (wrapperMap.remove(key) == null)
/* 144 */       throw new NameNotFoundException(key + " was not found in the NonSerializableFactory map");
/*     */   }
/*     */ 
/*     */   public static Object lookup(String key)
/*     */   {
/* 152 */     Object value = wrapperMap.get(key);
/* 153 */     return value;
/*     */   }
/*     */ 
/*     */   public static Object lookup(Name name)
/*     */   {
/* 160 */     String key = name.toString();
/* 161 */     Object value = wrapperMap.get(key);
/* 162 */     return value;
/*     */   }
/*     */ 
/*     */   public static synchronized void rebind(Context ctx, String key, Object target)
/*     */     throws NamingException
/*     */   {
/* 176 */     rebind(key, target);
/*     */ 
/* 178 */     String className = target.getClass().getName();
/* 179 */     String factory = NonSerializableFactory.class.getName();
/* 180 */     StringRefAddr addr = new StringRefAddr("nns", key);
/* 181 */     Reference memoryRef = new Reference(className, addr, factory, null);
/* 182 */     ctx.rebind(key, memoryRef);
/*     */   }
/*     */ 
/*     */   public static synchronized void rebind(Name name, Object target)
/*     */     throws NamingException
/*     */   {
/* 198 */     rebind(name, target, false);
/*     */   }
/*     */ 
/*     */   public static synchronized void rebind(Name name, Object target, boolean createSubcontexts)
/*     */     throws NamingException
/*     */   {
/* 216 */     String key = name.toString();
/* 217 */     InitialContext ctx = new InitialContext();
/* 218 */     if ((createSubcontexts == true) && (name.size() > 1))
/*     */     {
/* 220 */       int size = name.size() - 1;
/* 221 */       Util.createSubcontext(ctx, name.getPrefix(size));
/*     */     }
/* 223 */     rebind(ctx, key, target);
/*     */   }
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env)
/*     */     throws Exception
/*     */   {
/* 244 */     Reference ref = (Reference)obj;
/* 245 */     RefAddr addr = ref.get("nns");
/* 246 */     String key = (String)addr.getContent();
/* 247 */     Object target = wrapperMap.get(key);
/* 248 */     return target;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.naming.NonSerializableFactory
 * JD-Core Version:    0.6.0
 */