/*     */ package org.jboss.util.platform;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Random;
/*     */ 
/*     */ public class PID
/*     */   implements Serializable, Cloneable
/*     */ {
/*     */   protected final int id;
/* 125 */   private static PID instance = null;
/*     */ 
/*     */   protected PID(int id)
/*     */   {
/*  49 */     this.id = id;
/*     */   }
/*     */ 
/*     */   public final int getID()
/*     */   {
/*  58 */     return this.id;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  67 */     return String.valueOf(this.id);
/*     */   }
/*     */ 
/*     */   public String toString(int radix)
/*     */   {
/*  76 */     return Integer.toString(this.id, radix);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  85 */     return this.id;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  95 */     if (obj == this) return true;
/*     */ 
/*  97 */     if ((obj != null) && (obj.getClass() == getClass())) {
/*  98 */       PID pid = (PID)obj;
/*  99 */       return pid.id == this.id;
/*     */     }
/*     */ 
/* 102 */     return false;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 112 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 115 */     throw new InternalError();
/*     */   }
/*     */ 
/*     */   public static synchronized PID getInstance()
/*     */   {
/* 133 */     if (instance == null) {
/* 134 */       instance = create();
/*     */     }
/* 136 */     return instance;
/*     */   }
/*     */ 
/*     */   private static PID create()
/*     */   {
/* 146 */     int random = Math.abs(new Random().nextInt());
/* 147 */     return new PID(random);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.platform.PID
 * JD-Core Version:    0.6.0
 */