/*     */ package org.jboss.util.property;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ 
/*     */ public class FilePropertyReader
/*     */   implements PropertyReader
/*     */ {
/*     */   protected String[] filenames;
/*     */ 
/*     */   public FilePropertyReader(String[] filenames)
/*     */   {
/*  54 */     if (filenames == null) {
/*  55 */       throw new NullArgumentException("filenames");
/*     */     }
/*  57 */     this.filenames = filenames;
/*     */   }
/*     */ 
/*     */   public FilePropertyReader(String filename)
/*     */   {
/*  66 */     this(new String[] { filename });
/*     */   }
/*     */ 
/*     */   protected InputStream getInputStream(String filename)
/*     */     throws IOException
/*     */   {
/*  78 */     File file = new File(filename);
/*  79 */     return new FileInputStream(file);
/*     */   }
/*     */ 
/*     */   protected void loadProperties(Properties props, String filename)
/*     */     throws IOException
/*     */   {
/*  94 */     if (filename == null)
/*  95 */       throw new NullArgumentException("filename");
/*  96 */     if (filename.equals("")) {
/*  97 */       throw new IllegalArgumentException("filename");
/*     */     }
/*  99 */     InputStream in = new BufferedInputStream(getInputStream(filename));
/* 100 */     props.load(in);
/* 101 */     in.close();
/*     */   }
/*     */ 
/*     */   public Map readProperties()
/*     */     throws PropertyException, IOException
/*     */   {
/* 115 */     Properties props = new Properties();
/*     */ 
/* 118 */     for (int i = 0; i < this.filenames.length; i++) {
/* 119 */       loadProperties(props, this.filenames[i]);
/*     */     }
/*     */ 
/* 122 */     return props;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.property.FilePropertyReader
 * JD-Core Version:    0.6.0
 */