/*     */ package org.jboss.util.property;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ 
/*     */ public class PropertyMap extends Properties
/*     */ {
/*     */   private static final long serialVersionUID = 8747802918099008518L;
/*     */   public static final String PROPERTY_NAME_SEPARATOR = ".";
/*  64 */   public static final String[] EMPTY_ARRAY_PROPERTY = new String[0];
/*     */   protected transient List unboundListeners;
/*     */   protected transient Map boundListeners;
/*     */   private transient Map jndiMap;
/*  80 */   private static final Object NULL_VALUE = new Object();
/*     */ 
/*     */   public PropertyMap(Properties defaults)
/*     */   {
/*  89 */     super(defaults);
/*  90 */     init();
/*     */   }
/*     */ 
/*     */   public PropertyMap()
/*     */   {
/*  98 */     this(null);
/*     */   }
/*     */ 
/*     */   private void init()
/*     */   {
/* 105 */     this.unboundListeners = Collections.synchronizedList(new ArrayList());
/* 106 */     this.boundListeners = Collections.synchronizedMap(new HashMap());
/* 107 */     this.jndiMap = new HashMap();
/*     */ 
/* 109 */     PrivilegedAction action = new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 113 */         Object value = System.getProperty("java.naming.provider.url");
/* 114 */         if (value == null) value = PropertyMap.NULL_VALUE;
/* 115 */         PropertyMap.this.jndiMap.put("java.naming.provider.url", value);
/*     */ 
/* 117 */         value = System.getProperty("java.naming.factory.initial");
/* 118 */         if (value == null) value = PropertyMap.NULL_VALUE;
/* 119 */         PropertyMap.this.jndiMap.put("java.naming.factory.initial", value);
/*     */ 
/* 121 */         value = System.getProperty("java.naming.factory.object");
/* 122 */         if (value == null) value = PropertyMap.NULL_VALUE;
/* 123 */         PropertyMap.this.jndiMap.put("java.naming.factory.object", value);
/*     */ 
/* 125 */         value = System.getProperty("java.naming.factory.url.pkgs");
/* 126 */         if (value == null) value = PropertyMap.NULL_VALUE;
/* 127 */         PropertyMap.this.jndiMap.put("java.naming.factory.url.pkgs", value);
/*     */ 
/* 129 */         value = System.getProperty("java.naming.factory.state");
/* 130 */         if (value == null) value = PropertyMap.NULL_VALUE;
/* 131 */         PropertyMap.this.jndiMap.put("java.naming.factory.state", value);
/*     */ 
/* 133 */         value = System.getProperty("java.naming.dns.url");
/* 134 */         if (value == null) value = PropertyMap.NULL_VALUE;
/* 135 */         PropertyMap.this.jndiMap.put("java.naming.dns.url", value);
/*     */ 
/* 137 */         value = System.getProperty("java.naming.factory.control");
/* 138 */         if (value == null) value = PropertyMap.NULL_VALUE;
/* 139 */         PropertyMap.this.jndiMap.put("java.naming.factory.control", value);
/* 140 */         return null;
/*     */       }
/*     */     };
/* 143 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   private void updateJndiCache(String name, String value)
/*     */   {
/* 152 */     if (name == null) {
/* 153 */       return;
/*     */     }
/* 155 */     boolean isJndiProperty = (name.equals("java.naming.provider.url")) || (name.equals("java.naming.factory.initial")) || (name.equals("java.naming.factory.object")) || (name.equals("java.naming.factory.url.pkgs")) || (name.equals("java.naming.factory.state")) || (name.equals("java.naming.dns.url")) || (name.equals("java.naming.factory.control"));
/*     */ 
/* 163 */     if (isJndiProperty == true)
/* 164 */       this.jndiMap.put(name, value);
/*     */   }
/*     */ 
/*     */   public Object put(Object name, Object value)
/*     */   {
/* 176 */     if (name == null) {
/* 177 */       throw new NullArgumentException("name");
/*     */     }
/*     */ 
/* 181 */     boolean add = !containsKey(name);
/* 182 */     Object prev = super.put(name, value);
/*     */ 
/* 184 */     PropertyEvent event = new PropertyEvent(this, name.toString(), value.toString());
/*     */ 
/* 188 */     if (add)
/*     */     {
/* 190 */       firePropertyAdded(event);
/*     */     }
/*     */     else
/*     */     {
/* 194 */       firePropertyChanged(event);
/*     */     }
/*     */ 
/* 197 */     return prev;
/*     */   }
/*     */ 
/*     */   public Object remove(Object name)
/*     */   {
/* 208 */     if (name == null) {
/* 209 */       throw new NullArgumentException("name");
/*     */     }
/*     */ 
/* 212 */     boolean contains = containsKey(name);
/* 213 */     Object value = null;
/*     */ 
/* 215 */     if (contains)
/*     */     {
/* 217 */       value = super.remove(name);
/* 218 */       if (this.defaults != null)
/*     */       {
/* 220 */         Object obj = this.defaults.remove(name);
/* 221 */         if (value == null)
/*     */         {
/* 223 */           value = obj;
/*     */         }
/*     */       }
/*     */ 
/* 227 */       this.jndiMap.remove(name);
/*     */ 
/* 229 */       PropertyEvent event = new PropertyEvent(this, name.toString(), value.toString());
/* 230 */       firePropertyRemoved(event);
/*     */     }
/*     */ 
/* 233 */     return value;
/*     */   }
/*     */ 
/*     */   public Set keySet(boolean includeDefaults)
/*     */   {
/* 242 */     if (includeDefaults)
/*     */     {
/* 244 */       Set set = new HashSet();
/* 245 */       set.addAll(this.defaults.keySet());
/* 246 */       set.addAll(super.keySet());
/* 247 */       return Collections.synchronizedSet(set);
/*     */     }
/*     */ 
/* 250 */     return super.keySet();
/*     */   }
/*     */ 
/*     */   public Set entrySet(boolean includeDefaults)
/*     */   {
/* 259 */     if (includeDefaults)
/*     */     {
/* 261 */       Set set = new HashSet();
/* 262 */       set.addAll(this.defaults.entrySet());
/* 263 */       set.addAll(super.entrySet());
/* 264 */       return Collections.synchronizedSet(set);
/*     */     }
/*     */ 
/* 267 */     return super.entrySet();
/*     */   }
/*     */ 
/*     */   public void addPropertyListener(PropertyListener listener)
/*     */   {
/* 277 */     if (listener == null) {
/* 278 */       throw new NullArgumentException("listener");
/*     */     }
/* 280 */     if ((listener instanceof BoundPropertyListener))
/*     */     {
/* 282 */       addPropertyListener((BoundPropertyListener)listener);
/*     */     }
/* 287 */     else if (!this.unboundListeners.contains(listener))
/* 288 */       this.unboundListeners.add(listener);
/*     */   }
/*     */ 
/*     */   protected void addPropertyListener(BoundPropertyListener listener)
/*     */   {
/* 300 */     String name = listener.getPropertyName();
/*     */ 
/* 303 */     List list = (List)this.boundListeners.get(name);
/*     */ 
/* 306 */     if (list == null)
/*     */     {
/* 308 */       list = Collections.synchronizedList(new ArrayList());
/* 309 */       this.boundListeners.put(name, list);
/*     */     }
/*     */ 
/* 313 */     if (!list.contains(listener))
/*     */     {
/* 315 */       list.add(listener);
/*     */ 
/* 317 */       listener.propertyBound(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addPropertyListeners(PropertyListener[] listeners)
/*     */   {
/* 328 */     if (listeners == null) {
/* 329 */       throw new NullArgumentException("listeners");
/*     */     }
/* 331 */     for (int i = 0; i < listeners.length; i++)
/*     */     {
/* 333 */       addPropertyListener(listeners[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean removePropertyListener(PropertyListener listener)
/*     */   {
/* 345 */     if (listener == null) {
/* 346 */       throw new NullArgumentException("listener");
/*     */     }
/* 348 */     boolean removed = false;
/* 349 */     if ((listener instanceof BoundPropertyListener))
/*     */     {
/* 351 */       removed = removePropertyListener((BoundPropertyListener)listener);
/*     */     }
/*     */     else
/*     */     {
/* 355 */       removed = this.unboundListeners.remove(listener);
/*     */     }
/*     */ 
/* 358 */     return removed;
/*     */   }
/*     */ 
/*     */   protected boolean removePropertyListener(BoundPropertyListener listener)
/*     */   {
/* 370 */     String name = listener.getPropertyName();
/*     */ 
/* 373 */     List list = (List)this.boundListeners.get(name);
/* 374 */     boolean removed = false;
/* 375 */     if (list != null)
/*     */     {
/* 377 */       removed = list.remove(listener);
/*     */ 
/* 380 */       if (removed) listener.propertyUnbound(this);
/*     */     }
/* 382 */     return removed;
/*     */   }
/*     */ 
/*     */   private void firePropertyAdded(List list, PropertyEvent event)
/*     */   {
/* 393 */     if (list == null) return;
/*     */ 
/* 395 */     int size = list.size();
/* 396 */     for (int i = 0; i < size; i++)
/*     */     {
/* 398 */       PropertyListener listener = (PropertyListener)list.get(i);
/* 399 */       listener.propertyAdded(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void firePropertyAdded(PropertyEvent event)
/*     */   {
/* 411 */     if (this.boundListeners != null)
/*     */     {
/* 413 */       List list = (List)this.boundListeners.get(event.getPropertyName());
/* 414 */       if (list != null)
/*     */       {
/* 416 */         firePropertyAdded(list, event);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 421 */     firePropertyAdded(this.unboundListeners, event);
/*     */   }
/*     */ 
/*     */   private void firePropertyRemoved(List list, PropertyEvent event)
/*     */   {
/* 432 */     if (list == null) return;
/*     */ 
/* 434 */     int size = list.size();
/* 435 */     for (int i = 0; i < size; i++)
/*     */     {
/* 437 */       PropertyListener listener = (PropertyListener)list.get(i);
/* 438 */       listener.propertyRemoved(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void firePropertyRemoved(PropertyEvent event)
/*     */   {
/* 450 */     if (this.boundListeners != null)
/*     */     {
/* 452 */       List list = (List)this.boundListeners.get(event.getPropertyName());
/* 453 */       if (list != null)
/*     */       {
/* 455 */         firePropertyRemoved(list, event);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 460 */     firePropertyRemoved(this.unboundListeners, event);
/*     */   }
/*     */ 
/*     */   private void firePropertyChanged(List list, PropertyEvent event)
/*     */   {
/* 471 */     if (list == null) return;
/*     */ 
/* 473 */     int size = list.size();
/* 474 */     for (int i = 0; i < size; i++)
/*     */     {
/* 476 */       PropertyListener listener = (PropertyListener)list.get(i);
/* 477 */       listener.propertyChanged(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void firePropertyChanged(PropertyEvent event)
/*     */   {
/* 489 */     if (this.boundListeners != null)
/*     */     {
/* 491 */       List list = (List)this.boundListeners.get(event.getPropertyName());
/* 492 */       if (list != null)
/*     */       {
/* 494 */         firePropertyChanged(list, event);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 499 */     firePropertyChanged(this.unboundListeners, event);
/*     */   }
/*     */ 
/*     */   protected String makePrefixedPropertyName(String base, String prefix)
/*     */   {
/* 511 */     String name = base;
/*     */ 
/* 513 */     if (prefix != null)
/*     */     {
/* 515 */       StringBuffer buff = new StringBuffer(base);
/* 516 */       if (prefix != null)
/*     */       {
/* 518 */         buff.insert(0, ".");
/* 519 */         buff.insert(0, prefix);
/*     */       }
/* 521 */       return buff.toString();
/*     */     }
/*     */ 
/* 524 */     return name;
/*     */   }
/*     */ 
/*     */   public void load(String prefix, Map map)
/*     */     throws PropertyException
/*     */   {
/* 536 */     if (map == null) {
/* 537 */       throw new NullArgumentException("map");
/*     */     }
/*     */ 
/* 540 */     Iterator iter = map.keySet().iterator();
/* 541 */     while (iter.hasNext())
/*     */     {
/* 544 */       String key = String.valueOf(iter.next());
/* 545 */       String name = makePrefixedPropertyName(key, prefix);
/* 546 */       String value = String.valueOf(map.get(name));
/*     */ 
/* 549 */       setProperty(name, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void load(Map map)
/*     */     throws PropertyException
/*     */   {
/* 560 */     load(null, map);
/*     */   }
/*     */ 
/*     */   public void load(PropertyReader reader)
/*     */     throws PropertyException, IOException
/*     */   {
/* 570 */     if (reader == null) {
/* 571 */       throw new NullArgumentException("reader");
/*     */     }
/* 573 */     load(reader.readProperties());
/*     */   }
/*     */ 
/*     */   public void load(String className)
/*     */     throws PropertyException, IOException
/*     */   {
/* 583 */     if (className == null) {
/* 584 */       throw new NullArgumentException("className");
/*     */     }
/* 586 */     PropertyReader reader = null;
/*     */     try
/*     */     {
/* 590 */       Class type = Class.forName(className);
/* 591 */       reader = (PropertyReader)type.newInstance();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 595 */       throw new PropertyException(e);
/*     */     }
/*     */ 
/* 599 */     load(reader);
/*     */   }
/*     */ 
/*     */   public Object setProperty(String name, String value)
/*     */   {
/* 614 */     updateJndiCache(name, value);
/* 615 */     return put(name, value);
/*     */   }
/*     */ 
/*     */   public String getProperty(String name)
/*     */   {
/* 620 */     Object value = this.jndiMap.get(name);
/* 621 */     if (value != null)
/*     */     {
/* 624 */       return value == NULL_VALUE ? null : (String)value;
/*     */     }
/* 626 */     return super.getProperty(name);
/*     */   }
/*     */ 
/*     */   public String removeProperty(String name)
/*     */   {
/* 637 */     return (String)remove(name);
/*     */   }
/*     */ 
/*     */   protected String makeIndexPropertyName(String base, int index)
/*     */   {
/* 650 */     return base + "." + index;
/*     */   }
/*     */ 
/*     */   public String[] getArrayProperty(String base, String[] defaultValues)
/*     */   {
/* 668 */     if (base == null) {
/* 669 */       throw new NullArgumentException("base");
/*     */     }
/*     */ 
/* 672 */     List list = new LinkedList();
/*     */ 
/* 674 */     int i = 0;
/*     */     while (true)
/*     */     {
/* 678 */       String name = makeIndexPropertyName(base, i);
/*     */ 
/* 681 */       String value = getProperty(name);
/*     */ 
/* 683 */       if (value != null)
/*     */       {
/* 685 */         list.add(value);
/*     */       }
/* 687 */       else if (i >= 0)
/*     */         {
/*     */           break;
/*     */         }
/*     */ 
/* 692 */       i++;
/*     */     }
/*     */ 
/* 695 */     String[] values = defaultValues;
/*     */ 
/* 698 */     if (list.size() != 0)
/*     */     {
/* 700 */       values = (String[])(String[])list.toArray(new String[list.size()]);
/*     */     }
/*     */ 
/* 703 */     return values;
/*     */   }
/*     */ 
/*     */   public String[] getArrayProperty(String name)
/*     */   {
/* 714 */     return getArrayProperty(name, EMPTY_ARRAY_PROPERTY);
/*     */   }
/*     */ 
/*     */   public Iterator names()
/*     */   {
/* 724 */     return keySet().iterator();
/*     */   }
/*     */ 
/*     */   public boolean containsProperty(String name)
/*     */   {
/* 735 */     return containsKey(name);
/*     */   }
/*     */ 
/*     */   public PropertyGroup getPropertyGroup(String basename)
/*     */   {
/* 746 */     return new PropertyGroup(basename, this);
/*     */   }
/*     */ 
/*     */   public PropertyGroup getPropertyGroup(String basename, int index)
/*     */   {
/* 758 */     String name = makeIndexPropertyName(basename, index);
/* 759 */     return getPropertyGroup(name);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream stream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 766 */     init();
/*     */ 
/* 768 */     stream.defaultReadObject();
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream stream)
/*     */     throws IOException
/*     */   {
/* 774 */     stream.defaultWriteObject();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.property.PropertyMap
 * JD-Core Version:    0.6.0
 */