/*     */ package org.jboss.util.property.jmx;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class SystemPropertyClassValue
/*     */   implements SystemPropertyClassValueMBean
/*     */ {
/*  42 */   public static final Logger log = Logger.getLogger(SystemPropertyClassValue.class);
/*     */   protected String property;
/*     */   protected String className;
/*     */ 
/*     */   public String getProperty()
/*     */   {
/*  64 */     return this.property;
/*     */   }
/*     */ 
/*     */   public void setProperty(String property)
/*     */   {
/*  74 */     this.property = property;
/*     */   }
/*     */ 
/*     */   public String getClassName()
/*     */   {
/*  85 */     return this.className;
/*     */   }
/*     */ 
/*     */   public void setClassName(String className)
/*     */   {
/*  96 */     this.className = className;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/* 106 */     Throwable error = setSystemPropertyClassValue(this.property, this.className);
/* 107 */     if (error != null)
/* 108 */       log.trace("Error loading class " + this.className + " property " + this.property + " not set.", error);
/*     */   }
/*     */ 
/*     */   public static Throwable setSystemPropertyClassValue(String property, String className)
/*     */   {
/* 122 */     if ((property == null) || (property.trim().length() == 0))
/* 123 */       throw new IllegalArgumentException("Null or empty property");
/* 124 */     if ((className == null) || (className.trim().length() == 0)) {
/* 125 */       throw new IllegalArgumentException("Null or empty class name");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 130 */       Thread.currentThread().getContextClassLoader().loadClass(className);
/*     */     }
/*     */     catch (Throwable problem)
/*     */     {
/* 134 */       return problem;
/*     */     }
/*     */ 
/* 138 */     System.setProperty(property, className);
/* 139 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.property.jmx.SystemPropertyClassValue
 * JD-Core Version:    0.6.0
 */