/*     */ package org.jboss.util.propertyeditor;
/*     */ 
/*     */ import java.beans.PropertyEditorSupport;
/*     */ import java.util.ArrayList;
/*     */ import java.util.regex.Pattern;
/*     */ 
/*     */ public class StringArrayEditor extends PropertyEditorSupport
/*     */ {
/*  40 */   Pattern commaDelim = Pattern.compile("','|[^,\r\n]+");
/*     */ 
/*     */   static String[] parseList(String text)
/*     */   {
/*  44 */     ArrayList list = new ArrayList();
/*  45 */     StringBuffer tmp = new StringBuffer();
/*  46 */     for (int n = 0; n < text.length(); n++)
/*     */     {
/*  48 */       char c = text.charAt(n);
/*  49 */       switch (c)
/*     */       {
/*     */       case '\\':
/*  52 */         tmp.append(c);
/*  53 */         if ((n >= text.length()) || (text.charAt(n + 1) != ','))
/*     */           continue;
/*  55 */         tmp.setCharAt(tmp.length() - 1, ',');
/*  56 */         n++; break;
/*     */       case '\n':
/*     */       case '\r':
/*     */       case ',':
/*  62 */         if (tmp.length() > 0)
/*  63 */           list.add(tmp.toString());
/*  64 */         tmp.setLength(0);
/*  65 */         break;
/*     */       default:
/*  67 */         tmp.append(c);
/*     */       }
/*     */     }
/*     */ 
/*  71 */     if (tmp.length() > 0) {
/*  72 */       list.add(tmp.toString());
/*     */     }
/*  74 */     String[] x = new String[list.size()];
/*  75 */     list.toArray(x);
/*  76 */     return x;
/*     */   }
/*     */ 
/*     */   public void setAsText(String text)
/*     */   {
/*  85 */     String[] theValue = parseList(text);
/*  86 */     setValue(theValue);
/*     */   }
/*     */ 
/*     */   public String getAsText()
/*     */   {
/*  94 */     String[] theValue = (String[])(String[])getValue();
/*  95 */     StringBuffer text = new StringBuffer();
/*  96 */     int length = theValue == null ? 0 : theValue.length;
/*  97 */     for (int n = 0; n < length; n++)
/*     */     {
/*  99 */       String s = theValue[n];
/* 100 */       if (s.equals(","))
/* 101 */         text.append('\\');
/* 102 */       text.append(s);
/* 103 */       text.append(',');
/*     */     }
/*     */ 
/* 106 */     if (text.length() > 0)
/* 107 */       text.setLength(text.length() - 1);
/* 108 */     return text.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.propertyeditor.StringArrayEditor
 * JD-Core Version:    0.6.0
 */