/*     */ package org.jboss.util.stream;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class Streams
/*     */ {
/*  42 */   private static final Logger log = Logger.getLogger(Streams.class);
/*     */   public static final int DEFAULT_BUFFER_SIZE = 2048;
/*     */ 
/*     */   public static boolean close(InputStream stream)
/*     */   {
/*  57 */     if (stream == null) {
/*  58 */       return true;
/*     */     }
/*     */ 
/*  61 */     boolean success = true;
/*     */     try
/*     */     {
/*  64 */       stream.close();
/*     */     }
/*     */     catch (IOException e) {
/*  67 */       success = false;
/*     */     }
/*     */ 
/*  70 */     return success;
/*     */   }
/*     */ 
/*     */   public static boolean close(OutputStream stream)
/*     */   {
/*  82 */     if (stream == null) {
/*  83 */       return true;
/*     */     }
/*     */ 
/*  86 */     boolean success = true;
/*     */     try
/*     */     {
/*  89 */       stream.close();
/*     */     }
/*     */     catch (IOException e) {
/*  92 */       success = false;
/*     */     }
/*     */ 
/*  95 */     return success;
/*     */   }
/*     */ 
/*     */   public static boolean close(Object stream)
/*     */   {
/* 109 */     boolean success = false;
/*     */ 
/* 111 */     if ((stream instanceof InputStream)) {
/* 112 */       success = close((InputStream)stream);
/*     */     }
/* 114 */     else if ((stream instanceof OutputStream)) {
/* 115 */       success = close((OutputStream)stream);
/*     */     }
/*     */     else {
/* 118 */       throw new IllegalArgumentException("stream is not an InputStream or OutputStream");
/*     */     }
/*     */ 
/* 122 */     return success;
/*     */   }
/*     */ 
/*     */   public static boolean close(InputStream[] streams)
/*     */   {
/* 133 */     boolean success = true;
/*     */ 
/* 135 */     for (int i = 0; i < streams.length; i++) {
/* 136 */       boolean rv = close(streams[i]);
/* 137 */       if (rv) continue; success = false;
/*     */     }
/*     */ 
/* 140 */     return success;
/*     */   }
/*     */ 
/*     */   public static boolean close(OutputStream[] streams)
/*     */   {
/* 151 */     boolean success = true;
/*     */ 
/* 153 */     for (int i = 0; i < streams.length; i++) {
/* 154 */       boolean rv = close(streams[i]);
/* 155 */       if (rv) continue; success = false;
/*     */     }
/*     */ 
/* 158 */     return success;
/*     */   }
/*     */ 
/*     */   public static boolean close(Object[] streams)
/*     */   {
/* 175 */     boolean success = true;
/*     */ 
/* 177 */     for (int i = 0; i < streams.length; i++) {
/* 178 */       boolean rv = close(streams[i]);
/* 179 */       if (rv) continue; success = false;
/*     */     }
/*     */ 
/* 182 */     return success;
/*     */   }
/*     */ 
/*     */   public static boolean fclose(OutputStream stream)
/*     */   {
/* 193 */     return (flush(stream)) && (close(stream));
/*     */   }
/*     */ 
/*     */   public static boolean fclose(OutputStream[] streams)
/*     */   {
/* 204 */     boolean success = true;
/*     */ 
/* 206 */     for (int i = 0; i < streams.length; i++) {
/* 207 */       boolean rv = fclose(streams[i]);
/* 208 */       if (rv) continue; success = false;
/*     */     }
/*     */ 
/* 211 */     return success;
/*     */   }
/*     */ 
/*     */   public static boolean flush(OutputStream stream)
/*     */   {
/* 228 */     if (stream == null) {
/* 229 */       return true;
/*     */     }
/*     */ 
/* 232 */     boolean success = true;
/*     */     try
/*     */     {
/* 235 */       stream.flush();
/*     */     }
/*     */     catch (IOException e) {
/* 238 */       success = false;
/*     */     }
/*     */ 
/* 241 */     return success;
/*     */   }
/*     */ 
/*     */   public static boolean flush(OutputStream[] streams)
/*     */   {
/* 252 */     boolean success = true;
/*     */ 
/* 254 */     for (int i = 0; i < streams.length; i++) {
/* 255 */       boolean rv = flush(streams[i]);
/* 256 */       if (rv) continue; success = false;
/*     */     }
/*     */ 
/* 259 */     return success;
/*     */   }
/*     */ 
/*     */   public static long copy(InputStream input, OutputStream output, byte[] buffer)
/*     */     throws IOException
/*     */   {
/* 285 */     long total = 0L;
/*     */ 
/* 288 */     boolean trace = log.isTraceEnabled();
/* 289 */     if (trace)
/* 290 */       log.trace("copying " + input + " to " + output + " with buffer size: " + buffer.length);
/*     */     int read;
/* 293 */     while ((read = input.read(buffer)) != -1) {
/* 294 */       output.write(buffer, 0, read);
/* 295 */       total += read;
/*     */ 
/* 297 */       if (trace) {
/* 298 */         log.trace("bytes read: " + read + "; total bytes read: " + total);
/*     */       }
/*     */     }
/*     */ 
/* 302 */     return total;
/*     */   }
/*     */ 
/*     */   public static long copy(InputStream input, OutputStream output, int size)
/*     */     throws IOException
/*     */   {
/* 320 */     return copy(input, output, new byte[size]);
/*     */   }
/*     */ 
/*     */   public static long copy(InputStream input, OutputStream output)
/*     */     throws IOException
/*     */   {
/* 336 */     return copy(input, output, 2048);
/*     */   }
/*     */ 
/*     */   public static long copyb(InputStream input, OutputStream output)
/*     */     throws IOException
/*     */   {
/* 353 */     if (!(input instanceof BufferedInputStream)) {
/* 354 */       input = new BufferedInputStream(input);
/*     */     }
/*     */ 
/* 357 */     if (!(output instanceof BufferedOutputStream)) {
/* 358 */       output = new BufferedOutputStream(output);
/*     */     }
/*     */ 
/* 361 */     long bytes = copy(input, output, 2048);
/*     */ 
/* 363 */     output.flush();
/*     */ 
/* 365 */     return bytes;
/*     */   }
/*     */ 
/*     */   public static long copySome(InputStream input, OutputStream output, byte[] buffer, long length)
/*     */     throws IOException
/*     */   {
/* 386 */     long total = 0L;
/*     */ 
/* 390 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 394 */     int readLength = Math.min((int)length, buffer.length);
/* 395 */     if (trace)
/* 396 */       log.trace("initial read length: " + readLength);
/*     */     int read;
/* 399 */     while ((readLength != 0) && ((read = input.read(buffer, 0, readLength)) != -1))
/*     */     {
/* 401 */       if (trace) log.trace("read bytes: " + read);
/* 402 */       output.write(buffer, 0, read);
/* 403 */       total += read;
/* 404 */       if (trace) log.trace("total bytes read: " + total);
/*     */ 
/* 407 */       readLength = Math.min((int)(length - total), buffer.length);
/* 408 */       if (!trace) continue; log.trace("next read length: " + readLength);
/*     */     }
/*     */ 
/* 411 */     return total;
/*     */   }
/*     */ 
/*     */   public static long copySome(InputStream input, OutputStream output, int size, long length)
/*     */     throws IOException
/*     */   {
/* 432 */     return copySome(input, output, new byte[size], length);
/*     */   }
/*     */ 
/*     */   public static long copySome(InputStream input, OutputStream output, long length)
/*     */     throws IOException
/*     */   {
/* 451 */     return copySome(input, output, 2048, length);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.stream.Streams
 * JD-Core Version:    0.6.0
 */