/*     */ package org.jboss.util.timeout;
/*     */ 
/*     */ import java.util.concurrent.atomic.AtomicBoolean;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.jboss.util.ThrowableHandler;
/*     */ import org.jboss.util.threadpool.BasicThreadPool;
/*     */ import org.jboss.util.threadpool.BlockingMode;
/*     */ import org.jboss.util.threadpool.ThreadPool;
/*     */ 
/*     */ public class TimeoutFactory
/*     */ {
/*  44 */   private static final String priorityQueueProperty = TimeoutPriorityQueue.class.getName();
/*     */ 
/*  47 */   private static final String priorityQueueName = TimeoutPriorityQueueImpl.class.getName();
/*     */   private static TimeoutFactory singleton;
/*  53 */   private static int timeoutFactoriesCount = 0;
/*     */   private static Class priorityQueueClass;
/*  59 */   private static BasicThreadPool DEFAULT_TP = new BasicThreadPool("Timeouts");
/*     */ 
/*  86 */   private AtomicBoolean cancelled = new AtomicBoolean(false);
/*     */   private Thread workerThread;
/*     */   private ThreadPool threadPool;
/*     */   private TimeoutPriorityQueue queue;
/*     */ 
/*     */   public static synchronized TimeoutFactory getSingleton()
/*     */   {
/* 101 */     if (singleton == null)
/*     */     {
/* 103 */       singleton = new TimeoutFactory(DEFAULT_TP);
/*     */     }
/* 105 */     return singleton;
/*     */   }
/*     */ 
/*     */   public static Timeout createTimeout(long time, TimeoutTarget target)
/*     */   {
/* 113 */     return getSingleton().schedule(time, target);
/*     */   }
/*     */ 
/*     */   public TimeoutFactory(ThreadPool threadPool)
/*     */   {
/* 121 */     this.threadPool = threadPool;
/*     */     try
/*     */     {
/* 124 */       this.queue = ((TimeoutPriorityQueue)priorityQueueClass.newInstance());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 128 */       throw new RuntimeException("Cannot instantiate " + priorityQueueClass, e);
/*     */     }
/*     */ 
/* 132 */     this.workerThread = new Thread("TimeoutFactory-" + timeoutFactoriesCount++)
/*     */     {
/*     */       public void run()
/*     */       {
/* 136 */         TimeoutFactory.this.doWork();
/*     */       }
/*     */     };
/* 139 */     this.workerThread.setDaemon(true);
/* 140 */     this.workerThread.start();
/*     */   }
/*     */ 
/*     */   public TimeoutFactory()
/*     */   {
/* 148 */     this(DEFAULT_TP);
/*     */   }
/*     */ 
/*     */   public Timeout schedule(long time, TimeoutTarget target)
/*     */   {
/* 159 */     if (this.cancelled.get())
/* 160 */       throw new IllegalStateException("TimeoutFactory has been cancelled");
/* 161 */     if (time < 0L)
/* 162 */       throw new IllegalArgumentException("Negative time");
/* 163 */     if (target == null) {
/* 164 */       throw new IllegalArgumentException("Null timeout target");
/*     */     }
/* 166 */     return this.queue.offer(time, target);
/*     */   }
/*     */ 
/*     */   public Timeout schedule(long time, Runnable run)
/*     */   {
/* 177 */     return schedule(time, new TimeoutTargetImpl(run));
/*     */   }
/*     */ 
/*     */   public void cancel()
/*     */   {
/* 192 */     if (!this.cancelled.getAndSet(true))
/*     */     {
/* 195 */       this.queue.cancel();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isCancelled()
/*     */   {
/* 205 */     return this.cancelled.get();
/*     */   }
/*     */ 
/*     */   private void doWork()
/*     */   {
/* 213 */     while (!this.cancelled.get())
/*     */     {
/* 215 */       TimeoutExt work = this.queue.take();
/*     */ 
/* 217 */       if (work != null)
/*     */       {
/* 220 */         TimeoutWorker worker = new TimeoutWorker(work);
/*     */         try
/*     */         {
/* 223 */           this.threadPool.run(worker);
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 228 */           ThrowableHandler.add(1, t);
/*     */         }
/* 230 */         synchronized (work)
/*     */         {
/* 232 */           work.done();
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 238 */     this.queue.cancel();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  62 */     DEFAULT_TP.setBlockingMode(BlockingMode.RUN);
/*     */ 
/*  64 */     String priorityQueueClassName = priorityQueueName;
/*  65 */     ClassLoader cl = TimeoutFactory.class.getClassLoader();
/*     */     try
/*     */     {
/*  68 */       priorityQueueClassName = System.getProperty(priorityQueueProperty, priorityQueueName);
/*  69 */       cl = Thread.currentThread().getContextClassLoader();
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  77 */       priorityQueueClass = cl.loadClass(priorityQueueClassName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  81 */       throw new NestedRuntimeException(e.toString(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class TimeoutTargetImpl
/*     */     implements TimeoutTarget
/*     */   {
/*     */     Runnable runnable;
/*     */ 
/*     */     TimeoutTargetImpl(Runnable runnable)
/*     */     {
/* 288 */       this.runnable = runnable;
/*     */     }
/*     */ 
/*     */     public void timedOut(Timeout ignored)
/*     */     {
/* 293 */       this.runnable.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class TimeoutWorker
/*     */     implements Runnable
/*     */   {
/*     */     private TimeoutExt work;
/*     */ 
/*     */     TimeoutWorker(TimeoutExt work)
/*     */     {
/* 255 */       this.work = work;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 265 */         this.work.getTimeoutTarget().timedOut(this.work);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 270 */         ThrowableHandler.add(1, t);
/*     */       }
/* 272 */       synchronized (this.work)
/*     */       {
/* 274 */         this.work.done();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.timeout.TimeoutFactory
 * JD-Core Version:    0.6.0
 */