/*     */ package org.jboss.util.timeout;
/*     */ 
/*     */ public class TimeoutPriorityQueueImpl
/*     */   implements TimeoutPriorityQueue
/*     */ {
/* 177 */   private Object lock = new Object();
/*     */   private int size;
/*     */   private TimeoutExtImpl[] queue;
/*     */ 
/*     */   public TimeoutPriorityQueueImpl()
/*     */   {
/* 190 */     this.queue = new TimeoutExtImpl[16];
/* 191 */     this.size = 0;
/*     */   }
/*     */ 
/*     */   public TimeoutExt offer(long time, TimeoutTarget target)
/*     */   {
/* 196 */     if (this.queue == null)
/* 197 */       throw new IllegalStateException("TimeoutPriorityQueue has been cancelled");
/* 198 */     if (time < 0L)
/* 199 */       throw new IllegalArgumentException("Negative time");
/* 200 */     if (target == null) {
/* 201 */       throw new IllegalArgumentException("Null timeout target");
/*     */     }
/* 203 */     synchronized (this.lock)
/*     */     {
/* 207 */       if (++this.size == this.queue.length)
/*     */       {
/* 209 */         TimeoutExtImpl[] newQ = new TimeoutExtImpl[2 * this.queue.length];
/* 210 */         System.arraycopy(this.queue, 0, newQ, 0, this.queue.length);
/* 211 */         this.queue = newQ;
/*     */       }
/*     */ 
/* 216 */       TimeoutExtImpl timeout = this.queue[this.size] =  = new TimeoutExtImpl(null);
/* 217 */       timeout.index = this.size;
/* 218 */       timeout.time = time;
/* 219 */       timeout.target = target;
/* 220 */       normalizeUp(this.size);
/* 221 */       if (timeout.index == 1) {
/* 222 */         this.lock.notify();
/*     */       }
/* 224 */       return timeout;
/*     */     }
/*     */   }
/*     */ 
/*     */   public TimeoutExt take()
/*     */   {
/* 230 */     return poll(-1L);
/*     */   }
/*     */ 
/*     */   public TimeoutExt poll()
/*     */   {
/* 235 */     return poll(1L);
/*     */   }
/*     */ 
/*     */   public TimeoutExt poll(long wait)
/*     */   {
/* 240 */     long endWait = -1L;
/* 241 */     if (wait > 0L) {
/* 242 */       endWait = System.currentTimeMillis() + wait;
/*     */     }
/* 244 */     synchronized (this.lock)
/*     */     {
/* 246 */       while ((this.queue != null) && ((wait >= 0L) || (endWait == -1L)))
/*     */       {
/* 248 */         if (this.size == 0)
/*     */         {
/*     */           try
/*     */           {
/* 252 */             if (endWait == -1L)
/* 253 */               this.lock.wait();
/*     */             else
/* 255 */               this.lock.wait(wait);
/*     */           }
/*     */           catch (InterruptedException ex)
/*     */           {
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 263 */           long now = System.currentTimeMillis();
/* 264 */           if (this.queue[1].time > now)
/*     */           {
/* 266 */             long waitForFirst = this.queue[1].time - now;
/* 267 */             if ((endWait != -1L) && (waitForFirst > wait))
/* 268 */               waitForFirst = wait;
/*     */             try
/*     */             {
/* 271 */               this.lock.wait(waitForFirst);
/*     */             }
/*     */             catch (InterruptedException ex)
/*     */             {
/*     */             }
/*     */           }
/* 277 */           if ((this.size > 0) && (this.queue != null) && (this.queue[1].time <= System.currentTimeMillis()))
/*     */           {
/* 279 */             TimeoutExtImpl result = removeNode(1);
/* 280 */             result.index = -2;
/* 281 */             return result;
/*     */           }
/*     */         }
/* 284 */         if (endWait != -1L)
/* 285 */           wait = endWait - System.currentTimeMillis();
/*     */       }
/*     */     }
/* 288 */     return null;
/*     */   }
/*     */ 
/*     */   public TimeoutExt peek()
/*     */   {
/* 293 */     synchronized (this.lock)
/*     */     {
/* 295 */       if (this.size > 0) {
/* 296 */         return this.queue[1];
/*     */       }
/* 298 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean remove(TimeoutExt timeout)
/*     */   {
/* 304 */     TimeoutExtImpl timeoutImpl = (TimeoutExtImpl)timeout;
/* 305 */     synchronized (this.lock)
/*     */     {
/* 307 */       if (timeoutImpl.index > 0)
/*     */       {
/* 312 */         removeNode(timeoutImpl.index);
/*     */ 
/* 314 */         timeoutImpl.index = -1;
/*     */ 
/* 317 */         return true;
/*     */       }
/*     */ 
/* 323 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 330 */     synchronized (this.lock)
/*     */     {
/* 332 */       if (this.queue == null) {
/* 333 */         return;
/*     */       }
/*     */ 
/* 336 */       for (int i = 1; i <= this.size; i++)
/* 337 */         this.queue[i] = cleanupTimeoutExtImpl(this.queue[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void cancel()
/*     */   {
/* 343 */     synchronized (this.lock)
/*     */     {
/* 345 */       if (this.queue == null)
/* 346 */         return;
/* 347 */       clear();
/* 348 */       this.queue = null;
/* 349 */       this.size = 0;
/* 350 */       this.lock.notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 356 */     return this.size;
/*     */   }
/*     */ 
/*     */   public boolean isCancelled()
/*     */   {
/* 366 */     return this.queue == null;
/*     */   }
/*     */ 
/*     */   private boolean normalizeUp(int index)
/*     */   {
/* 380 */     if (index == 1)
/* 381 */       return false;
/* 382 */     boolean ret = false;
/* 383 */     long t = this.queue[index].time;
/* 384 */     int p = index >> 1;
/* 385 */     while (this.queue[p].time > t)
/*     */     {
/* 388 */       swap(p, index);
/* 389 */       ret = true;
/* 390 */       if (p == 1)
/*     */         break;
/* 392 */       index = p;
/* 393 */       p >>= 1;
/*     */     }
/* 395 */     return ret;
/*     */   }
/*     */ 
/*     */   private void swap(int a, int b)
/*     */   {
/* 414 */     TimeoutExtImpl temp = this.queue[a];
/* 415 */     this.queue[a] = this.queue[b];
/* 416 */     this.queue[a].index = a;
/* 417 */     this.queue[b] = temp;
/* 418 */     this.queue[b].index = b;
/*     */   }
/*     */ 
/*     */   private TimeoutExtImpl removeNode(int index)
/*     */   {
/* 431 */     TimeoutExtImpl res = this.queue[index];
/*     */ 
/* 434 */     if (index == this.size)
/*     */     {
/* 436 */       this.size -= 1;
/* 437 */       this.queue[index] = null;
/* 438 */       return res;
/*     */     }
/* 440 */     swap(index, this.size);
/* 441 */     this.size -= 1;
/*     */ 
/* 443 */     this.queue[res.index] = null;
/* 444 */     if (normalizeUp(index))
/* 445 */       return res;
/* 446 */     long t = this.queue[index].time;
/* 447 */     int c = index << 1;
/* 448 */     while (c <= this.size)
/*     */     {
/* 451 */       TimeoutExtImpl l = this.queue[c];
/*     */ 
/* 454 */       if (c + 1 <= this.size)
/*     */       {
/* 457 */         TimeoutExtImpl r = this.queue[(c + 1)];
/*     */ 
/* 460 */         if (l.time <= r.time)
/*     */         {
/* 462 */           if (t <= l.time)
/*     */             break;
/* 464 */           swap(index, c);
/* 465 */           index = c;
/*     */         }
/*     */         else
/*     */         {
/* 469 */           if (t <= r.time)
/*     */             break;
/* 471 */           swap(index, c + 1);
/* 472 */           index = c + 1;
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 477 */         if (t <= l.time)
/*     */           break;
/* 479 */         swap(index, c);
/* 480 */         index = c;
/*     */       }
/* 482 */       c = index << 1;
/*     */     }
/* 484 */     return res;
/*     */   }
/*     */ 
/*     */   private TimeoutExtImpl cleanupTimeoutExtImpl(TimeoutExtImpl timeout)
/*     */   {
/* 494 */     if (timeout != null)
/* 495 */       timeout.target = null;
/* 496 */     return null;
/*     */   }
/*     */ 
/*     */   void checkTree()
/*     */   {
/* 504 */     assertExpr(this.size >= 0);
/* 505 */     assertExpr(this.size < this.queue.length);
/* 506 */     assertExpr(this.queue[0] == null);
/* 507 */     if (this.size > 0)
/*     */     {
/* 509 */       assertExpr(this.queue[1] != null);
/* 510 */       assertExpr(this.queue[1].index == 1);
/* 511 */       for (int i = 2; i <= this.size; i++)
/*     */       {
/* 513 */         assertExpr(this.queue[i] != null);
/* 514 */         assertExpr(this.queue[i].index == i);
/* 515 */         assertExpr(this.queue[(i >> 1)].time <= this.queue[i].time);
/*     */       }
/* 517 */       for (int i = this.size + 1; i < this.queue.length; i++)
/* 518 */         assertExpr(this.queue[i] == null);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void assertExpr(boolean expr)
/*     */   {
/* 527 */     if (!expr)
/* 528 */       throw new IllegalStateException("***** assert failed *****");
/*     */   }
/*     */ 
/*     */   private class TimeoutExtImpl
/*     */     implements TimeoutExt
/*     */   {
/*     */     static final int DONE = -1;
/*     */     static final int TIMEOUT = -2;
/*     */     int index;
/*     */     long time;
/*     */     TimeoutTarget target;
/*     */ 
/*     */     private TimeoutExtImpl()
/*     */     {
/*     */     }
/*     */ 
/*     */     public long getTime()
/*     */     {
/* 553 */       return this.time;
/*     */     }
/*     */ 
/*     */     public TimeoutTarget getTimeoutTarget()
/*     */     {
/* 558 */       return this.target;
/*     */     }
/*     */ 
/*     */     public void done()
/*     */     {
/* 563 */       this.index = -1;
/*     */     }
/*     */ 
/*     */     public boolean cancel()
/*     */     {
/* 568 */       return TimeoutPriorityQueueImpl.this.remove(this);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.timeout.TimeoutPriorityQueueImpl
 * JD-Core Version:    0.6.0
 */