/*     */ package org.jboss.util.xml;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class JBossEntityResolver
/*     */   implements EntityResolver
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(JBossEntityResolver.class);
/*     */ 
/*  58 */   private static Map entities = new ConcurrentHashMap();
/*     */   private static boolean warnOnNonFileURLs;
/*  64 */   private boolean entityResolved = false;
/*     */   private Map localEntities;
/*     */ 
/*     */   public static Map getEntityMap()
/*     */   {
/* 182 */     return Collections.unmodifiableMap(entities);
/*     */   }
/*     */ 
/*     */   public static boolean isWarnOnNonFileURLs()
/*     */   {
/* 187 */     return warnOnNonFileURLs;
/*     */   }
/*     */ 
/*     */   public static void setWarnOnNonFileURLs(boolean warnOnNonFileURLs)
/*     */   {
/* 192 */     warnOnNonFileURLs = warnOnNonFileURLs;
/*     */   }
/*     */ 
/*     */   public static void registerEntity(String id, String dtdFileName)
/*     */   {
/* 205 */     entities.put(id, dtdFileName);
/*     */   }
/*     */ 
/*     */   public synchronized void registerLocalEntity(String id, String dtdOrSchema)
/*     */   {
/* 218 */     if (this.localEntities == null)
/* 219 */       this.localEntities = new ConcurrentHashMap();
/* 220 */     this.localEntities.put(id, dtdOrSchema);
/*     */   }
/*     */ 
/*     */   public InputSource resolveEntity(String publicId, String systemId)
/*     */     throws SAXException, IOException
/*     */   {
/* 250 */     this.entityResolved = false;
/*     */ 
/* 253 */     if ((publicId == null) && (systemId == null)) {
/* 254 */       return null;
/*     */     }
/* 256 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 259 */     InputSource inputSource = resolvePublicID(publicId, trace);
/*     */ 
/* 261 */     if (inputSource == null)
/*     */     {
/* 264 */       inputSource = resolveSystemID(systemId, trace);
/*     */     }
/*     */ 
/* 267 */     if (inputSource == null)
/*     */     {
/* 270 */       inputSource = resolveClasspathName(systemId, trace);
/*     */     }
/*     */ 
/* 273 */     if (inputSource == null)
/*     */     {
/* 276 */       inputSource = resolveSystemIDasURL(systemId, trace);
/*     */     }
/*     */ 
/* 279 */     this.entityResolved = (inputSource != null);
/*     */ 
/* 281 */     if (!this.entityResolved) {
/* 282 */       log.debug("Cannot resolve [publicID=" + publicId + ",systemID=" + systemId + "]");
/*     */     }
/* 284 */     return inputSource;
/*     */   }
/*     */ 
/*     */   public boolean isEntityResolved()
/*     */   {
/* 296 */     return this.entityResolved;
/*     */   }
/*     */ 
/*     */   protected InputSource resolvePublicID(String publicId, boolean trace)
/*     */   {
/* 310 */     if (publicId == null) {
/* 311 */       return null;
/*     */     }
/* 313 */     if (trace) {
/* 314 */       log.trace("resolvePublicID, publicId=" + publicId);
/*     */     }
/* 316 */     InputSource inputSource = null;
/*     */ 
/* 318 */     String filename = null;
/* 319 */     if (this.localEntities != null)
/* 320 */       filename = (String)this.localEntities.get(publicId);
/* 321 */     if (filename == null) {
/* 322 */       filename = (String)entities.get(publicId);
/*     */     }
/* 324 */     if (filename != null)
/*     */     {
/* 326 */       if (trace) {
/* 327 */         log.trace("Found entity from publicId=" + publicId + " fileName=" + filename);
/*     */       }
/* 329 */       InputStream ins = loadClasspathResource(filename, trace);
/* 330 */       if (ins != null)
/*     */       {
/* 332 */         inputSource = new InputSource(ins);
/* 333 */         inputSource.setPublicId(publicId);
/*     */       }
/*     */       else
/*     */       {
/* 337 */         log.trace("Cannot load publicId from classpath resource: " + filename);
/*     */ 
/* 340 */         inputSource = resolveSystemIDasURL(filename, trace);
/*     */ 
/* 342 */         if (inputSource == null) {
/* 343 */           log.warn("Cannot load publicId from resource: " + filename);
/*     */         }
/*     */       }
/*     */     }
/* 347 */     return inputSource;
/*     */   }
/*     */ 
/*     */   protected InputSource resolveSystemID(String systemId, boolean trace)
/*     */   {
/* 362 */     if (systemId == null) {
/* 363 */       return null;
/*     */     }
/* 365 */     if (trace) {
/* 366 */       log.trace("resolveSystemID, systemId=" + systemId);
/*     */     }
/* 368 */     InputSource inputSource = null;
/*     */ 
/* 371 */     String filename = null;
/* 372 */     if (this.localEntities != null)
/* 373 */       filename = (String)this.localEntities.get(systemId);
/* 374 */     if (filename == null) {
/* 375 */       filename = (String)entities.get(systemId);
/*     */     }
/* 377 */     if (filename != null)
/*     */     {
/* 379 */       if (trace) {
/* 380 */         log.trace("Found entity systemId=" + systemId + " fileName=" + filename);
/*     */       }
/* 382 */       InputStream ins = loadClasspathResource(filename, trace);
/* 383 */       if (ins != null)
/*     */       {
/* 385 */         inputSource = new InputSource(ins);
/* 386 */         inputSource.setSystemId(systemId);
/*     */       }
/*     */       else
/*     */       {
/* 390 */         log.warn("Cannot load systemId from resource: " + filename);
/*     */       }
/*     */     }
/*     */ 
/* 394 */     return inputSource;
/*     */   }
/*     */ 
/*     */   protected InputSource resolveSystemIDasURL(String systemId, boolean trace)
/*     */   {
/* 408 */     if (systemId == null) {
/* 409 */       return null;
/*     */     }
/* 411 */     if (trace) {
/* 412 */       log.trace("resolveSystemIDasURL, systemId=" + systemId);
/*     */     }
/* 414 */     InputSource inputSource = null;
/*     */     try
/*     */     {
/* 419 */       if (trace) {
/* 420 */         log.trace("Trying to resolve systemId as a URL");
/*     */       }
/* 422 */       URL url = new URL(systemId);
/* 423 */       if ((warnOnNonFileURLs) && (!url.getProtocol().equalsIgnoreCase("file")))
/*     */       {
/* 425 */         log.warn("Trying to resolve systemId as a non-file URL: " + systemId);
/*     */       }
/*     */ 
/* 428 */       InputStream ins = url.openStream();
/* 429 */       if (ins != null)
/*     */       {
/* 431 */         inputSource = new InputSource(ins);
/* 432 */         inputSource.setSystemId(systemId);
/*     */       }
/*     */       else
/*     */       {
/* 436 */         log.warn("Cannot load systemId as URL: " + systemId);
/*     */       }
/*     */ 
/* 439 */       if (trace)
/* 440 */         log.trace("Resolved systemId as a URL");
/*     */     }
/*     */     catch (MalformedURLException ignored)
/*     */     {
/* 444 */       if (trace)
/* 445 */         log.trace("SystemId is not a url: " + systemId, ignored);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 449 */       if (trace)
/* 450 */         log.trace("Failed to obtain URL.InputStream from systemId: " + systemId, e);
/*     */     }
/* 452 */     return inputSource;
/*     */   }
/*     */ 
/*     */   protected InputSource resolveClasspathName(String systemId, boolean trace)
/*     */   {
/* 466 */     if (systemId == null) {
/* 467 */       return null;
/*     */     }
/* 469 */     if (trace)
/* 470 */       log.trace("resolveClasspathName, systemId=" + systemId);
/* 471 */     String filename = systemId;
/*     */     try
/*     */     {
/* 475 */       URI url = new URI(systemId);
/* 476 */       String path = url.getPath();
/* 477 */       if (path == null)
/* 478 */         path = url.getSchemeSpecificPart();
/* 479 */       int slash = path.lastIndexOf('/');
/* 480 */       if (slash >= 0)
/* 481 */         filename = path.substring(slash + 1);
/*     */       else {
/* 483 */         filename = path;
/*     */       }
/* 485 */       if (path.length() == 0) {
/* 486 */         return null;
/*     */       }
/* 488 */       if (trace)
/* 489 */         log.trace("Mapped systemId to filename: " + filename);
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/* 493 */       if (trace) {
/* 494 */         log.trace("systemId: is not a URI, using systemId as resource", e);
/*     */       }
/*     */     }
/*     */ 
/* 498 */     InputStream is = loadClasspathResource(filename, trace);
/* 499 */     InputSource inputSource = null;
/* 500 */     if (is != null)
/*     */     {
/* 502 */       inputSource = new InputSource(is);
/* 503 */       inputSource.setSystemId(systemId);
/*     */     }
/* 505 */     return inputSource;
/*     */   }
/*     */ 
/*     */   protected InputStream loadClasspathResource(String resource, boolean trace)
/*     */   {
/* 520 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 521 */     URL url = loader.getResource(resource);
/* 522 */     if (url == null)
/*     */     {
/* 527 */       if (resource.endsWith(".dtd"))
/* 528 */         resource = "dtd/" + resource;
/* 529 */       else if (resource.endsWith(".xsd"))
/* 530 */         resource = "schema/" + resource;
/* 531 */       url = loader.getResource(resource);
/*     */     }
/*     */ 
/* 534 */     InputStream inputStream = null;
/* 535 */     if (url != null)
/*     */     {
/* 537 */       if (trace)
/* 538 */         log.trace(resource + " maps to URL: " + url);
/*     */       try
/*     */       {
/* 541 */         inputStream = url.openStream();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 545 */         log.debug("Failed to open url stream", e);
/*     */       }
/*     */     }
/* 548 */     return inputStream;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  70 */     AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/*  74 */         JBossEntityResolver.access$002(new Boolean(System.getProperty("org.jboss.resolver.warning", "false")).booleanValue());
/*  75 */         return null;
/*     */       }
/*     */     });
/*  78 */     registerEntity("http://java.sun.com/xml/ns/j2ee/application_1_4.xsd", "application_1_4.xsd");
/*  79 */     registerEntity("http://java.sun.com/xml/ns/javaee/application_5.xsd", "application_5.xsd");
/*  80 */     registerEntity("http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd", "application-client_1_4.xsd");
/*  81 */     registerEntity("http://java.sun.com/xml/ns/javaee/application-client_5.xsd", "application-client_5.xsd");
/*  82 */     registerEntity("http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd", "connector_1_5.xsd");
/*  83 */     registerEntity("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd", "ejb-jar_2_1.xsd");
/*  84 */     registerEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", "j2ee_1_4.xsd");
/*  85 */     registerEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", "web-app_2_4.xsd");
/*  86 */     registerEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_5.xsd", "web-app_2_5.xsd");
/*  87 */     registerEntity("http://schemas.xmlsoap.org/soap/encoding/", "soap-encoding_1_1.xsd");
/*  88 */     registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", "j2ee_web_services_client_1_1.xsd");
/*  89 */     registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", "j2ee_web_services_1_1.xsd");
/*  90 */     registerEntity("http://www.ibm.com/webservices/xsd/j2ee_jaxrpc_mapping_1_1.xsd", "j2ee_jaxrpc_mapping_1_1.xsd");
/*  91 */     registerEntity("http://www.w3.org/2001/xml.xsd", "xml.xsd");
/*  92 */     registerEntity("http://www.w3.org/2005/05/xmlmime", "xml-media-types.xsd");
/*     */ 
/*  94 */     registerEntity("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", "ejb-jar.dtd");
/*  95 */     registerEntity("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "ejb-jar_2_0.dtd");
/*     */ 
/*  97 */     registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "application_1_2.dtd");
/*  98 */     registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "application_1_3.dtd");
/*  99 */     registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "application-client_1_3.dtd");
/*     */ 
/* 101 */     registerEntity("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "connector_1_0.dtd");
/*     */ 
/* 103 */     registerEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "web-app_2_2.dtd");
/* 104 */     registerEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-app_2_3.dtd");
/*     */ 
/* 106 */     registerEntity("-//JBoss//DTD J2EE Application 1.3//EN", "jboss-app_3_0.dtd");
/* 107 */     registerEntity("-//JBoss//DTD J2EE Application 1.3V2//EN", "jboss-app_3_2.dtd");
/* 108 */     registerEntity("-//JBoss//DTD J2EE Application 1.4//EN", "jboss-app_4_0.dtd");
/* 109 */     registerEntity("-//JBoss//DTD J2EE Application 4.2//EN", "jboss-app_4_2.dtd");
/* 110 */     registerEntity("-//JBoss//DTD Java EE Application 5.0//EN", "jboss-app_5_0.dtd");
/* 111 */     registerEntity("-//JBoss//DTD JAWS//EN", "jaws.dtd");
/* 112 */     registerEntity("-//JBoss//DTD JAWS 2.4//EN", "jaws_2_4.dtd");
/* 113 */     registerEntity("-//JBoss//DTD JAWS 3.0//EN", "jaws_3_0.dtd");
/* 114 */     registerEntity("-//JBoss//DTD JBOSS//EN", "jboss.dtd");
/* 115 */     registerEntity("-//JBoss//DTD JBOSS 2.4//EN", "jboss_2_4.dtd");
/* 116 */     registerEntity("-//JBoss//DTD JBOSS 3.0//EN", "jboss_3_0.dtd");
/* 117 */     registerEntity("-//JBoss//DTD JBOSS 3.2//EN", "jboss_3_2.dtd");
/* 118 */     registerEntity("-//JBoss//DTD JBOSS 4.0//EN", "jboss_4_0.dtd");
/* 119 */     registerEntity("-//JBoss//DTD JBOSS 4.2//EN", "jboss_4_2.dtd");
/* 120 */     registerEntity("-//JBoss//DTD JBOSS 5.0//EN", "jboss_5_0.dtd");
/* 121 */     registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 3.0//EN", "jbosscmp-jdbc_3_0.dtd");
/* 122 */     registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 3.2//EN", "jbosscmp-jdbc_3_2.dtd");
/* 123 */     registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 4.0//EN", "jbosscmp-jdbc_4_0.dtd");
/* 124 */     registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 4.2//EN", "jbosscmp-jdbc_4_2.dtd");
/* 125 */     registerEntity("-//JBoss//DTD Web Application 2.2//EN", "jboss-web.dtd");
/* 126 */     registerEntity("-//JBoss//DTD Web Application 2.3//EN", "jboss-web_3_0.dtd");
/* 127 */     registerEntity("-//JBoss//DTD Web Application 2.3V2//EN", "jboss-web_3_2.dtd");
/* 128 */     registerEntity("-//JBoss//DTD Web Application 2.4//EN", "jboss-web_4_0.dtd");
/* 129 */     registerEntity("-//JBoss//DTD Web Application 4.2//EN", "jboss-web_4_2.dtd");
/* 130 */     registerEntity("-//JBoss//DTD Web Application 5.0//EN", "jboss-web_5_0.dtd");
/* 131 */     registerEntity("-//JBoss//DTD Application Client 3.2//EN", "jboss-client_3_2.dtd");
/* 132 */     registerEntity("-//JBoss//DTD Application Client 4.0//EN", "jboss-client_4_0.dtd");
/* 133 */     registerEntity("-//JBoss//DTD Application Client 4.2//EN", "jboss-client_4_2.dtd");
/* 134 */     registerEntity("-//JBoss//DTD Application Client 5.0//EN", "jboss-client_5_0.dtd");
/* 135 */     registerEntity("-//JBoss//DTD Web Service Reference 4.0//EN", "service-ref_4_0.dtd");
/* 136 */     registerEntity("-//JBoss//DTD Web Service Reference 4.2//EN", "service-ref_4_2.dtd");
/* 137 */     registerEntity("-//JBoss//DTD Web Service Reference 5.0//EN", "service-ref_5_0.dtd");
/* 138 */     registerEntity("-//JBoss//DTD MBean Service 3.2//EN", "jboss-service_3_2.dtd");
/* 139 */     registerEntity("-//JBoss//DTD MBean Service 4.0//EN", "jboss-service_4_0.dtd");
/* 140 */     registerEntity("-//JBoss//DTD MBean Service 4.2//EN", "jboss-service_4_2.dtd");
/* 141 */     registerEntity("-//JBoss//DTD MBean Service 5.0//EN", "jboss-service_5_0.dtd");
/* 142 */     registerEntity("-//JBoss//DTD JBOSS XMBEAN 1.0//EN", "jboss_xmbean_1_0.dtd");
/* 143 */     registerEntity("-//JBoss//DTD JBOSS XMBEAN 1.1//EN", "jboss_xmbean_1_1.dtd");
/* 144 */     registerEntity("-//JBoss//DTD JBOSS XMBEAN 1.2//EN", "jboss_xmbean_1_2.dtd");
/* 145 */     registerEntity("-//JBoss//DTD JBOSS Security Config 3.0//EN", "security_config.dtd");
/* 146 */     registerEntity("-//JBoss//DTD JBOSS JCA Config 1.0//EN", "jboss-ds_1_0.dtd");
/* 147 */     registerEntity("-//JBoss//DTD JBOSS JCA Config 1.5//EN", "jboss-ds_1_5.dtd");
/* 148 */     registerEntity("http://www.jboss.org/j2ee/schema/security-config_4_0.xsd", "security-config_4_0.xsd");
/* 149 */     registerEntity("urn:jboss:aop-deployer", "aop-deployer_1_1.xsd");
/* 150 */     registerEntity("urn:jboss:aop-beans:1.0", "aop-beans_1_0.xsd");
/* 151 */     registerEntity("urn:jboss:bean-deployer", "bean-deployer_1_0.xsd");
/* 152 */     registerEntity("urn:jboss:bean-deployer:2.0", "bean-deployer_2_0.xsd");
/* 153 */     registerEntity("urn:jboss:javabean:1.0", "javabean_1_0.xsd");
/* 154 */     registerEntity("urn:jboss:javabean:2.0", "javabean_2_0.xsd");
/* 155 */     registerEntity("urn:jboss:spring-beans:2.0", "mc-spring-beans_2_0.xsd");
/* 156 */     registerEntity("urn:jboss:policy:1.0", "policy_1_0.xsd");
/* 157 */     registerEntity("urn:jboss:osgi-beans:1.0", "osgi-beans_1_0.xsd");
/* 158 */     registerEntity("urn:jboss:seam-components:1.0", "seam-components_1_0.xsd");
/* 159 */     registerEntity("urn:jboss:security-config:4.1", "security-config_4_1.xsd");
/* 160 */     registerEntity("urn:jboss:security-config:5.0", "security-config_5_0.xsd");
/* 161 */     registerEntity("urn:jboss:jndi-binding-service:1.0", "jndi-binding-service_1_0.xsd");
/* 162 */     registerEntity("urn:jboss:user-roles:1.0", "user-roles_1_0.xsd");
/*     */ 
/* 164 */     registerEntity("-//W3C//DTD/XMLSCHEMA 200102//EN", "XMLSchema.dtd");
/* 165 */     registerEntity("http://www.w3.org/2001/XMLSchema.dtd", "XMLSchema.dtd");
/* 166 */     registerEntity("datatypes", "datatypes.dtd");
/* 167 */     registerEntity("http://www.w3.org/XML/1998/namespace", "xml.xsd");
/*     */ 
/* 169 */     registerEntity("http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd", "ejb-jar_3_0.xsd");
/* 170 */     registerEntity("http://java.sun.com/xml/ns/javaee/javaee_web_services_client_1_2.xsd", "javaee_web_services_client_1_2.xsd");
/* 171 */     registerEntity("http://java.sun.com/xml/ns/javaee/javaee_5.xsd", "javaee_5.xsd");
/* 172 */     registerEntity("http://www.jboss.org/j2ee/schema/jboss_5_0.xsd", "jboss_5_0.xsd");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.JBossEntityResolver
 * JD-Core Version:    0.6.0
 */