/*      */ package org.jboss.util.xml.catalog;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.FileNotFoundException;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.PrintStream;
/*      */ import java.io.UnsupportedEncodingException;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URL;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Vector;
/*      */ import javax.xml.parsers.SAXParserFactory;
/*      */ import org.jboss.util.xml.catalog.helpers.Debug;
/*      */ import org.jboss.util.xml.catalog.helpers.PublicId;
/*      */ import org.jboss.util.xml.catalog.readers.CatalogReader;
/*      */ import org.jboss.util.xml.catalog.readers.SAXCatalogReader;
/*      */ import org.jboss.util.xml.catalog.readers.TR9401CatalogReader;
/*      */ 
/*      */ public class Catalog
/*      */ {
/*  222 */   public static final int BASE = CatalogEntry.addEntryType("BASE", 1);
/*      */ 
/*  225 */   public static final int CATALOG = CatalogEntry.addEntryType("CATALOG", 1);
/*      */ 
/*  228 */   public static final int DOCUMENT = CatalogEntry.addEntryType("DOCUMENT", 1);
/*      */ 
/*  231 */   public static final int OVERRIDE = CatalogEntry.addEntryType("OVERRIDE", 1);
/*      */ 
/*  234 */   public static final int SGMLDECL = CatalogEntry.addEntryType("SGMLDECL", 1);
/*      */ 
/*  237 */   public static final int DELEGATE_PUBLIC = CatalogEntry.addEntryType("DELEGATE_PUBLIC", 2);
/*      */ 
/*  240 */   public static final int DELEGATE_SYSTEM = CatalogEntry.addEntryType("DELEGATE_SYSTEM", 2);
/*      */ 
/*  243 */   public static final int DELEGATE_URI = CatalogEntry.addEntryType("DELEGATE_URI", 2);
/*      */ 
/*  246 */   public static final int DOCTYPE = CatalogEntry.addEntryType("DOCTYPE", 2);
/*      */ 
/*  249 */   public static final int DTDDECL = CatalogEntry.addEntryType("DTDDECL", 2);
/*      */ 
/*  252 */   public static final int ENTITY = CatalogEntry.addEntryType("ENTITY", 2);
/*      */ 
/*  255 */   public static final int LINKTYPE = CatalogEntry.addEntryType("LINKTYPE", 2);
/*      */ 
/*  258 */   public static final int NOTATION = CatalogEntry.addEntryType("NOTATION", 2);
/*      */ 
/*  261 */   public static final int PUBLIC = CatalogEntry.addEntryType("PUBLIC", 2);
/*      */ 
/*  264 */   public static final int SYSTEM = CatalogEntry.addEntryType("SYSTEM", 2);
/*      */ 
/*  267 */   public static final int URI = CatalogEntry.addEntryType("URI", 2);
/*      */ 
/*  270 */   public static final int REWRITE_SYSTEM = CatalogEntry.addEntryType("REWRITE_SYSTEM", 2);
/*      */ 
/*  273 */   public static final int REWRITE_URI = CatalogEntry.addEntryType("REWRITE_URI", 2);
/*      */   protected URL base;
/*      */   protected URL catalogCwd;
/*  285 */   protected Vector catalogEntries = new Vector();
/*      */ 
/*  288 */   protected boolean default_override = true;
/*      */ 
/*  291 */   protected CatalogManager catalogManager = CatalogManager.getStaticManager();
/*      */ 
/*  304 */   protected Vector catalogFiles = new Vector();
/*      */ 
/*  323 */   protected Vector localCatalogFiles = new Vector();
/*      */ 
/*  342 */   protected Vector catalogs = new Vector();
/*      */ 
/*  359 */   protected Vector localDelegate = new Vector();
/*      */ 
/*  368 */   protected Hashtable readerMap = new Hashtable();
/*      */ 
/*  378 */   protected Vector readerArr = new Vector();
/*      */ 
/*      */   public Catalog()
/*      */   {
/*      */   }
/*      */ 
/*      */   public Catalog(CatalogManager manager)
/*      */   {
/*  399 */     this.catalogManager = manager;
/*      */   }
/*      */ 
/*      */   public CatalogManager getCatalogManager()
/*      */   {
/*  407 */     return this.catalogManager;
/*      */   }
/*      */ 
/*      */   public void setCatalogManager(CatalogManager manager)
/*      */   {
/*  415 */     this.catalogManager = manager;
/*      */   }
/*      */ 
/*      */   public void setupReaders()
/*      */   {
/*  422 */     SAXParserFactory spf = SAXParserFactory.newInstance();
/*  423 */     spf.setNamespaceAware(true);
/*  424 */     spf.setValidating(false);
/*      */ 
/*  426 */     SAXCatalogReader saxReader = new SAXCatalogReader(spf);
/*      */ 
/*  428 */     saxReader.setCatalogParser(null, "XMLCatalog", "org.apache.xml.resolver.readers.XCatalogReader");
/*      */ 
/*  431 */     saxReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "org.apache.xml.resolver.readers.OASISXMLCatalogReader");
/*      */ 
/*  435 */     addReader("application/xml", saxReader);
/*      */ 
/*  437 */     TR9401CatalogReader textReader = new TR9401CatalogReader();
/*  438 */     addReader("text/plain", textReader);
/*      */   }
/*      */ 
/*      */   public void addReader(String mimeType, CatalogReader reader)
/*      */   {
/*  462 */     if (this.readerMap.containsKey(mimeType)) {
/*  463 */       Integer pos = (Integer)this.readerMap.get(mimeType);
/*  464 */       this.readerArr.set(pos.intValue(), reader);
/*      */     } else {
/*  466 */       this.readerArr.add(reader);
/*  467 */       Integer pos = new Integer(this.readerArr.size() - 1);
/*  468 */       this.readerMap.put(mimeType, pos);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void copyReaders(Catalog newCatalog)
/*      */   {
/*  483 */     Vector mapArr = new Vector(this.readerMap.size());
/*      */ 
/*  486 */     for (int count = 0; count < this.readerMap.size(); count++) {
/*  487 */       mapArr.add(null);
/*      */     }
/*      */ 
/*  490 */     Enumeration enumt = this.readerMap.keys();
/*  491 */     while (enumt.hasMoreElements()) {
/*  492 */       String mimeType = (String)enumt.nextElement();
/*  493 */       Integer pos = (Integer)this.readerMap.get(mimeType);
/*  494 */       mapArr.set(pos.intValue(), mimeType);
/*      */     }
/*      */ 
/*  497 */     for (int count = 0; count < mapArr.size(); count++) {
/*  498 */       String mimeType = (String)mapArr.get(count);
/*  499 */       Integer pos = (Integer)this.readerMap.get(mimeType);
/*  500 */       newCatalog.addReader(mimeType, (CatalogReader)this.readerArr.get(pos.intValue()));
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Catalog newCatalog()
/*      */   {
/*  519 */     String catalogClass = getClass().getName();
/*      */     try
/*      */     {
/*  522 */       Catalog c = (Catalog)(Catalog)Class.forName(catalogClass).newInstance();
/*  523 */       c.setCatalogManager(this.catalogManager);
/*  524 */       copyReaders(c);
/*  525 */       return c;
/*      */     } catch (ClassNotFoundException cnfe) {
/*  527 */       this.catalogManager.debug.message(1, "Class Not Found Exception: " + catalogClass);
/*      */     } catch (IllegalAccessException iae) {
/*  529 */       this.catalogManager.debug.message(1, "Illegal Access Exception: " + catalogClass);
/*      */     } catch (InstantiationException ie) {
/*  531 */       this.catalogManager.debug.message(1, "Instantiation Exception: " + catalogClass);
/*      */     } catch (ClassCastException cce) {
/*  533 */       this.catalogManager.debug.message(1, "Class Cast Exception: " + catalogClass);
/*      */     } catch (Exception e) {
/*  535 */       this.catalogManager.debug.message(1, "Other Exception: " + catalogClass);
/*      */     }
/*      */ 
/*  538 */     Catalog c = new Catalog();
/*  539 */     c.setCatalogManager(this.catalogManager);
/*  540 */     copyReaders(c);
/*  541 */     return c;
/*      */   }
/*      */ 
/*      */   public String getCurrentBase()
/*      */   {
/*  548 */     return this.base.toString();
/*      */   }
/*      */ 
/*      */   public String getDefaultOverride()
/*      */   {
/*  559 */     if (this.default_override) {
/*  560 */       return "yes";
/*      */     }
/*  562 */     return "no";
/*      */   }
/*      */ 
/*      */   public void loadSystemCatalogs()
/*      */     throws MalformedURLException, IOException
/*      */   {
/*  580 */     Vector catalogs = this.catalogManager.getCatalogFiles();
/*  581 */     if (catalogs != null) {
/*  582 */       for (int count = 0; count < catalogs.size(); count++) {
/*  583 */         this.catalogFiles.addElement(catalogs.elementAt(count));
/*      */       }
/*      */     }
/*      */ 
/*  587 */     if (this.catalogFiles.size() > 0)
/*      */     {
/*  600 */       String catfile = (String)this.catalogFiles.lastElement();
/*  601 */       this.catalogFiles.removeElement(catfile);
/*  602 */       parseCatalog(catfile);
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void parseCatalog(String fileName)
/*      */     throws MalformedURLException, IOException
/*      */   {
/*  618 */     this.default_override = this.catalogManager.getPreferPublic();
/*  619 */     this.catalogManager.debug.message(4, "Parse catalog: " + fileName);
/*      */ 
/*  624 */     this.catalogFiles.addElement(fileName);
/*      */ 
/*  627 */     parsePendingCatalogs();
/*      */   }
/*      */ 
/*      */   public synchronized void parseCatalog(String mimeType, InputStream is)
/*      */     throws IOException, CatalogException
/*      */   {
/*  646 */     this.default_override = this.catalogManager.getPreferPublic();
/*  647 */     this.catalogManager.debug.message(4, "Parse " + mimeType + " catalog on input stream");
/*      */ 
/*  649 */     CatalogReader reader = null;
/*      */ 
/*  651 */     if (this.readerMap.containsKey(mimeType)) {
/*  652 */       int arrayPos = ((Integer)this.readerMap.get(mimeType)).intValue();
/*  653 */       reader = (CatalogReader)this.readerArr.get(arrayPos);
/*      */     }
/*      */ 
/*  656 */     if (reader == null) {
/*  657 */       String msg = "No CatalogReader for MIME type: " + mimeType;
/*  658 */       this.catalogManager.debug.message(2, msg);
/*  659 */       throw new CatalogException(6, msg);
/*      */     }
/*      */ 
/*  662 */     reader.readCatalog(this, is);
/*      */ 
/*  665 */     parsePendingCatalogs();
/*      */   }
/*      */ 
/*      */   public synchronized void parseCatalog(URL aUrl)
/*      */     throws IOException
/*      */   {
/*  684 */     this.catalogCwd = aUrl;
/*  685 */     this.base = aUrl;
/*      */ 
/*  687 */     this.default_override = this.catalogManager.getPreferPublic();
/*  688 */     this.catalogManager.debug.message(4, "Parse catalog: " + aUrl.toString());
/*      */ 
/*  690 */     DataInputStream inStream = null;
/*  691 */     boolean parsed = false;
/*      */ 
/*  693 */     for (int count = 0; (!parsed) && (count < this.readerArr.size()); count++) {
/*  694 */       CatalogReader reader = (CatalogReader)this.readerArr.get(count);
/*      */       try
/*      */       {
/*  697 */         inStream = new DataInputStream(aUrl.openStream());
/*      */       }
/*      */       catch (FileNotFoundException fnfe) {
/*  700 */         break;
/*      */       }
/*      */       try
/*      */       {
/*  704 */         reader.readCatalog(this, inStream);
/*  705 */         parsed = true;
/*      */       } catch (CatalogException ce) {
/*  707 */         if (ce.getExceptionType() != 7) break label140; 
/*      */       }
/*  709 */       break;
/*      */       try
/*      */       {
/*  716 */         label140: inStream.close();
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*      */       }
/*      */     }
/*  722 */     if (parsed) parsePendingCatalogs();
/*      */   }
/*      */ 
/*      */   protected synchronized void parsePendingCatalogs()
/*      */     throws MalformedURLException, IOException
/*      */   {
/*  734 */     if (!this.localCatalogFiles.isEmpty())
/*      */     {
/*  737 */       Vector newQueue = new Vector();
/*  738 */       Enumeration q = this.localCatalogFiles.elements();
/*  739 */       while (q.hasMoreElements()) {
/*  740 */         newQueue.addElement(q.nextElement());
/*      */       }
/*      */ 
/*  744 */       for (int curCat = 0; curCat < this.catalogFiles.size(); curCat++) {
/*  745 */         String catfile = (String)this.catalogFiles.elementAt(curCat);
/*  746 */         newQueue.addElement(catfile);
/*      */       }
/*      */ 
/*  749 */       this.catalogFiles = newQueue;
/*  750 */       this.localCatalogFiles.clear();
/*      */     }
/*      */ 
/*  756 */     if ((this.catalogFiles.isEmpty()) && (!this.localDelegate.isEmpty())) {
/*  757 */       Enumeration e = this.localDelegate.elements();
/*  758 */       while (e.hasMoreElements()) {
/*  759 */         this.catalogEntries.addElement(e.nextElement());
/*      */       }
/*  761 */       this.localDelegate.clear();
/*      */     }
/*      */ 
/*  767 */     while (!this.catalogFiles.isEmpty()) {
/*  768 */       String catfile = (String)this.catalogFiles.elementAt(0);
/*      */       try {
/*  770 */         this.catalogFiles.remove(0);
/*      */       }
/*      */       catch (ArrayIndexOutOfBoundsException e)
/*      */       {
/*      */       }
/*  775 */       if ((this.catalogEntries.size() == 0) && (this.catalogs.size() == 0))
/*      */       {
/*      */         try
/*      */         {
/*  779 */           parseCatalogFile(catfile);
/*      */         } catch (CatalogException ce) {
/*  781 */           System.out.println("FIXME: " + ce.toString());
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  786 */         this.catalogs.addElement(catfile);
/*      */       }
/*      */ 
/*  789 */       if (!this.localCatalogFiles.isEmpty())
/*      */       {
/*  792 */         Vector newQueue = new Vector();
/*  793 */         Enumeration q = this.localCatalogFiles.elements();
/*  794 */         while (q.hasMoreElements()) {
/*  795 */           newQueue.addElement(q.nextElement());
/*      */         }
/*      */ 
/*  799 */         for (int curCat = 0; curCat < this.catalogFiles.size(); curCat++) {
/*  800 */           catfile = (String)this.catalogFiles.elementAt(curCat);
/*  801 */           newQueue.addElement(catfile);
/*      */         }
/*      */ 
/*  804 */         this.catalogFiles = newQueue;
/*  805 */         this.localCatalogFiles.clear();
/*      */       }
/*      */ 
/*  808 */       if (!this.localDelegate.isEmpty()) {
/*  809 */         Enumeration e = this.localDelegate.elements();
/*  810 */         while (e.hasMoreElements()) {
/*  811 */           this.catalogEntries.addElement(e.nextElement());
/*      */         }
/*  813 */         this.localDelegate.clear();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  818 */     this.catalogFiles.clear();
/*      */   }
/*      */ 
/*      */   protected synchronized void parseCatalogFile(String fileName)
/*      */     throws MalformedURLException, IOException, CatalogException
/*      */   {
/*      */     try
/*      */     {
/*  840 */       String userdir = fixSlashes(System.getProperty("user.dir"));
/*  841 */       this.catalogCwd = new URL("file:" + userdir + "/basename");
/*      */     } catch (MalformedURLException e) {
/*  843 */       String userdir = fixSlashes(System.getProperty("user.dir"));
/*  844 */       this.catalogManager.debug.message(1, "Malformed URL on cwd", userdir);
/*  845 */       this.catalogCwd = null;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  850 */       this.base = new URL(this.catalogCwd, fixSlashes(fileName));
/*      */     } catch (MalformedURLException e) {
/*      */       try {
/*  853 */         this.base = new URL("file:" + fixSlashes(fileName));
/*      */       } catch (MalformedURLException e2) {
/*  855 */         this.catalogManager.debug.message(1, "Malformed URL on catalog filename", fixSlashes(fileName));
/*      */ 
/*  857 */         this.base = null;
/*      */       }
/*      */     }
/*      */ 
/*  861 */     this.catalogManager.debug.message(2, "Loading catalog", fileName);
/*  862 */     this.catalogManager.debug.message(4, "Default BASE", this.base.toString());
/*      */ 
/*  864 */     fileName = this.base.toString();
/*      */ 
/*  866 */     DataInputStream inStream = null;
/*  867 */     boolean parsed = false;
/*  868 */     boolean notFound = false;
/*      */ 
/*  870 */     for (int count = 0; (!parsed) && (count < this.readerArr.size()); count++) {
/*  871 */       CatalogReader reader = (CatalogReader)this.readerArr.get(count);
/*      */       try
/*      */       {
/*  874 */         notFound = false;
/*  875 */         inStream = new DataInputStream(this.base.openStream());
/*      */       }
/*      */       catch (FileNotFoundException fnfe) {
/*  878 */         notFound = true;
/*  879 */         break;
/*      */       }
/*      */       try
/*      */       {
/*  883 */         reader.readCatalog(this, inStream);
/*  884 */         parsed = true;
/*      */       } catch (CatalogException ce) {
/*  886 */         if (ce.getExceptionType() != 7) break label309; 
/*      */       }
/*  888 */       break;
/*      */       try
/*      */       {
/*  895 */         label309: inStream.close();
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*      */       }
/*      */     }
/*  901 */     if (!parsed)
/*  902 */       if (notFound)
/*  903 */         this.catalogManager.debug.message(3, "Catalog does not exist", fileName);
/*      */       else
/*  905 */         this.catalogManager.debug.message(1, "Failed to parse catalog", fileName);
/*      */   }
/*      */ 
/*      */   public void addEntry(CatalogEntry entry)
/*      */   {
/*  921 */     int type = entry.getEntryType();
/*      */ 
/*  923 */     if (type == BASE) {
/*  924 */       String value = entry.getEntryArg(0);
/*  925 */       URL newbase = null;
/*      */ 
/*  927 */       this.catalogManager.debug.message(5, "BASE CUR", this.base.toString());
/*  928 */       this.catalogManager.debug.message(4, "BASE STR", value);
/*      */       try
/*      */       {
/*  931 */         value = fixSlashes(value);
/*  932 */         newbase = new URL(this.base, value);
/*      */       } catch (MalformedURLException e) {
/*      */         try {
/*  935 */           newbase = new URL("file:" + value);
/*      */         } catch (MalformedURLException e2) {
/*  937 */           this.catalogManager.debug.message(1, "Malformed URL on base", value);
/*  938 */           newbase = null;
/*      */         }
/*      */       }
/*      */ 
/*  942 */       if (newbase != null) {
/*  943 */         this.base = newbase;
/*      */       }
/*      */ 
/*  946 */       this.catalogManager.debug.message(5, "BASE NEW", this.base.toString());
/*  947 */     } else if (type == CATALOG) {
/*  948 */       String fsi = makeAbsolute(entry.getEntryArg(0));
/*      */ 
/*  950 */       this.catalogManager.debug.message(4, "CATALOG", fsi);
/*      */ 
/*  952 */       this.localCatalogFiles.addElement(fsi);
/*  953 */     } else if (type == PUBLIC) {
/*  954 */       String publicid = PublicId.normalize(entry.getEntryArg(0));
/*  955 */       String systemid = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/*  957 */       entry.setEntryArg(0, publicid);
/*  958 */       entry.setEntryArg(1, systemid);
/*      */ 
/*  960 */       this.catalogManager.debug.message(4, "PUBLIC", publicid, systemid);
/*      */ 
/*  962 */       this.catalogEntries.addElement(entry);
/*  963 */     } else if (type == SYSTEM) {
/*  964 */       String systemid = normalizeURI(entry.getEntryArg(0));
/*  965 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/*  967 */       entry.setEntryArg(1, fsi);
/*      */ 
/*  969 */       this.catalogManager.debug.message(4, "SYSTEM", systemid, fsi);
/*      */ 
/*  971 */       this.catalogEntries.addElement(entry);
/*  972 */     } else if (type == URI) {
/*  973 */       String uri = normalizeURI(entry.getEntryArg(0));
/*  974 */       String altURI = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/*  976 */       entry.setEntryArg(1, altURI);
/*      */ 
/*  978 */       this.catalogManager.debug.message(4, "URI", uri, altURI);
/*      */ 
/*  980 */       this.catalogEntries.addElement(entry);
/*  981 */     } else if (type == DOCUMENT) {
/*  982 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(0)));
/*  983 */       entry.setEntryArg(0, fsi);
/*      */ 
/*  985 */       this.catalogManager.debug.message(4, "DOCUMENT", fsi);
/*      */ 
/*  987 */       this.catalogEntries.addElement(entry);
/*  988 */     } else if (type == OVERRIDE) {
/*  989 */       this.catalogManager.debug.message(4, "OVERRIDE", entry.getEntryArg(0));
/*      */ 
/*  991 */       this.catalogEntries.addElement(entry);
/*  992 */     } else if (type == SGMLDECL)
/*      */     {
/*  994 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(0)));
/*  995 */       entry.setEntryArg(0, fsi);
/*      */ 
/*  997 */       this.catalogManager.debug.message(4, "SGMLDECL", fsi);
/*      */ 
/*  999 */       this.catalogEntries.addElement(entry);
/* 1000 */     } else if (type == DELEGATE_PUBLIC) {
/* 1001 */       String ppi = PublicId.normalize(entry.getEntryArg(0));
/* 1002 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/* 1004 */       entry.setEntryArg(0, ppi);
/* 1005 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1007 */       this.catalogManager.debug.message(4, "DELEGATE_PUBLIC", ppi, fsi);
/*      */ 
/* 1009 */       addDelegate(entry);
/* 1010 */     } else if (type == DELEGATE_SYSTEM) {
/* 1011 */       String psi = normalizeURI(entry.getEntryArg(0));
/* 1012 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/* 1014 */       entry.setEntryArg(0, psi);
/* 1015 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1017 */       this.catalogManager.debug.message(4, "DELEGATE_SYSTEM", psi, fsi);
/*      */ 
/* 1019 */       addDelegate(entry);
/* 1020 */     } else if (type == DELEGATE_URI) {
/* 1021 */       String pui = normalizeURI(entry.getEntryArg(0));
/* 1022 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/* 1024 */       entry.setEntryArg(0, pui);
/* 1025 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1027 */       this.catalogManager.debug.message(4, "DELEGATE_URI", pui, fsi);
/*      */ 
/* 1029 */       addDelegate(entry);
/* 1030 */     } else if (type == REWRITE_SYSTEM) {
/* 1031 */       String psi = normalizeURI(entry.getEntryArg(0));
/* 1032 */       String rpx = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/* 1034 */       entry.setEntryArg(0, psi);
/* 1035 */       entry.setEntryArg(1, rpx);
/*      */ 
/* 1037 */       this.catalogManager.debug.message(4, "REWRITE_SYSTEM", psi, rpx);
/*      */ 
/* 1039 */       this.catalogEntries.addElement(entry);
/* 1040 */     } else if (type == REWRITE_URI) {
/* 1041 */       String pui = normalizeURI(entry.getEntryArg(0));
/* 1042 */       String upx = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/* 1044 */       entry.setEntryArg(0, pui);
/* 1045 */       entry.setEntryArg(1, upx);
/*      */ 
/* 1047 */       this.catalogManager.debug.message(4, "REWRITE_URI", pui, upx);
/*      */ 
/* 1049 */       this.catalogEntries.addElement(entry);
/* 1050 */     } else if (type == DOCTYPE) {
/* 1051 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/* 1052 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1054 */       this.catalogManager.debug.message(4, "DOCTYPE", entry.getEntryArg(0), fsi);
/*      */ 
/* 1056 */       this.catalogEntries.addElement(entry);
/* 1057 */     } else if (type == DTDDECL)
/*      */     {
/* 1059 */       String fpi = PublicId.normalize(entry.getEntryArg(0));
/* 1060 */       entry.setEntryArg(0, fpi);
/* 1061 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/* 1062 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1064 */       this.catalogManager.debug.message(4, "DTDDECL", fpi, fsi);
/*      */ 
/* 1066 */       this.catalogEntries.addElement(entry);
/* 1067 */     } else if (type == ENTITY) {
/* 1068 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/* 1069 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1071 */       this.catalogManager.debug.message(4, "ENTITY", entry.getEntryArg(0), fsi);
/*      */ 
/* 1073 */       this.catalogEntries.addElement(entry);
/* 1074 */     } else if (type == LINKTYPE)
/*      */     {
/* 1076 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/* 1077 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1079 */       this.catalogManager.debug.message(4, "LINKTYPE", entry.getEntryArg(0), fsi);
/*      */ 
/* 1081 */       this.catalogEntries.addElement(entry);
/* 1082 */     } else if (type == NOTATION) {
/* 1083 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/* 1084 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1086 */       this.catalogManager.debug.message(4, "NOTATION", entry.getEntryArg(0), fsi);
/*      */ 
/* 1088 */       this.catalogEntries.addElement(entry);
/*      */     } else {
/* 1090 */       this.catalogEntries.addElement(entry);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void unknownEntry(Vector strings)
/*      */   {
/* 1101 */     if ((strings != null) && (strings.size() > 0)) {
/* 1102 */       String keyword = (String)strings.elementAt(0);
/* 1103 */       this.catalogManager.debug.message(2, "Unrecognized token parsing catalog", keyword);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void parseAllCatalogs()
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1140 */     for (int catPos = 0; catPos < this.catalogs.size(); catPos++) {
/* 1141 */       Catalog c = null;
/*      */       try
/*      */       {
/* 1144 */         c = (Catalog)this.catalogs.elementAt(catPos);
/*      */       } catch (ClassCastException e) {
/* 1146 */         String catfile = (String)this.catalogs.elementAt(catPos);
/* 1147 */         c = newCatalog();
/*      */ 
/* 1149 */         c.parseCatalog(catfile);
/* 1150 */         this.catalogs.setElementAt(c, catPos);
/* 1151 */         c.parseAllCatalogs();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1156 */     Enumeration enumt = this.catalogEntries.elements();
/* 1157 */     while (enumt.hasMoreElements()) {
/* 1158 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 1159 */       if ((e.getEntryType() == DELEGATE_PUBLIC) || (e.getEntryType() == DELEGATE_SYSTEM) || (e.getEntryType() == DELEGATE_URI))
/*      */       {
/* 1162 */         Catalog dcat = newCatalog();
/* 1163 */         dcat.parseCatalog(e.getEntryArg(1));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public String resolveDoctype(String entityName, String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1189 */     String resolved = null;
/*      */ 
/* 1191 */     this.catalogManager.debug.message(3, "resolveDoctype(" + entityName + "," + publicId + "," + systemId + ")");
/*      */ 
/* 1194 */     systemId = normalizeURI(systemId);
/*      */ 
/* 1196 */     if ((publicId != null) && (publicId.startsWith("urn:publicid:"))) {
/* 1197 */       publicId = PublicId.decodeURN(publicId);
/*      */     }
/*      */ 
/* 1200 */     if ((systemId != null) && (systemId.startsWith("urn:publicid:"))) {
/* 1201 */       systemId = PublicId.decodeURN(systemId);
/* 1202 */       if ((publicId != null) && (!publicId.equals(systemId))) {
/* 1203 */         this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
/* 1204 */         systemId = null;
/*      */       } else {
/* 1206 */         publicId = systemId;
/* 1207 */         systemId = null;
/*      */       }
/*      */     }
/*      */ 
/* 1211 */     if (systemId != null)
/*      */     {
/* 1213 */       resolved = resolveLocalSystem(systemId);
/* 1214 */       if (resolved != null) {
/* 1215 */         return resolved;
/*      */       }
/*      */     }
/*      */ 
/* 1219 */     if (publicId != null)
/*      */     {
/* 1221 */       resolved = resolveLocalPublic(DOCTYPE, entityName, publicId, systemId);
/*      */ 
/* 1225 */       if (resolved != null) {
/* 1226 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1231 */     boolean over = this.default_override;
/* 1232 */     Enumeration enumt = this.catalogEntries.elements();
/* 1233 */     while (enumt.hasMoreElements()) {
/* 1234 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 1235 */       if (e.getEntryType() == OVERRIDE) {
/* 1236 */         over = e.getEntryArg(0).equalsIgnoreCase("YES");
/* 1237 */         continue;
/*      */       }
/*      */ 
/* 1240 */       if ((e.getEntryType() == DOCTYPE) && (e.getEntryArg(0).equals(entityName)))
/*      */       {
/* 1242 */         if ((over) || (systemId == null)) {
/* 1243 */           return e.getEntryArg(1);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1249 */     return resolveSubordinateCatalogs(DOCTYPE, entityName, publicId, systemId);
/*      */   }
/*      */ 
/*      */   public String resolveDocument()
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1268 */     this.catalogManager.debug.message(3, "resolveDocument");
/*      */ 
/* 1270 */     Enumeration enumt = this.catalogEntries.elements();
/* 1271 */     while (enumt.hasMoreElements()) {
/* 1272 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 1273 */       if (e.getEntryType() == DOCUMENT) {
/* 1274 */         return e.getEntryArg(1);
/*      */       }
/*      */     }
/*      */ 
/* 1278 */     return resolveSubordinateCatalogs(DOCUMENT, null, null, null);
/*      */   }
/*      */ 
/*      */   public String resolveEntity(String entityName, String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1302 */     String resolved = null;
/*      */ 
/* 1304 */     this.catalogManager.debug.message(3, "resolveEntity(" + entityName + "," + publicId + "," + systemId + ")");
/*      */ 
/* 1307 */     systemId = normalizeURI(systemId);
/*      */ 
/* 1309 */     if ((publicId != null) && (publicId.startsWith("urn:publicid:"))) {
/* 1310 */       publicId = PublicId.decodeURN(publicId);
/*      */     }
/*      */ 
/* 1313 */     if ((systemId != null) && (systemId.startsWith("urn:publicid:"))) {
/* 1314 */       systemId = PublicId.decodeURN(systemId);
/* 1315 */       if ((publicId != null) && (!publicId.equals(systemId))) {
/* 1316 */         this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
/* 1317 */         systemId = null;
/*      */       } else {
/* 1319 */         publicId = systemId;
/* 1320 */         systemId = null;
/*      */       }
/*      */     }
/*      */ 
/* 1324 */     if (systemId != null)
/*      */     {
/* 1326 */       resolved = resolveLocalSystem(systemId);
/* 1327 */       if (resolved != null) {
/* 1328 */         return resolved;
/*      */       }
/*      */     }
/*      */ 
/* 1332 */     if (publicId != null)
/*      */     {
/* 1334 */       resolved = resolveLocalPublic(ENTITY, entityName, publicId, systemId);
/*      */ 
/* 1338 */       if (resolved != null) {
/* 1339 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1344 */     boolean over = this.default_override;
/* 1345 */     Enumeration enumt = this.catalogEntries.elements();
/* 1346 */     while (enumt.hasMoreElements()) {
/* 1347 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 1348 */       if (e.getEntryType() == OVERRIDE) {
/* 1349 */         over = e.getEntryArg(0).equalsIgnoreCase("YES");
/* 1350 */         continue;
/*      */       }
/*      */ 
/* 1353 */       if ((e.getEntryType() == ENTITY) && (e.getEntryArg(0).equals(entityName)))
/*      */       {
/* 1355 */         if ((over) || (systemId == null)) {
/* 1356 */           return e.getEntryArg(1);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1362 */     return resolveSubordinateCatalogs(ENTITY, entityName, publicId, systemId);
/*      */   }
/*      */ 
/*      */   public String resolveNotation(String notationName, String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1388 */     String resolved = null;
/*      */ 
/* 1390 */     this.catalogManager.debug.message(3, "resolveNotation(" + notationName + "," + publicId + "," + systemId + ")");
/*      */ 
/* 1393 */     systemId = normalizeURI(systemId);
/*      */ 
/* 1395 */     if ((publicId != null) && (publicId.startsWith("urn:publicid:"))) {
/* 1396 */       publicId = PublicId.decodeURN(publicId);
/*      */     }
/*      */ 
/* 1399 */     if ((systemId != null) && (systemId.startsWith("urn:publicid:"))) {
/* 1400 */       systemId = PublicId.decodeURN(systemId);
/* 1401 */       if ((publicId != null) && (!publicId.equals(systemId))) {
/* 1402 */         this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
/* 1403 */         systemId = null;
/*      */       } else {
/* 1405 */         publicId = systemId;
/* 1406 */         systemId = null;
/*      */       }
/*      */     }
/*      */ 
/* 1410 */     if (systemId != null)
/*      */     {
/* 1412 */       resolved = resolveLocalSystem(systemId);
/* 1413 */       if (resolved != null) {
/* 1414 */         return resolved;
/*      */       }
/*      */     }
/*      */ 
/* 1418 */     if (publicId != null)
/*      */     {
/* 1420 */       resolved = resolveLocalPublic(NOTATION, notationName, publicId, systemId);
/*      */ 
/* 1424 */       if (resolved != null) {
/* 1425 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1430 */     boolean over = this.default_override;
/* 1431 */     Enumeration enumt = this.catalogEntries.elements();
/* 1432 */     while (enumt.hasMoreElements()) {
/* 1433 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 1434 */       if (e.getEntryType() == OVERRIDE) {
/* 1435 */         over = e.getEntryArg(0).equalsIgnoreCase("YES");
/* 1436 */         continue;
/*      */       }
/*      */ 
/* 1439 */       if ((e.getEntryType() == NOTATION) && (e.getEntryArg(0).equals(notationName)))
/*      */       {
/* 1441 */         if ((over) || (systemId == null)) {
/* 1442 */           return e.getEntryArg(1);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1448 */     return resolveSubordinateCatalogs(NOTATION, notationName, publicId, systemId);
/*      */   }
/*      */ 
/*      */   public String resolvePublic(String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1480 */     this.catalogManager.debug.message(3, "resolvePublic(" + publicId + "," + systemId + ")");
/*      */ 
/* 1482 */     systemId = normalizeURI(systemId);
/*      */ 
/* 1484 */     if ((publicId != null) && (publicId.startsWith("urn:publicid:"))) {
/* 1485 */       publicId = PublicId.decodeURN(publicId);
/*      */     }
/*      */ 
/* 1488 */     if ((systemId != null) && (systemId.startsWith("urn:publicid:"))) {
/* 1489 */       systemId = PublicId.decodeURN(systemId);
/* 1490 */       if ((publicId != null) && (!publicId.equals(systemId))) {
/* 1491 */         this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
/* 1492 */         systemId = null;
/*      */       } else {
/* 1494 */         publicId = systemId;
/* 1495 */         systemId = null;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1500 */     if (systemId != null) {
/* 1501 */       String resolved = resolveLocalSystem(systemId);
/* 1502 */       if (resolved != null) {
/* 1503 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1508 */     String resolved = resolveLocalPublic(PUBLIC, null, publicId, systemId);
/*      */ 
/* 1512 */     if (resolved != null) {
/* 1513 */       return resolved;
/*      */     }
/*      */ 
/* 1517 */     return resolveSubordinateCatalogs(PUBLIC, null, publicId, systemId);
/*      */   }
/*      */ 
/*      */   protected synchronized String resolveLocalPublic(int entityType, String entityName, String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1578 */     publicId = PublicId.normalize(publicId);
/*      */ 
/* 1581 */     if (systemId != null) {
/* 1582 */       String resolved = resolveLocalSystem(systemId);
/* 1583 */       if (resolved != null) {
/* 1584 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1589 */     boolean over = this.default_override;
/* 1590 */     Enumeration enumt = this.catalogEntries.elements();
/* 1591 */     while (enumt.hasMoreElements()) {
/* 1592 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 1593 */       if (e.getEntryType() == OVERRIDE) {
/* 1594 */         over = e.getEntryArg(0).equalsIgnoreCase("YES");
/* 1595 */         continue;
/*      */       }
/*      */ 
/* 1598 */       if ((e.getEntryType() == PUBLIC) && (e.getEntryArg(0).equals(publicId)))
/*      */       {
/* 1600 */         if ((over) || (systemId == null)) {
/* 1601 */           return e.getEntryArg(1);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1607 */     over = this.default_override;
/* 1608 */     enumt = this.catalogEntries.elements();
/* 1609 */     Vector delCats = new Vector();
/* 1610 */     while (enumt.hasMoreElements()) {
/* 1611 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 1612 */       if (e.getEntryType() == OVERRIDE) {
/* 1613 */         over = e.getEntryArg(0).equalsIgnoreCase("YES");
/* 1614 */         continue;
/*      */       }
/*      */ 
/* 1617 */       if ((e.getEntryType() == DELEGATE_PUBLIC) && ((over) || (systemId == null)))
/*      */       {
/* 1619 */         String p = e.getEntryArg(0);
/* 1620 */         if ((p.length() <= publicId.length()) && (p.equals(publicId.substring(0, p.length()))))
/*      */         {
/* 1624 */           delCats.addElement(e.getEntryArg(1));
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1629 */     if (delCats.size() > 0) {
/* 1630 */       Enumeration enumCats = delCats.elements();
/*      */ 
/* 1632 */       if (this.catalogManager.debug.getDebug() > 1) {
/* 1633 */         this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
/* 1634 */         while (enumCats.hasMoreElements()) {
/* 1635 */           String delegatedCatalog = (String)enumCats.nextElement();
/* 1636 */           this.catalogManager.debug.message(2, "\t" + delegatedCatalog);
/*      */         }
/*      */       }
/*      */ 
/* 1640 */       Catalog dcat = newCatalog();
/*      */ 
/* 1642 */       enumCats = delCats.elements();
/* 1643 */       while (enumCats.hasMoreElements()) {
/* 1644 */         String delegatedCatalog = (String)enumCats.nextElement();
/* 1645 */         dcat.parseCatalog(delegatedCatalog);
/*      */       }
/*      */ 
/* 1648 */       return dcat.resolvePublic(publicId, null);
/*      */     }
/*      */ 
/* 1652 */     return null;
/*      */   }
/*      */ 
/*      */   public String resolveSystem(String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1676 */     this.catalogManager.debug.message(3, "resolveSystem(" + systemId + ")");
/*      */ 
/* 1678 */     systemId = normalizeURI(systemId);
/*      */ 
/* 1680 */     if ((systemId != null) && (systemId.startsWith("urn:publicid:"))) {
/* 1681 */       systemId = PublicId.decodeURN(systemId);
/* 1682 */       return resolvePublic(systemId, null);
/*      */     }
/*      */ 
/* 1686 */     if (systemId != null) {
/* 1687 */       String resolved = resolveLocalSystem(systemId);
/* 1688 */       if (resolved != null) {
/* 1689 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1694 */     return resolveSubordinateCatalogs(SYSTEM, null, null, systemId);
/*      */   }
/*      */ 
/*      */   protected String resolveLocalSystem(String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1714 */     String osname = System.getProperty("os.name");
/* 1715 */     boolean windows = osname.indexOf("Windows") >= 0;
/* 1716 */     Enumeration enumt = this.catalogEntries.elements();
/* 1717 */     while (enumt.hasMoreElements()) {
/* 1718 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 1719 */       if ((e.getEntryType() == SYSTEM) && ((e.getEntryArg(0).equals(systemId)) || ((windows) && (e.getEntryArg(0).equalsIgnoreCase(systemId)))))
/*      */       {
/* 1723 */         return e.getEntryArg(1);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1728 */     enumt = this.catalogEntries.elements();
/* 1729 */     String startString = null;
/* 1730 */     String prefix = null;
/* 1731 */     while (enumt.hasMoreElements()) {
/* 1732 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/*      */ 
/* 1734 */       if (e.getEntryType() == REWRITE_SYSTEM) {
/* 1735 */         String p = e.getEntryArg(0);
/* 1736 */         if ((p.length() <= systemId.length()) && (p.equals(systemId.substring(0, p.length()))))
/*      */         {
/* 1739 */           if ((startString == null) || (p.length() > startString.length()))
/*      */           {
/* 1741 */             startString = p;
/* 1742 */             prefix = e.getEntryArg(1);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1747 */       if (prefix != null)
/*      */       {
/* 1749 */         return prefix + systemId.substring(startString.length());
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1754 */     enumt = this.catalogEntries.elements();
/* 1755 */     Vector delCats = new Vector();
/* 1756 */     while (enumt.hasMoreElements()) {
/* 1757 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/*      */ 
/* 1759 */       if (e.getEntryType() == DELEGATE_SYSTEM) {
/* 1760 */         String p = e.getEntryArg(0);
/* 1761 */         if ((p.length() <= systemId.length()) && (p.equals(systemId.substring(0, p.length()))))
/*      */         {
/* 1765 */           delCats.addElement(e.getEntryArg(1));
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1770 */     if (delCats.size() > 0) {
/* 1771 */       Enumeration enumCats = delCats.elements();
/*      */ 
/* 1773 */       if (this.catalogManager.debug.getDebug() > 1) {
/* 1774 */         this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
/* 1775 */         while (enumCats.hasMoreElements()) {
/* 1776 */           String delegatedCatalog = (String)enumCats.nextElement();
/* 1777 */           this.catalogManager.debug.message(2, "\t" + delegatedCatalog);
/*      */         }
/*      */       }
/*      */ 
/* 1781 */       Catalog dcat = newCatalog();
/*      */ 
/* 1783 */       enumCats = delCats.elements();
/* 1784 */       while (enumCats.hasMoreElements()) {
/* 1785 */         String delegatedCatalog = (String)enumCats.nextElement();
/* 1786 */         dcat.parseCatalog(delegatedCatalog);
/*      */       }
/*      */ 
/* 1789 */       return dcat.resolveSystem(systemId);
/*      */     }
/*      */ 
/* 1792 */     return null;
/*      */   }
/*      */ 
/*      */   public String resolveURI(String uri)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1814 */     this.catalogManager.debug.message(3, "resolveURI(" + uri + ")");
/*      */ 
/* 1816 */     uri = normalizeURI(uri);
/*      */ 
/* 1818 */     if ((uri != null) && (uri.startsWith("urn:publicid:"))) {
/* 1819 */       uri = PublicId.decodeURN(uri);
/* 1820 */       return resolvePublic(uri, null);
/*      */     }
/*      */ 
/* 1824 */     if (uri != null) {
/* 1825 */       String resolved = resolveLocalURI(uri);
/* 1826 */       if (resolved != null) {
/* 1827 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1832 */     return resolveSubordinateCatalogs(URI, null, null, uri);
/*      */   }
/*      */ 
/*      */   protected String resolveLocalURI(String uri)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1850 */     Enumeration enumt = this.catalogEntries.elements();
/* 1851 */     while (enumt.hasMoreElements()) {
/* 1852 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 1853 */       if ((e.getEntryType() == URI) && (e.getEntryArg(0).equals(uri)))
/*      */       {
/* 1855 */         return e.getEntryArg(1);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1860 */     enumt = this.catalogEntries.elements();
/* 1861 */     String startString = null;
/* 1862 */     String prefix = null;
/* 1863 */     while (enumt.hasMoreElements()) {
/* 1864 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/*      */ 
/* 1866 */       if (e.getEntryType() == REWRITE_URI) {
/* 1867 */         String p = e.getEntryArg(0);
/* 1868 */         if ((p.length() <= uri.length()) && (p.equals(uri.substring(0, p.length()))))
/*      */         {
/* 1871 */           if ((startString == null) || (p.length() > startString.length()))
/*      */           {
/* 1873 */             startString = p;
/* 1874 */             prefix = e.getEntryArg(1);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1879 */       if (prefix != null)
/*      */       {
/* 1881 */         return prefix + uri.substring(startString.length());
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1886 */     enumt = this.catalogEntries.elements();
/* 1887 */     Vector delCats = new Vector();
/* 1888 */     while (enumt.hasMoreElements()) {
/* 1889 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/*      */ 
/* 1891 */       if (e.getEntryType() == DELEGATE_URI) {
/* 1892 */         String p = e.getEntryArg(0);
/* 1893 */         if ((p.length() <= uri.length()) && (p.equals(uri.substring(0, p.length()))))
/*      */         {
/* 1897 */           delCats.addElement(e.getEntryArg(1));
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1902 */     if (delCats.size() > 0) {
/* 1903 */       Enumeration enumCats = delCats.elements();
/*      */ 
/* 1905 */       if (this.catalogManager.debug.getDebug() > 1) {
/* 1906 */         this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
/* 1907 */         while (enumCats.hasMoreElements()) {
/* 1908 */           String delegatedCatalog = (String)enumCats.nextElement();
/* 1909 */           this.catalogManager.debug.message(2, "\t" + delegatedCatalog);
/*      */         }
/*      */       }
/*      */ 
/* 1913 */       Catalog dcat = newCatalog();
/*      */ 
/* 1915 */       enumCats = delCats.elements();
/* 1916 */       while (enumCats.hasMoreElements()) {
/* 1917 */         String delegatedCatalog = (String)enumCats.nextElement();
/* 1918 */         dcat.parseCatalog(delegatedCatalog);
/*      */       }
/*      */ 
/* 1921 */       return dcat.resolveURI(uri);
/*      */     }
/*      */ 
/* 1924 */     return null;
/*      */   }
/*      */ 
/*      */   protected synchronized String resolveSubordinateCatalogs(int entityType, String entityName, String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1961 */     for (int catPos = 0; catPos < this.catalogs.size(); catPos++) {
/* 1962 */       Catalog c = null;
/*      */       try
/*      */       {
/* 1965 */         c = (Catalog)this.catalogs.elementAt(catPos);
/*      */       } catch (ClassCastException e) {
/* 1967 */         String catfile = (String)this.catalogs.elementAt(catPos);
/* 1968 */         c = newCatalog();
/*      */         try
/*      */         {
/* 1971 */           c.parseCatalog(catfile);
/*      */         } catch (MalformedURLException mue) {
/* 1973 */           this.catalogManager.debug.message(1, "Malformed Catalog URL", catfile);
/*      */         } catch (FileNotFoundException fnfe) {
/* 1975 */           this.catalogManager.debug.message(1, "Failed to load catalog, file not found", catfile);
/*      */         }
/*      */         catch (IOException ioe) {
/* 1978 */           this.catalogManager.debug.message(1, "Failed to load catalog, I/O error", catfile);
/*      */         }
/*      */ 
/* 1981 */         this.catalogs.setElementAt(c, catPos);
/*      */       }
/*      */ 
/* 1984 */       String resolved = null;
/*      */ 
/* 1987 */       if (entityType == DOCTYPE) {
/* 1988 */         resolved = c.resolveDoctype(entityName, publicId, systemId);
/*      */       }
/* 1991 */       else if (entityType == DOCUMENT)
/* 1992 */         resolved = c.resolveDocument();
/* 1993 */       else if (entityType == ENTITY) {
/* 1994 */         resolved = c.resolveEntity(entityName, publicId, systemId);
/*      */       }
/* 1997 */       else if (entityType == NOTATION) {
/* 1998 */         resolved = c.resolveNotation(entityName, publicId, systemId);
/*      */       }
/* 2001 */       else if (entityType == PUBLIC)
/* 2002 */         resolved = c.resolvePublic(publicId, systemId);
/* 2003 */       else if (entityType == SYSTEM)
/* 2004 */         resolved = c.resolveSystem(systemId);
/* 2005 */       else if (entityType == URI) {
/* 2006 */         resolved = c.resolveURI(systemId);
/*      */       }
/*      */ 
/* 2009 */       if (resolved != null) {
/* 2010 */         return resolved;
/*      */       }
/*      */     }
/*      */ 
/* 2014 */     return null;
/*      */   }
/*      */ 
/*      */   protected String fixSlashes(String sysid)
/*      */   {
/* 2028 */     return sysid.replace('\\', '/');
/*      */   }
/*      */ 
/*      */   protected String makeAbsolute(String sysid)
/*      */   {
/* 2040 */     URL local = null;
/*      */ 
/* 2042 */     sysid = fixSlashes(sysid);
/*      */     try
/*      */     {
/* 2045 */       local = new URL(this.base, sysid);
/*      */     } catch (MalformedURLException e) {
/* 2047 */       this.catalogManager.debug.message(1, "Malformed URL on system identifier", sysid);
/*      */     }
/*      */ 
/* 2050 */     if (local != null) {
/* 2051 */       return local.toString();
/*      */     }
/* 2053 */     return sysid;
/*      */   }
/*      */ 
/*      */   protected String normalizeURI(String uriref)
/*      */   {
/* 2064 */     String newRef = "";
/*      */ 
/* 2067 */     if (uriref == null)
/* 2068 */       return null;
/*      */     byte[] bytes;
/*      */     try {
/* 2072 */       bytes = uriref.getBytes("UTF-8");
/*      */     }
/*      */     catch (UnsupportedEncodingException uee) {
/* 2075 */       this.catalogManager.debug.message(1, "UTF-8 is an unsupported encoding!?");
/* 2076 */       return uriref;
/*      */     }
/*      */ 
/* 2079 */     for (int count = 0; count < bytes.length; count++) {
/* 2080 */       int ch = bytes[count] & 0xFF;
/*      */ 
/* 2082 */       if ((ch <= 32) || (ch > 127) || (ch == 34) || (ch == 60) || (ch == 62) || (ch == 92) || (ch == 94) || (ch == 96) || (ch == 123) || (ch == 124) || (ch == 125) || (ch == 127))
/*      */       {
/* 2094 */         newRef = newRef + encodedByte(ch);
/*      */       }
/* 2096 */       else newRef = newRef + (char)bytes[count];
/*      */ 
/*      */     }
/*      */ 
/* 2100 */     return newRef;
/*      */   }
/*      */ 
/*      */   protected String encodedByte(int b)
/*      */   {
/* 2111 */     String hex = Integer.toHexString(b).toUpperCase();
/* 2112 */     if (hex.length() < 2) {
/* 2113 */       return "%0" + hex;
/*      */     }
/* 2115 */     return "%" + hex;
/*      */   }
/*      */ 
/*      */   protected void addDelegate(CatalogEntry entry)
/*      */   {
/* 2131 */     int pos = 0;
/* 2132 */     String partial = entry.getEntryArg(0);
/*      */ 
/* 2134 */     Enumeration local = this.localDelegate.elements();
/* 2135 */     while (local.hasMoreElements()) {
/* 2136 */       CatalogEntry dpe = (CatalogEntry)local.nextElement();
/* 2137 */       String dp = dpe.getEntryArg(0);
/* 2138 */       if (dp.equals(partial))
/*      */       {
/* 2140 */         return;
/*      */       }
/* 2142 */       if (dp.length() > partial.length()) {
/* 2143 */         pos++;
/*      */       }
/* 2145 */       if (dp.length() < partial.length())
/*      */       {
/*      */         break;
/*      */       }
/*      */     }
/*      */ 
/* 2151 */     if (this.localDelegate.size() == 0)
/* 2152 */       this.localDelegate.addElement(entry);
/*      */     else
/* 2154 */       this.localDelegate.insertElementAt(entry, pos);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.Catalog
 * JD-Core Version:    0.6.0
 */