/*     */ package org.jboss.util.xml.catalog.helpers;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Hashtable;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.TransformerException;
/*     */ import javax.xml.transform.URIResolver;
/*     */ import javax.xml.transform.sax.SAXSource;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ public class BootstrapResolver
/*     */   implements EntityResolver, URIResolver
/*     */ {
/*     */   public static final String xmlCatalogXSD = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.xsd";
/*     */   public static final String xmlCatalogRNG = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.rng";
/*     */   public static final String xmlCatalogPubId = "-//OASIS//DTD XML Catalogs V1.0//EN";
/*     */   public static final String xmlCatalogSysId = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd";
/* 103 */   private Hashtable publicMap = new Hashtable();
/*     */ 
/* 106 */   private Hashtable systemMap = new Hashtable();
/*     */ 
/* 109 */   private Hashtable uriMap = new Hashtable();
/*     */ 
/*     */   public BootstrapResolver()
/*     */   {
/* 113 */     URL url = getClass().getResource("/org/apache/xml/resolver/etc/catalog.dtd");
/* 114 */     if (url != null) {
/* 115 */       this.publicMap.put("-//OASIS//DTD XML Catalogs V1.0//EN", url.toString());
/* 116 */       this.systemMap.put("http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd", url.toString());
/*     */     }
/*     */ 
/* 119 */     url = getClass().getResource("/org/apache/xml/resolver/etc/catalog.rng");
/* 120 */     if (url != null) {
/* 121 */       this.uriMap.put("http://www.oasis-open.org/committees/entity/release/1.0/catalog.rng", url.toString());
/*     */     }
/*     */ 
/* 124 */     url = getClass().getResource("/org/apache/xml/resolver/etc/catalog.xsd");
/* 125 */     if (url != null)
/* 126 */       this.uriMap.put("http://www.oasis-open.org/committees/entity/release/1.0/catalog.xsd", url.toString());
/*     */   }
/*     */ 
/*     */   public InputSource resolveEntity(String publicId, String systemId)
/*     */   {
/* 132 */     String resolved = null;
/*     */ 
/* 134 */     if ((systemId != null) && (this.systemMap.containsKey(systemId)))
/* 135 */       resolved = (String)this.systemMap.get(systemId);
/* 136 */     else if ((publicId != null) && (this.publicMap.containsKey(publicId))) {
/* 137 */       resolved = (String)this.publicMap.get(publicId);
/*     */     }
/*     */ 
/* 140 */     if (resolved != null) {
/*     */       try {
/* 142 */         InputSource iSource = new InputSource(resolved);
/* 143 */         iSource.setPublicId(publicId);
/*     */ 
/* 156 */         URL url = new URL(resolved);
/* 157 */         InputStream iStream = url.openStream();
/* 158 */         iSource.setByteStream(iStream);
/*     */ 
/* 160 */         return iSource;
/*     */       }
/*     */       catch (Exception e) {
/* 163 */         return null;
/*     */       }
/*     */     }
/*     */ 
/* 167 */     return null;
/*     */   }
/*     */ 
/*     */   public Source resolve(String href, String base)
/*     */     throws TransformerException
/*     */   {
/* 174 */     String uri = href;
/* 175 */     String fragment = null;
/* 176 */     int hashPos = href.indexOf("#");
/* 177 */     if (hashPos >= 0) {
/* 178 */       uri = href.substring(0, hashPos);
/* 179 */       fragment = href.substring(hashPos + 1);
/*     */     }
/*     */ 
/* 182 */     String result = null;
/* 183 */     if ((href != null) && (this.uriMap.containsKey(href))) {
/* 184 */       result = (String)this.uriMap.get(href);
/*     */     }
/*     */ 
/* 187 */     if (result == null) {
/*     */       try {
/* 189 */         URL url = null;
/*     */ 
/* 191 */         if (base == null) {
/* 192 */           url = new URL(uri);
/* 193 */           result = url.toString();
/*     */         } else {
/* 195 */           URL baseURL = new URL(base);
/* 196 */           url = href.length() == 0 ? baseURL : new URL(baseURL, uri);
/* 197 */           result = url.toString();
/*     */         }
/*     */       }
/*     */       catch (MalformedURLException mue) {
/* 201 */         String absBase = makeAbsolute(base);
/* 202 */         if (!absBase.equals(base))
/*     */         {
/* 204 */           return resolve(href, absBase);
/*     */         }
/* 206 */         throw new TransformerException("Malformed URL " + href + "(base " + base + ")", mue);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 213 */     SAXSource source = new SAXSource();
/* 214 */     source.setInputSource(new InputSource(result));
/* 215 */     return source;
/*     */   }
/*     */ 
/*     */   private String makeAbsolute(String uri)
/*     */   {
/* 220 */     if (uri == null) {
/* 221 */       uri = "";
/*     */     }
/*     */     try
/*     */     {
/* 225 */       URL url = new URL(uri);
/* 226 */       return url.toString();
/*     */     } catch (MalformedURLException mue) {
/* 228 */       String dir = System.getProperty("user.dir");
/* 229 */       String file = "";
/*     */ 
/* 231 */       if (dir.endsWith("/"))
/* 232 */         file = "file://" + dir + uri;
/*     */       else {
/* 234 */         file = "file://" + dir + "/" + uri;
/*     */       }
/*     */       try
/*     */       {
/* 238 */         URL fileURL = new URL(file);
/* 239 */         return fileURL.toString(); } catch (MalformedURLException mue2) {
/*     */       }
/*     */     }
/* 242 */     return uri;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.helpers.BootstrapResolver
 * JD-Core Version:    0.6.0
 */