/*     */ package org.jboss.verifier;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.EntityMetaData;
/*     */ import org.jboss.metadata.MessageDrivenMetaData;
/*     */ import org.jboss.metadata.SessionMetaData;
/*     */ import org.jboss.verifier.event.VerificationEvent;
/*     */ import org.jboss.verifier.event.VerificationEventGeneratorSupport;
/*     */ import org.jboss.verifier.event.VerificationListener;
/*     */ import org.jboss.verifier.strategy.EJBVerifier11;
/*     */ import org.jboss.verifier.strategy.EJBVerifier20;
/*     */ import org.jboss.verifier.strategy.EJBVerifier21;
/*     */ import org.jboss.verifier.strategy.VerificationContext;
/*     */ import org.jboss.verifier.strategy.VerificationStrategy;
/*     */ 
/*     */ public class BeanVerifier
/*     */   implements VerificationContext
/*     */ {
/*  85 */   private ApplicationMetaData ejbMetaData = null;
/*  86 */   private URL ejbURL = null;
/*  87 */   private ClassLoader ejbClassLoader = null;
/*     */ 
/*  89 */   private VerificationStrategy verifier = null;
/*     */ 
/*  91 */   private boolean success = true;
/*     */ 
/*  93 */   private static Logger log = Logger.getLogger(BeanVerifier.class);
/*     */ 
/*  98 */   private VerificationEventGeneratorSupport events = new VerificationEventGeneratorSupport();
/*     */   private static final String UNRECOGNIZED_VERSION = "Unknown version string";
/*     */ 
/*     */   public void verify(URL url, ApplicationMetaData metaData)
/*     */   {
/* 117 */     verify(url, metaData, null);
/*     */   }
/*     */ 
/*     */   public void verify(URL url, ApplicationMetaData metaData, ClassLoader cl)
/*     */   {
/* 131 */     this.ejbURL = url;
/* 132 */     this.ejbMetaData = metaData;
/* 133 */     this.ejbClassLoader = cl;
/*     */ 
/* 135 */     if (metaData.isEJB1x())
/*     */     {
/* 137 */       setVerifier("Enterprise JavaBeans v1.1, Final Release");
/*     */     }
/* 139 */     else if (metaData.isEJB21())
/*     */     {
/* 141 */       setVerifier("Enterprise JavaBeans V2.1, Final Release");
/*     */     }
/*     */     else
/*     */     {
/* 145 */       setVerifier("Enterprise JavaBeans V2.0, Final Release");
/*     */     }
/*     */ 
/* 148 */     Iterator beans = this.ejbMetaData.getEnterpriseBeans();
/*     */ 
/* 150 */     while (beans.hasNext())
/*     */     {
/* 152 */       BeanMetaData bean = (BeanMetaData)beans.next();
/*     */ 
/* 154 */       if (bean.isEntity())
/*     */       {
/* 156 */         EntityMetaData entityBean = (EntityMetaData)bean;
/* 157 */         if ((metaData.isEJB2x()) && (entityBean.isCMP1x()))
/*     */         {
/* 162 */           boolean storedSuccess = this.success;
/*     */ 
/* 164 */           this.verifier.checkEntity(entityBean);
/*     */ 
/* 166 */           if (this.success != storedSuccess)
/*     */           {
/* 168 */             log.warn("The CMP 1.x EJB '" + entityBean.getEjbName() + "' generated some verification warnings. The Deployer " + "will ignore these warnings but you should check " + "your EJB to be on the safe side of things.");
/*     */           }
/*     */ 
/* 174 */           this.success = storedSuccess;
/*     */         }
/*     */         else
/*     */         {
/* 178 */           this.verifier.checkEntity(entityBean);
/*     */         }
/*     */       }
/* 181 */       else if (bean.isSession())
/*     */       {
/* 183 */         this.verifier.checkSession((SessionMetaData)bean);
/*     */       }
/*     */       else
/*     */       {
/* 187 */         this.verifier.checkMessageBean((MessageDrivenMetaData)bean);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean getSuccess()
/*     */   {
/* 200 */     return this.success;
/*     */   }
/*     */ 
/*     */   public void addVerificationListener(VerificationListener listener)
/*     */   {
/* 212 */     this.events.addVerificationListener(listener);
/*     */   }
/*     */ 
/*     */   public void removeVerificationListener(VerificationListener listener)
/*     */   {
/* 217 */     this.events.removeVerificationListener(listener);
/*     */   }
/*     */ 
/*     */   public void fireBeanChecked(VerificationEvent event)
/*     */   {
/* 222 */     this.events.fireBeanChecked(event);
/*     */   }
/*     */ 
/*     */   public void fireSpecViolation(VerificationEvent event)
/*     */   {
/* 228 */     this.success = false;
/* 229 */     this.events.fireSpecViolation(event);
/*     */   }
/*     */ 
/*     */   public ApplicationMetaData getApplicationMetaData()
/*     */   {
/* 241 */     return this.ejbMetaData;
/*     */   }
/*     */ 
/*     */   public URL getJarLocation()
/*     */   {
/* 246 */     return this.ejbURL;
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 251 */     return this.ejbClassLoader;
/*     */   }
/*     */ 
/*     */   public String getEJBVersion()
/*     */   {
/* 256 */     return "Enterprise JavaBeans v1.1, Final Release";
/*     */   }
/*     */ 
/*     */   protected void setVerifier(String version)
/*     */   {
/* 268 */     if ("Enterprise JavaBeans v1.1, Final Release".equals(version))
/*     */     {
/* 270 */       this.verifier = new EJBVerifier11(this);
/*     */     }
/* 272 */     else if ("Enterprise JavaBeans V2.0, Final Release".equals(version))
/*     */     {
/* 274 */       this.verifier = new EJBVerifier20(this);
/*     */     }
/* 276 */     else if ("Enterprise JavaBeans V2.1, Final Release".equals(version))
/*     */     {
/* 278 */       this.verifier = new EJBVerifier21(this);
/*     */     }
/*     */     else
/*     */     {
/* 282 */       throw new IllegalArgumentException("Unknown version string: " + version);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected VerificationStrategy getVerifier()
/*     */   {
/* 292 */     return this.verifier;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.verifier.BeanVerifier
 * JD-Core Version:    0.6.0
 */