/*     */ package org.jboss.verifier;
/*     */ 
/*     */ import java.text.ParseException;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.StringTokenizer;
/*     */ 
/*     */ public class Section
/*     */ {
/*     */   private String[] section;
/*     */   private String info;
/*     */   private static final String DELIMETER = ".";
/*     */   private static final String PARSE_SECTION_ERROR = "Section token cannot be longer than one character";
/*     */   private static final String GET_SECTION_INDEX_ERROR = "Section index too large";
/*     */   private static final String CONSTRUCTION_ERROR = "Cannot parse section string";
/*     */ 
/*     */   public Section(String id)
/*     */   {
/*     */     try
/*     */     {
/*  74 */       this.section = parseSection(id);
/*     */     }
/*     */     catch (ParseException e) {
/*  77 */       throw new IllegalArgumentException("Cannot parse section string");
/*     */     }
/*     */   }
/*     */ 
/*     */   public Section(String id, String info)
/*     */   {
/*  87 */     this(id);
/*  88 */     this.info = info;
/*     */   }
/*     */ 
/*     */   public String getSectionToken(int index)
/*     */   {
/* 104 */     if (this.section.length >= index) {
/* 105 */       throw new IndexOutOfBoundsException("Section index too large");
/*     */     }
/* 107 */     return this.section[index];
/*     */   }
/*     */ 
/*     */   public Iterator getSectionTokens()
/*     */   {
/* 112 */     return Collections.unmodifiableList(Arrays.asList(this.section)).iterator();
/*     */   }
/*     */ 
/*     */   public String getSection()
/*     */   {
/* 119 */     StringBuffer buffer = new StringBuffer();
/*     */ 
/* 121 */     for (int i = 0; i < this.section.length; i++)
/*     */     {
/* 123 */       buffer.append(this.section[i]);
/* 124 */       if (i + 1 < this.section.length) {
/* 125 */         buffer.append(".");
/*     */       }
/*     */     }
/* 128 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 136 */     if (this.info != null)
/*     */     {
/* 138 */       return getSection() + ": " + this.info;
/*     */     }
/*     */ 
/* 141 */     return getSection();
/*     */   }
/*     */ 
/*     */   public boolean hasInfo()
/*     */   {
/* 147 */     return this.info != null;
/*     */   }
/*     */ 
/*     */   public String getInfo()
/*     */   {
/* 152 */     return this.info;
/*     */   }
/*     */ 
/*     */   private String[] parseSection(String id)
/*     */     throws ParseException
/*     */   {
/* 169 */     StringTokenizer tokenizer = new StringTokenizer(id, ".");
/* 170 */     String[] token = new String[tokenizer.countTokens()];
/*     */ 
/* 172 */     for (int i = 0; tokenizer.hasMoreTokens(); i++) {
/* 173 */       token[i] = tokenizer.nextToken();
/*     */     }
/*     */ 
/* 176 */     return token;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.verifier.Section
 * JD-Core Version:    0.6.0
 */