/*     */ package org.jboss.verifier.event;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.EventObject;
/*     */ import org.jboss.verifier.Section;
/*     */ 
/*     */ public class VerificationEvent extends EventObject
/*     */ {
/*     */   public static final String WARNING = "WARNING";
/*     */   public static final String OK = "OK";
/*  68 */   private boolean isOk = false;
/*  69 */   private boolean isWarning = false;
/*     */ 
/*  74 */   private String message = "<undefined>";
/*  75 */   private String beanName = "<unnamed>";
/*  76 */   private Method method = null;
/*  77 */   private String section = null;
/*  78 */   private String info = null;
/*     */   private static final String STATE_NOT_RECOGNIZED = "Unknown event state";
/*     */ 
/*     */   public VerificationEvent(VerificationEventGenerator source)
/*     */   {
/*  93 */     super(source);
/*     */   }
/*     */ 
/*     */   public VerificationEvent(VerificationEventGenerator source, String message)
/*     */   {
/*  99 */     this(source);
/* 100 */     setMessage(message);
/*     */   }
/*     */ 
/*     */   public void setState(String state)
/*     */   {
/* 105 */     if ("WARNING".equalsIgnoreCase(state))
/*     */     {
/* 107 */       this.isWarning = true;
/* 108 */       this.isOk = false;
/*     */     }
/* 110 */     else if ("OK".equalsIgnoreCase(state))
/*     */     {
/* 112 */       this.isOk = true;
/* 113 */       this.isWarning = false;
/*     */     }
/*     */     else
/*     */     {
/* 117 */       throw new IllegalArgumentException("Unknown event state: " + state);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isOk()
/*     */   {
/* 124 */     return this.isOk;
/*     */   }
/*     */ 
/*     */   public boolean isWarning()
/*     */   {
/* 129 */     return this.isWarning;
/*     */   }
/*     */ 
/*     */   public void setMessage(String msg)
/*     */   {
/* 134 */     this.message = msg;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 139 */     this.beanName = name;
/*     */   }
/*     */ 
/*     */   public void setSection(Section section)
/*     */   {
/* 144 */     this.section = section.getSection();
/*     */ 
/* 146 */     if (section.hasInfo())
/* 147 */       this.info = section.getInfo();
/*     */   }
/*     */ 
/*     */   public void setMethod(Method method)
/*     */   {
/* 152 */     if (method == null) {
/* 153 */       return;
/*     */     }
/* 155 */     this.method = method;
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/* 160 */     return this.beanName + ": " + this.message;
/*     */   }
/*     */ 
/*     */   public String getVerbose()
/*     */   {
/* 165 */     StringBuffer buf = new StringBuffer(512);
/* 166 */     String linebreak = System.getProperty("line.separator");
/*     */ 
/* 168 */     buf.append(linebreak + "Bean   : " + this.beanName + linebreak);
/*     */ 
/* 170 */     if (this.method != null)
/*     */     {
/* 172 */       String returnType = getShortClassName(this.method.getReturnType());
/*     */ 
/* 174 */       Class[] arguments = this.method.getParameterTypes();
/* 175 */       String arglist = getCommaSeparatedList(getShortClassNames(arguments));
/*     */ 
/* 178 */       Class[] exceptions = this.method.getExceptionTypes();
/* 179 */       String exclist = getCommaSeparatedList(getShortClassNames(exceptions));
/*     */ 
/* 182 */       buf.append("Method : " + Modifier.toString(this.method.getModifiers()) + " " + returnType + " " + this.method.getName() + "(" + arglist + ")");
/*     */ 
/* 187 */       if (exclist.length() > 0) {
/* 188 */         buf.append(" throws " + exclist.toString());
/*     */       }
/* 190 */       buf.append(linebreak);
/*     */     }
/*     */ 
/* 193 */     int offset = this.section.lastIndexOf(".");
/* 194 */     if (!Character.isDigit(this.section.charAt(offset + 1)))
/* 195 */       buf.append("Section: " + this.section.substring(0, offset) + linebreak);
/*     */     else {
/* 197 */       buf.append("Section: " + this.section + linebreak);
/*     */     }
/* 199 */     buf.append("Warning: ");
/* 200 */     if (this.message != null)
/*     */     {
/* 202 */       buf.append(this.message + linebreak);
/*     */     }
/*     */     else
/*     */     {
/* 206 */       buf.append("No warning message found, please file a Bug report.");
/*     */     }
/*     */ 
/* 210 */     if (this.info != null) {
/* 211 */       buf.append("Info   : " + this.info + linebreak);
/*     */     }
/* 213 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 218 */     return this.beanName;
/*     */   }
/*     */ 
/*     */   private String[] getShortClassNames(Class[] c)
/*     */   {
/* 230 */     String[] names = new String[c.length];
/*     */ 
/* 232 */     for (int i = 0; i < c.length; i++) {
/* 233 */       names[i] = getShortClassName(c[i]);
/*     */     }
/* 235 */     return names;
/*     */   }
/*     */ 
/*     */   private String getShortClassName(Class c)
/*     */   {
/* 243 */     String className = c.getName();
/* 244 */     int len = className.length();
/* 245 */     int offset = className.lastIndexOf(".");
/*     */ 
/* 247 */     String name = "";
/*     */ 
/* 249 */     if (offset == -1)
/* 250 */       name = className;
/*     */     else {
/* 252 */       name = className.substring(offset + 1, len);
/*     */     }
/* 254 */     return name;
/*     */   }
/*     */ 
/*     */   private String getCommaSeparatedList(Object[] list)
/*     */   {
/* 262 */     if ((list == null) || (list.length <= 0)) {
/* 263 */       return "";
/*     */     }
/* 265 */     if (list.length == 1) {
/* 266 */       return list[0].toString();
/*     */     }
/* 268 */     StringBuffer buf = new StringBuffer(256);
/* 269 */     buf.append(list[0]);
/*     */ 
/* 271 */     for (int i = 1; i < list.length; i++)
/*     */     {
/* 273 */       buf.append(", ");
/* 274 */       buf.append(list[i]);
/*     */     }
/*     */ 
/* 277 */     return buf.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.verifier.event.VerificationEvent
 * JD-Core Version:    0.6.0
 */