/*     */ package org.jboss.verifier.strategy;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import org.jboss.metadata.EntityMetaData;
/*     */ import org.jboss.metadata.QueryMetaData;
/*     */ import org.jboss.util.Classes;
/*     */ 
/*     */ public abstract class AbstractEJB2xVerifier extends AbstractVerifier
/*     */ {
/*     */   protected EJBVerifier11 cmp1XVerifier;
/*     */   protected Class bean;
/*     */   protected Class home;
/*     */   protected Class remote;
/*     */   protected Class localHome;
/*     */   protected Class local;
/*     */   protected Class serviceEndpointInterface;
/*     */ 
/*     */   public AbstractEJB2xVerifier(VerificationContext context)
/*     */   {
/*  59 */     super(context);
/*  60 */     this.cmp1XVerifier = new EJBVerifier11(context);
/*     */   }
/*     */ 
/*     */   public boolean isCreateMethod(Method m)
/*     */   {
/*  68 */     return m.getName().startsWith("create");
/*     */   }
/*     */ 
/*     */   public boolean isEjbCreateMethod(Method m)
/*     */   {
/*  73 */     return m.getName().startsWith("ejbCreate");
/*     */   }
/*     */ 
/*     */   public boolean isEjbRemoveMethod(Method m)
/*     */   {
/*  78 */     return m.getName().startsWith("ejbRemove");
/*     */   }
/*     */ 
/*     */   public boolean isEjbSelectMethod(Method m)
/*     */   {
/*  83 */     return m.getName().startsWith("ejbSelect");
/*     */   }
/*     */ 
/*     */   public boolean isEjbHomeMethod(Method m)
/*     */   {
/*  88 */     return m.getName().startsWith("ejbHome");
/*     */   }
/*     */ 
/*     */   public boolean hasRemoteInterface(Class c)
/*     */   {
/*  95 */     return isAssignableFrom("java.rmi.Remote", c);
/*     */   }
/*     */ 
/*     */   public Iterator getEjbSelectMethods(Class c)
/*     */   {
/* 103 */     List selects = new LinkedList();
/* 104 */     Method[] method = c.getMethods();
/*     */ 
/* 106 */     for (int i = 0; i < method.length; i++)
/*     */     {
/* 108 */       if (!isEjbSelectMethod(method[i]))
/*     */         continue;
/* 110 */       selects.add(method[i]);
/*     */     }
/*     */ 
/* 114 */     return selects.iterator();
/*     */   }
/*     */ 
/*     */   public boolean hasEJBRemoveMethod(Class c)
/*     */   {
/* 122 */     Method[] method = c.getMethods();
/* 123 */     for (int i = 0; i < method.length; i++)
/*     */     {
/* 125 */       if (isEjbRemoveMethod(method[i])) {
/* 126 */         return true;
/*     */       }
/*     */     }
/* 129 */     return false;
/*     */   }
/*     */ 
/*     */   public Iterator getEJBRemoveMethods(Class c)
/*     */   {
/* 137 */     List ejbRemoves = new LinkedList();
/* 138 */     Method[] method = c.getMethods();
/*     */ 
/* 140 */     for (int i = 0; i < method.length; i++)
/*     */     {
/* 142 */       if (isEjbRemoveMethod(method[i])) {
/* 143 */         ejbRemoves.add(method[i]);
/*     */       }
/*     */     }
/* 146 */     return ejbRemoves.iterator();
/*     */   }
/*     */ 
/*     */   public Iterator getHomeMethods(Class c)
/*     */   {
/* 155 */     List homes = new LinkedList();
/* 156 */     Method[] method = c.getMethods();
/*     */ 
/* 158 */     for (int i = 0; i < method.length; i++)
/*     */     {
/* 160 */       if ((!isCreateMethod(method[i])) && (!isFinderMethod(method[i]))) {
/* 161 */         homes.add(method[i]);
/*     */       }
/*     */     }
/* 164 */     return homes.iterator();
/*     */   }
/*     */ 
/*     */   public Iterator getEjbHomeMethods(Class c)
/*     */   {
/* 169 */     List homes = new LinkedList();
/* 170 */     Method[] method = c.getMethods();
/*     */ 
/* 172 */     for (int i = 0; i < method.length; i++)
/*     */     {
/* 174 */       if (isEjbHomeMethod(method[i])) {
/* 175 */         homes.add(method[i]);
/*     */       }
/*     */     }
/* 178 */     return homes.iterator();
/*     */   }
/*     */ 
/*     */   protected boolean hasMatchingQuery(Method m, EntityMetaData e)
/*     */   {
/* 193 */     boolean result = false;
/*     */ 
/* 195 */     Iterator qIt = e.getQueries();
/* 196 */     while (qIt.hasNext())
/*     */     {
/* 198 */       QueryMetaData qmd = (QueryMetaData)qIt.next();
/*     */ 
/* 201 */       if (!qmd.getMethodName().equals(m.getName()))
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 206 */       Class[] methodParameter = m.getParameterTypes();
/* 207 */       Class[] queryParameter = null;
/*     */       try
/*     */       {
/* 211 */         queryParameter = Classes.convertToJavaClasses(qmd.getMethodParams(), this.classloader);
/*     */       }
/*     */       catch (ClassNotFoundException cnfe)
/*     */       {
/*     */       }
/*     */ 
/* 218 */       continue;
/*     */ 
/* 222 */       if (methodParameter.length != queryParameter.length)
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 228 */       boolean parametersMatch = true;
/* 229 */       for (int i = 0; i < methodParameter.length; i++)
/*     */       {
/* 231 */         if (methodParameter[i].equals(queryParameter[i]))
/*     */           continue;
/* 233 */         parametersMatch = false;
/* 234 */         break;
/*     */       }
/*     */ 
/* 238 */       if (parametersMatch)
/*     */       {
/* 240 */         result = true;
/* 241 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 245 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.verifier.strategy.AbstractEJB2xVerifier
 * JD-Core Version:    0.6.0
 */