/*      */ package org.jboss.verifier.strategy;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.Arrays;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.metadata.BeanMetaData;
/*      */ import org.jboss.metadata.EntityMetaData;
/*      */ import org.jboss.metadata.MessageDrivenMetaData;
/*      */ import org.jboss.metadata.SessionMetaData;
/*      */ import org.jboss.verifier.Section;
/*      */ 
/*      */ public class EJBVerifier20 extends AbstractEJB2xVerifier
/*      */ {
/*   50 */   private static Logger log = Logger.getLogger(EJBVerifier20.class);
/*      */ 
/*      */   public EJBVerifier20(VerificationContext context)
/*      */   {
/*   57 */     super(context);
/*      */   }
/*      */ 
/*      */   public String getMessageBundle()
/*      */   {
/*   62 */     return "EJB20Messages.properties";
/*      */   }
/*      */ 
/*      */   public void checkSession(SessionMetaData session)
/*      */   {
/*   72 */     boolean localOrRemoteExists = false;
/*   73 */     boolean verified = false;
/*      */ 
/*   75 */     if (!verifyBean(session)) {
/*   76 */       return;
/*      */     }
/*   78 */     verified = verifySessionBean(session);
/*      */ 
/*   80 */     if (hasRemoteInterfaces(session))
/*      */     {
/*   83 */       localOrRemoteExists = true;
/*   84 */       verified = (verified) && (verifySessionRemote(session));
/*   85 */       verified = (verified) && (verifySessionHome(session));
/*      */     }
/*      */ 
/*   88 */     if (hasLocalInterfaces(session))
/*      */     {
/*   91 */       localOrRemoteExists = true;
/*   92 */       verified = (verified) && (verifySessionLocal(session));
/*   93 */       verified = (verified) && (verifySessionLocalHome(session));
/*      */     }
/*      */ 
/*  102 */     if (!localOrRemoteExists)
/*      */     {
/*  104 */       fireSpecViolationEvent(session, new Section("7.10.1"));
/*  105 */       verified = false;
/*      */     }
/*      */ 
/*  108 */     if (verified)
/*      */     {
/*  111 */       fireBeanVerifiedEvent(session);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void checkEntity(EntityMetaData entity)
/*      */   {
/*  117 */     if (entity.isCMP1x())
/*      */     {
/*  119 */       this.cmp1XVerifier.checkEntity(entity);
/*      */     }
/*      */     else
/*      */     {
/*  123 */       checkBmpOrCmp2Entity(entity);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void checkMessageBean(MessageDrivenMetaData mdb)
/*      */   {
/*  129 */     boolean beanVerified = false;
/*      */ 
/*  131 */     if (!verifyBean(mdb)) {
/*  132 */       return;
/*      */     }
/*  134 */     beanVerified = verifyMessageDrivenBean(mdb);
/*      */ 
/*  136 */     if (beanVerified)
/*      */     {
/*  139 */       fireBeanVerifiedEvent(mdb);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void checkBmpOrCmp2Entity(EntityMetaData entity)
/*      */   {
/*  145 */     boolean localOrRemoteExists = false;
/*  146 */     boolean verified = false;
/*      */ 
/*  148 */     if (!verifyBean(entity)) {
/*  149 */       return;
/*      */     }
/*  151 */     if (entity.isCMP())
/*      */     {
/*  153 */       verified = verifyCMPEntityBean(entity);
/*      */     }
/*  155 */     else if (entity.isBMP())
/*      */     {
/*  157 */       verified = verifyBMPEntityBean(entity);
/*      */     }
/*      */ 
/*  160 */     if (hasRemoteInterfaces(entity))
/*      */     {
/*  163 */       localOrRemoteExists = true;
/*  164 */       verified = (verified) && (verifyEntityRemote(entity));
/*  165 */       verified = (verified) && (verifyEntityHome(entity));
/*      */     }
/*      */ 
/*  168 */     if (hasLocalInterfaces(entity))
/*      */     {
/*  171 */       localOrRemoteExists = true;
/*  172 */       verified = (verified) && (verifyEntityLocal(entity));
/*  173 */       verified = (verified) && (verifyEntityLocalHome(entity));
/*      */     }
/*      */ 
/*  176 */     verified = (verified) && (verifyPrimaryKey(entity));
/*      */ 
/*  178 */     if (!localOrRemoteExists)
/*      */     {
/*  186 */       if (entity.isCMP())
/*      */       {
/*  188 */         fireSpecViolationEvent(entity, new Section("10.6.1"));
/*  189 */         verified = false;
/*      */       }
/*      */       else
/*      */       {
/*  193 */         fireSpecViolationEvent(entity, new Section("12.2.1"));
/*  194 */         verified = false;
/*      */       }
/*      */     }
/*      */ 
/*  198 */     if (verified)
/*      */     {
/*  200 */       fireBeanVerifiedEvent(entity);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean verifyBean(BeanMetaData theBean)
/*      */   {
/*  212 */     String beanName = theBean.getEjbClass();
/*      */ 
/*  214 */     if (beanName == null) {
/*  215 */       return false;
/*      */     }
/*      */     try
/*      */     {
/*  219 */       this.bean = this.classloader.loadClass(beanName);
/*  220 */       return true;
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*  224 */       fireSpecViolationEvent(theBean, new Section("22.2.b", "Class not found on '" + beanName + "': " + cnfe.getMessage()));
/*      */     }
/*  226 */     return false;
/*      */   }
/*      */ 
/*      */   protected boolean hasRemoteInterfaces(BeanMetaData bean)
/*      */   {
/*  238 */     boolean status = true;
/*  239 */     String homeName = bean.getHome();
/*  240 */     String remoteName = bean.getRemote();
/*      */ 
/*  242 */     if ((homeName == null) || (remoteName == null)) {
/*  243 */       return false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  248 */       this.home = this.classloader.loadClass(homeName);
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*  252 */       fireSpecViolationEvent(bean, new Section("22.2.c", "Class not found on '" + homeName + "': " + cnfe.getMessage()));
/*      */ 
/*  254 */       status = false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  260 */       this.remote = this.classloader.loadClass(remoteName);
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*  264 */       fireSpecViolationEvent(bean, new Section("22.2.d", "Class not found on '" + remoteName + "': " + cnfe.getMessage()));
/*      */ 
/*  266 */       status = false;
/*      */     }
/*      */ 
/*  269 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean hasLocalInterfaces(BeanMetaData bean)
/*      */   {
/*  280 */     boolean status = true;
/*  281 */     String localHomeName = bean.getLocalHome();
/*  282 */     String localName = bean.getLocal();
/*      */ 
/*  284 */     if ((localHomeName == null) || (localName == null)) {
/*  285 */       return false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  290 */       this.localHome = this.classloader.loadClass(localHomeName);
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*  294 */       fireSpecViolationEvent(bean, new Section("22.2.e", "Class not found on '" + localHomeName + "': " + cnfe.getMessage()));
/*      */ 
/*  297 */       status = false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  302 */       this.local = this.classloader.loadClass(localName);
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*  306 */       fireSpecViolationEvent(bean, new Section("22.2.f", "Class not found on '" + localName + "': " + cnfe.getMessage()));
/*      */ 
/*  308 */       status = false;
/*      */     }
/*      */ 
/*  311 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifySessionHome(SessionMetaData session)
/*      */   {
/*  322 */     boolean status = true;
/*      */ 
/*  334 */     if (session.isStateless())
/*      */     {
/*  336 */       if (!hasDefaultCreateMethod(this.home))
/*      */       {
/*  338 */         fireSpecViolationEvent(session, new Section("7.10.6.d2"));
/*  339 */         status = false;
/*      */       }
/*      */       else
/*      */       {
/*  343 */         Method create = getDefaultCreateMethod(this.home);
/*      */ 
/*  345 */         if (hasMoreThanOneCreateMethods(this.home))
/*      */         {
/*  347 */           fireSpecViolationEvent(session, new Section("7.10.6.d2"));
/*  348 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  358 */     if (!hasEJBHomeInterface(this.home))
/*      */     {
/*  360 */       fireSpecViolationEvent(session, new Section("7.10.6.a"));
/*  361 */       status = false;
/*      */     }
/*      */ 
/*  375 */     Iterator it = Arrays.asList(this.home.getMethods()).iterator();
/*  376 */     while (it.hasNext())
/*      */     {
/*  378 */       Method method = (Method)it.next();
/*      */ 
/*  380 */       if (!hasLegalRMIIIOPArguments(method))
/*      */       {
/*  382 */         fireSpecViolationEvent(session, method, new Section("7.10.6.b1"));
/*  383 */         status = false;
/*      */       }
/*      */ 
/*  386 */       if (!hasLegalRMIIIOPReturnType(method))
/*      */       {
/*  388 */         fireSpecViolationEvent(session, method, new Section("7.10.6.b2"));
/*  389 */         status = false;
/*      */       }
/*      */ 
/*  392 */       if (!throwsRemoteException(method))
/*      */       {
/*  394 */         fireSpecViolationEvent(session, method, new Section("7.10.6.b3"));
/*  395 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  404 */     if (!hasCreateMethod(this.home))
/*      */     {
/*  406 */       fireSpecViolationEvent(session, new Section("7.10.6.d1"));
/*  407 */       status = false;
/*      */     }
/*      */ 
/*  430 */     Iterator createMethods = getCreateMethods(this.home);
/*  431 */     while (createMethods.hasNext())
/*      */     {
/*  433 */       Method create = (Method)createMethods.next();
/*      */ 
/*  435 */       if (!hasMatchingEJBCreate(this.bean, create))
/*      */       {
/*  437 */         fireSpecViolationEvent(session, create, new Section("7.10.6.e"));
/*  438 */         status = false;
/*      */       }
/*      */ 
/*  441 */       if (!hasRemoteReturnType(session, create))
/*      */       {
/*  443 */         fireSpecViolationEvent(session, create, new Section("7.10.6.f"));
/*  444 */         status = false;
/*      */       }
/*      */ 
/*  447 */       if (hasMatchingEJBCreate(this.bean, create))
/*      */       {
/*  449 */         Method ejbCreate = getMatchingEJBCreate(this.bean, create);
/*  450 */         if (!hasMatchingExceptions(ejbCreate, create))
/*      */         {
/*  452 */           fireSpecViolationEvent(session, create, new Section("7.10.6.g"));
/*      */ 
/*  454 */           status = false;
/*      */         }
/*      */       }
/*      */ 
/*  458 */       if (!throwsCreateException(create))
/*      */       {
/*  460 */         fireSpecViolationEvent(session, create, new Section("7.10.6.h"));
/*  461 */         status = false;
/*      */       }
/*      */     }
/*      */ 
/*  465 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifySessionLocalHome(SessionMetaData session)
/*      */   {
/*  476 */     boolean status = true;
/*      */ 
/*  485 */     if (session.isStateless())
/*      */     {
/*  487 */       if (!hasDefaultCreateMethod(this.localHome))
/*      */       {
/*  489 */         fireSpecViolationEvent(session, new Section("7.10.8.d2"));
/*  490 */         status = false;
/*      */       }
/*      */       else
/*      */       {
/*  494 */         Method create = getDefaultCreateMethod(this.localHome);
/*      */ 
/*  496 */         if (hasMoreThanOneCreateMethods(this.localHome))
/*      */         {
/*  498 */           fireSpecViolationEvent(session, new Section("7.10.8.d2"));
/*  499 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  509 */     if (!hasEJBLocalHomeInterface(this.localHome))
/*      */     {
/*  511 */       fireSpecViolationEvent(session, new Section("7.10.8.a"));
/*  512 */       status = false;
/*      */     }
/*      */ 
/*  520 */     Iterator it = Arrays.asList(this.localHome.getMethods()).iterator();
/*  521 */     while (it.hasNext())
/*      */     {
/*  523 */       Method method = (Method)it.next();
/*      */ 
/*  525 */       if (throwsRemoteException(method))
/*      */       {
/*  527 */         fireSpecViolationEvent(session, method, new Section("7.10.8.b"));
/*  528 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  537 */     if (!hasCreateMethod(this.localHome))
/*      */     {
/*  539 */       fireSpecViolationEvent(session, new Section("7.10.8.d1"));
/*  540 */       status = false;
/*      */     }
/*      */ 
/*  563 */     Iterator createMethods = getCreateMethods(this.localHome);
/*  564 */     while (createMethods.hasNext())
/*      */     {
/*  566 */       Method create = (Method)createMethods.next();
/*      */ 
/*  568 */       if (!hasMatchingEJBCreate(this.bean, create))
/*      */       {
/*  570 */         fireSpecViolationEvent(session, create, new Section("7.10.8.e"));
/*      */ 
/*  572 */         status = false;
/*      */       }
/*      */ 
/*  575 */       if (!hasLocalReturnType(session, create))
/*      */       {
/*  577 */         fireSpecViolationEvent(session, create, new Section("7.10.8.f"));
/*      */ 
/*  579 */         status = false;
/*      */       }
/*      */ 
/*  582 */       if (hasMatchingEJBCreate(this.bean, create))
/*      */       {
/*  584 */         Method ejbCreate = getMatchingEJBCreate(this.bean, create);
/*  585 */         if (!hasMatchingExceptions(ejbCreate, create))
/*      */         {
/*  587 */           fireSpecViolationEvent(session, create, new Section("7.10.8.g"));
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  592 */       if (!throwsCreateException(create))
/*      */       {
/*  594 */         fireSpecViolationEvent(session, create, new Section("7.10.8.h"));
/*      */ 
/*  596 */         status = false;
/*      */       }
/*      */     }
/*      */ 
/*  600 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifySessionRemote(SessionMetaData session)
/*      */   {
/*  608 */     boolean status = true;
/*      */ 
/*  615 */     if (!hasEJBObjectInterface(this.remote))
/*      */     {
/*  617 */       fireSpecViolationEvent(session, new Section("7.10.5.a"));
/*  618 */       status = false;
/*      */     }
/*      */ 
/*  632 */     Iterator it = Arrays.asList(this.remote.getMethods()).iterator();
/*  633 */     while (it.hasNext())
/*      */     {
/*  635 */       Method method = (Method)it.next();
/*      */ 
/*  637 */       if (!hasLegalRMIIIOPArguments(method))
/*      */       {
/*  639 */         fireSpecViolationEvent(session, method, new Section("7.10.5.b1"));
/*  640 */         status = false;
/*      */       }
/*      */ 
/*  643 */       if (!hasLegalRMIIIOPReturnType(method))
/*      */       {
/*  645 */         fireSpecViolationEvent(session, method, new Section("7.10.5.b2"));
/*  646 */         status = false;
/*      */       }
/*      */ 
/*  649 */       if (!throwsRemoteException(method))
/*      */       {
/*  651 */         fireSpecViolationEvent(session, method, new Section("7.10.5.b3"));
/*  652 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  669 */     it = Arrays.asList(this.remote.getDeclaredMethods()).iterator();
/*  670 */     while (it.hasNext())
/*      */     {
/*  672 */       Method remoteMethod = (Method)it.next();
/*      */ 
/*  674 */       if (!hasMatchingMethod(this.bean, remoteMethod))
/*      */       {
/*  676 */         fireSpecViolationEvent(session, remoteMethod, new Section("7.10.5.d1"));
/*      */ 
/*  679 */         status = false;
/*      */       }
/*      */ 
/*  682 */       if (hasMatchingMethod(this.bean, remoteMethod))
/*      */       {
/*      */         try
/*      */         {
/*  686 */           Method beanMethod = this.bean.getMethod(remoteMethod.getName(), remoteMethod.getParameterTypes());
/*      */ 
/*  689 */           if (!hasMatchingReturnType(remoteMethod, beanMethod))
/*      */           {
/*  691 */             fireSpecViolationEvent(session, remoteMethod, new Section("7.10.5.d2"));
/*      */ 
/*  693 */             status = false;
/*      */           }
/*      */ 
/*  696 */           if (!hasMatchingExceptions(beanMethod, remoteMethod))
/*      */           {
/*  698 */             fireSpecViolationEvent(session, remoteMethod, new Section("7.10.5.d3"));
/*      */ 
/*  700 */             status = false;
/*      */           }
/*      */         }
/*      */         catch (NoSuchMethodException ignored)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  709 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifySessionLocal(SessionMetaData session)
/*      */   {
/*  717 */     boolean status = true;
/*      */ 
/*  724 */     if (!hasEJBLocalObjectInterface(this.local))
/*      */     {
/*  726 */       fireSpecViolationEvent(session, new Section("7.10.7.a"));
/*  727 */       status = false;
/*      */     }
/*      */ 
/*  735 */     Iterator it = Arrays.asList(this.local.getMethods()).iterator();
/*  736 */     while (it.hasNext())
/*      */     {
/*  738 */       Method method = (Method)it.next();
/*  739 */       if (throwsRemoteException(method))
/*      */       {
/*  741 */         fireSpecViolationEvent(session, method, new Section("7.10.7.b"));
/*  742 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  759 */     it = Arrays.asList(this.local.getDeclaredMethods()).iterator();
/*  760 */     while (it.hasNext())
/*      */     {
/*  762 */       Method localMethod = (Method)it.next();
/*      */ 
/*  764 */       if (!hasMatchingMethod(this.bean, localMethod))
/*      */       {
/*  766 */         fireSpecViolationEvent(session, localMethod, new Section("7.10.7.d1"));
/*      */ 
/*  768 */         status = false;
/*      */       }
/*      */ 
/*  771 */       if (hasMatchingMethod(this.bean, localMethod))
/*      */       {
/*      */         try
/*      */         {
/*  775 */           Method beanMethod = this.bean.getMethod(localMethod.getName(), localMethod.getParameterTypes());
/*      */ 
/*  778 */           if (!hasMatchingReturnType(localMethod, beanMethod))
/*      */           {
/*  780 */             fireSpecViolationEvent(session, localMethod, new Section("7.10.7.d2"));
/*      */ 
/*  782 */             status = false;
/*      */           }
/*      */ 
/*  785 */           if (!hasMatchingExceptions(beanMethod, localMethod))
/*      */           {
/*  787 */             fireSpecViolationEvent(session, localMethod, new Section("7.10.7.d3"));
/*      */ 
/*  789 */             status = false;
/*      */           }
/*      */         }
/*      */         catch (NoSuchMethodException ignored)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  798 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifySessionBean(SessionMetaData session)
/*      */   {
/*  806 */     boolean status = true;
/*      */ 
/*  813 */     if (!hasSessionBeanInterface(this.bean))
/*      */     {
/*  815 */       fireSpecViolationEvent(session, new Section("7.10.2.a"));
/*  816 */       status = false;
/*      */     }
/*      */ 
/*  828 */     if (hasSessionSynchronizationInterface(this.bean))
/*      */     {
/*  830 */       if (session.isStateless())
/*      */       {
/*  832 */         fireSpecViolationEvent(session, new Section("7.5.3.a"));
/*  833 */         status = false;
/*      */       }
/*      */ 
/*  836 */       if (session.isBeanManagedTx())
/*      */       {
/*  838 */         fireSpecViolationEvent(session, new Section("7.5.3.b"));
/*  839 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  848 */     if (!hasEJBCreateMethod(this.bean, true))
/*      */     {
/*  850 */       fireSpecViolationEvent(session, new Section("7.10.3"));
/*  851 */       status = false;
/*      */     }
/*      */ 
/*  859 */     if ((hasSessionSynchronizationInterface(this.bean)) && (session.isBeanManagedTx()))
/*      */     {
/*  862 */       fireSpecViolationEvent(session, new Section("7.6.1"));
/*  863 */       status = false;
/*      */     }
/*      */ 
/*  870 */     if (!isPublic(this.bean))
/*      */     {
/*  872 */       fireSpecViolationEvent(session, new Section("7.10.2.b1"));
/*  873 */       status = false;
/*      */     }
/*      */ 
/*  880 */     if (isFinal(this.bean))
/*      */     {
/*  882 */       fireSpecViolationEvent(session, new Section("7.10.2.b2"));
/*  883 */       status = false;
/*      */     }
/*      */ 
/*  890 */     if (isAbstract(this.bean))
/*      */     {
/*  892 */       fireSpecViolationEvent(session, new Section("7.10.2.b3"));
/*  893 */       status = false;
/*      */     }
/*      */ 
/*  901 */     if (!hasDefaultConstructor(this.bean))
/*      */     {
/*  903 */       fireSpecViolationEvent(session, new Section("7.10.2.c"));
/*  904 */       status = false;
/*      */     }
/*      */ 
/*  911 */     if (hasFinalizer(this.bean))
/*      */     {
/*  913 */       fireSpecViolationEvent(session, new Section("7.10.2.d"));
/*  914 */       status = false;
/*      */     }
/*      */ 
/*  929 */     if (hasEJBCreateMethod(this.bean, true))
/*      */     {
/*  931 */       Iterator it = getEJBCreateMethods(this.bean);
/*  932 */       while (it.hasNext())
/*      */       {
/*  934 */         Method ejbCreate = (Method)it.next();
/*      */ 
/*  936 */         if (!isPublic(ejbCreate))
/*      */         {
/*  938 */           fireSpecViolationEvent(session, ejbCreate, new Section("7.10.3.b"));
/*      */ 
/*  940 */           status = false;
/*      */         }
/*      */ 
/*  943 */         if ((isFinal(ejbCreate)) || (isStatic(ejbCreate)))
/*      */         {
/*  945 */           fireSpecViolationEvent(session, ejbCreate, new Section("7.10.3.c"));
/*      */ 
/*  947 */           status = false;
/*      */         }
/*      */ 
/*  950 */         if (!hasVoidReturnType(ejbCreate))
/*      */         {
/*  952 */           fireSpecViolationEvent(session, ejbCreate, new Section("7.10.3.d"));
/*      */ 
/*  954 */           status = false;
/*      */         }
/*      */ 
/*  957 */         if (!hasLegalRMIIIOPArguments(ejbCreate))
/*      */         {
/*  959 */           fireSpecViolationEvent(session, ejbCreate, new Section("7.10.3.e"));
/*      */ 
/*  961 */           status = false;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  966 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyEntityHome(EntityMetaData entity)
/*      */   {
/*  974 */     boolean status = true;
/*      */ 
/*  981 */     if (!hasEJBHomeInterface(this.home))
/*      */     {
/*  983 */       fireSpecViolationEvent(entity, new Section("12.2.9.a"));
/*  984 */       status = false;
/*      */     }
/*      */ 
/*  998 */     Iterator methods = Arrays.asList(this.home.getMethods()).iterator();
/*  999 */     while (methods.hasNext())
/*      */     {
/* 1001 */       Method method = (Method)methods.next();
/*      */ 
/* 1003 */       if (!hasLegalRMIIIOPArguments(method))
/*      */       {
/* 1005 */         fireSpecViolationEvent(entity, method, new Section("12.2.9.b1"));
/*      */ 
/* 1007 */         status = false;
/*      */       }
/*      */ 
/* 1010 */       if (!hasLegalRMIIIOPReturnType(method))
/*      */       {
/* 1012 */         fireSpecViolationEvent(entity, method, new Section("12.2.9.b2"));
/*      */ 
/* 1014 */         status = false;
/*      */       }
/*      */ 
/* 1017 */       if (!throwsRemoteException(method))
/*      */       {
/* 1019 */         fireSpecViolationEvent(entity, method, new Section("12.2.9.b3"));
/*      */ 
/* 1021 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1034 */     methods = Arrays.asList(this.home.getMethods()).iterator();
/* 1035 */     while (methods.hasNext())
/*      */     {
/* 1037 */       Method method = (Method)methods.next();
/*      */ 
/* 1040 */       if (method.getDeclaringClass().getName().equals("javax.ejb.EJBHome")) {
/*      */         continue;
/*      */       }
/* 1043 */       if (isCreateMethod(method))
/*      */       {
/* 1066 */         if (!hasMatchingEJBCreate(this.bean, method))
/*      */         {
/* 1068 */           fireSpecViolationEvent(entity, method, new Section("12.2.9.d"));
/* 1069 */           status = false;
/*      */         }
/*      */ 
/* 1072 */         if (!hasRemoteReturnType(entity, method))
/*      */         {
/* 1074 */           fireSpecViolationEvent(entity, method, new Section("12.2.9.e"));
/* 1075 */           status = false;
/*      */         }
/*      */ 
/* 1078 */         if ((hasMatchingEJBCreate(this.bean, method)) && (hasMatchingEJBPostCreate(this.bean, method)))
/*      */         {
/* 1081 */           Method ejbCreate = getMatchingEJBCreate(this.bean, method);
/* 1082 */           Method ejbPostCreate = getMatchingEJBPostCreate(this.bean, method);
/*      */ 
/* 1084 */           if ((!hasMatchingExceptions(ejbCreate, method)) || (!hasMatchingExceptions(ejbPostCreate, method)))
/*      */           {
/* 1087 */             fireSpecViolationEvent(entity, method, new Section("12.2.9.f"));
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1092 */         if (!throwsCreateException(method))
/*      */         {
/* 1094 */           fireSpecViolationEvent(entity, method, new Section("12.2.9.g"));
/* 1095 */           status = false;
/*      */         }
/*      */       }
/* 1098 */       else if (isFinderMethod(method))
/*      */       {
/* 1121 */         if (entity.isBMP())
/*      */         {
/* 1123 */           if (!hasMatchingEJBFind(this.bean, method))
/*      */           {
/* 1125 */             fireSpecViolationEvent(entity, method, new Section("12.2.9.h"));
/*      */ 
/* 1127 */             status = false;
/*      */           }
/*      */ 
/* 1130 */           if ((!hasRemoteReturnType(entity, method)) && (!isMultiObjectFinder(method)))
/*      */           {
/* 1133 */             fireSpecViolationEvent(entity, method, new Section("12.2.9.j"));
/*      */ 
/* 1135 */             status = false;
/*      */           }
/*      */ 
/* 1138 */           if (hasMatchingEJBFind(this.bean, method))
/*      */           {
/* 1140 */             Method ejbFind = getMatchingEJBFind(this.bean, method);
/* 1141 */             if (!hasMatchingExceptions(ejbFind, method))
/*      */             {
/* 1143 */               fireSpecViolationEvent(entity, method, new Section("12.2.9.k"));
/*      */ 
/* 1145 */               status = false;
/*      */             }
/*      */           }
/*      */ 
/* 1149 */           if (!throwsFinderException(method))
/*      */           {
/* 1151 */             fireSpecViolationEvent(entity, method, new Section("12.2.9.l"));
/*      */ 
/* 1153 */             status = false;
/*      */           }
/*      */         }
/*      */ 
/* 1157 */         if (entity.isCMP())
/*      */         {
/* 1160 */           if ((!hasRemoteReturnType(entity, method)) && (!isMultiObjectFinder(method)))
/*      */           {
/* 1163 */             fireSpecViolationEvent(entity, method, new Section("10.6.10.a"));
/*      */ 
/* 1165 */             status = false;
/*      */           }
/*      */ 
/* 1168 */           if (!throwsFinderException(method))
/*      */           {
/* 1170 */             fireSpecViolationEvent(entity, method, new Section("10.6.10.b"));
/*      */ 
/* 1172 */             status = false;
/*      */           }
/*      */ 
/* 1181 */           if ((!method.getName().equals("findByPrimaryKey")) && (!method.getName().equals("findAll")) && (!hasMatchingQuery(method, entity)))
/*      */           {
/* 1185 */             fireSpecViolationEvent(entity, method, new Section("10.5.6"));
/*      */ 
/* 1187 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/* 1202 */       else if (!hasMatchingEJBHome(this.bean, method))
/*      */       {
/* 1204 */         fireSpecViolationEvent(entity, method, new Section("12.2.9.m"));
/*      */ 
/* 1206 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1212 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyEntityLocalHome(EntityMetaData entity)
/*      */   {
/* 1220 */     boolean status = true;
/*      */ 
/* 1227 */     if (!hasEJBLocalHomeInterface(this.localHome))
/*      */     {
/* 1229 */       fireSpecViolationEvent(entity, new Section("12.2.11.a"));
/* 1230 */       status = false;
/*      */     }
/*      */ 
/* 1238 */     Iterator homeMethods = Arrays.asList(this.localHome.getMethods()).iterator();
/* 1239 */     while (homeMethods.hasNext())
/*      */     {
/* 1241 */       Method method = (Method)homeMethods.next();
/*      */ 
/* 1243 */       if (throwsRemoteException(method))
/*      */       {
/* 1245 */         fireSpecViolationEvent(entity, method, new Section("12.2.11.b"));
/* 1246 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1259 */     homeMethods = Arrays.asList(this.localHome.getMethods()).iterator();
/* 1260 */     while (homeMethods.hasNext())
/*      */     {
/* 1262 */       Method method = (Method)homeMethods.next();
/*      */ 
/* 1265 */       if (method.getDeclaringClass().getName().equals("javax.ejb.EJBLocalHome")) {
/*      */         continue;
/*      */       }
/* 1268 */       if (isCreateMethod(method))
/*      */       {
/* 1291 */         if (!hasMatchingEJBCreate(this.bean, method))
/*      */         {
/* 1293 */           fireSpecViolationEvent(entity, method, new Section("12.2.11.e"));
/*      */ 
/* 1295 */           status = false;
/*      */         }
/*      */ 
/* 1298 */         if (!hasLocalReturnType(entity, method))
/*      */         {
/* 1300 */           fireSpecViolationEvent(entity, method, new Section("12.2.11.f"));
/*      */ 
/* 1302 */           status = false;
/*      */         }
/*      */ 
/* 1305 */         if ((hasMatchingEJBCreate(this.bean, method)) && (hasMatchingEJBPostCreate(this.bean, method)))
/*      */         {
/* 1308 */           Method ejbCreate = getMatchingEJBCreate(this.bean, method);
/* 1309 */           Method ejbPostCreate = getMatchingEJBPostCreate(this.bean, method);
/*      */ 
/* 1311 */           if ((!hasMatchingExceptions(ejbCreate, method)) || (!hasMatchingExceptions(ejbPostCreate, method)))
/*      */           {
/* 1314 */             fireSpecViolationEvent(entity, method, new Section("12.2.11.g"));
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1319 */         if (!throwsCreateException(method))
/*      */         {
/* 1321 */           fireSpecViolationEvent(entity, method, new Section("12.2.11.h"));
/*      */ 
/* 1323 */           status = false;
/*      */         }
/*      */       }
/* 1326 */       else if (isFinderMethod(method))
/*      */       {
/* 1348 */         if ((!hasLocalReturnType(entity, method)) && (!isMultiObjectFinder(method)))
/*      */         {
/* 1351 */           fireSpecViolationEvent(entity, method, new Section("12.2.11.j"));
/*      */ 
/* 1353 */           status = false;
/*      */         }
/*      */ 
/* 1356 */         if (!throwsFinderException(method))
/*      */         {
/* 1358 */           fireSpecViolationEvent(entity, method, new Section("12.2.11.k"));
/*      */ 
/* 1360 */           status = false;
/*      */         }
/*      */ 
/* 1363 */         if (entity.isCMP())
/*      */         {
/* 1371 */           if (hasMatchingEJBFind(this.bean, method))
/*      */           {
/* 1373 */             fireSpecViolationEvent(entity, method, new Section("10.6.2.j"));
/*      */ 
/* 1375 */             status = false;
/*      */           }
/*      */ 
/* 1386 */           if ((!method.getName().equals("findByPrimaryKey")) && (!method.getName().equals("findAll")) && (!hasMatchingQuery(method, entity)))
/*      */           {
/* 1390 */             fireSpecViolationEvent(entity, method, new Section("10.5.6"));
/*      */ 
/* 1392 */             status = false;
/*      */           }
/*      */         }
/*      */ 
/* 1396 */         if (entity.isBMP())
/*      */         {
/* 1398 */           if (!hasMatchingEJBFind(this.bean, method))
/*      */           {
/* 1400 */             fireSpecViolationEvent(entity, method, new Section("12.2.11.i"));
/*      */ 
/* 1402 */             status = false;
/*      */           }
/*      */           else
/*      */           {
/* 1406 */             Method ejbFind = getMatchingEJBFind(this.bean, method);
/*      */ 
/* 1408 */             if (!hasMatchingExceptions(ejbFind, method))
/*      */             {
/* 1410 */               fireSpecViolationEvent(entity, method, new Section("12.2.11.l"));
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/* 1427 */       else if (!hasMatchingEJBHome(this.bean, method))
/*      */       {
/* 1429 */         fireSpecViolationEvent(entity, method, new Section("12.2.11.m"));
/*      */ 
/* 1431 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1436 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyEntityLocal(EntityMetaData entity)
/*      */   {
/* 1444 */     boolean status = true;
/*      */ 
/* 1451 */     if (!hasEJBLocalObjectInterface(this.local))
/*      */     {
/* 1453 */       fireSpecViolationEvent(entity, new Section("12.2.10.a"));
/* 1454 */       status = false;
/*      */     }
/*      */ 
/* 1462 */     Iterator localMethods = Arrays.asList(this.local.getMethods()).iterator();
/* 1463 */     while (localMethods.hasNext())
/*      */     {
/* 1465 */       Method method = (Method)localMethods.next();
/*      */ 
/* 1467 */       if (throwsRemoteException(method))
/*      */       {
/* 1469 */         fireSpecViolationEvent(entity, method, new Section("12.2.10.b"));
/* 1470 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1488 */     localMethods = Arrays.asList(this.local.getMethods()).iterator();
/* 1489 */     while (localMethods.hasNext())
/*      */     {
/* 1491 */       Method method = (Method)localMethods.next();
/*      */ 
/* 1495 */       if (method.getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject")) {
/*      */         continue;
/*      */       }
/* 1498 */       if (!hasMatchingMethod(this.bean, method))
/*      */       {
/* 1500 */         fireSpecViolationEvent(entity, method, new Section("12.2.10.c"));
/* 1501 */         status = false;
/*      */       }
/*      */ 
/* 1504 */       if (hasMatchingMethod(this.bean, method))
/*      */       {
/*      */         try
/*      */         {
/* 1508 */           Method beanMethod = this.bean.getMethod(method.getName(), method.getParameterTypes());
/*      */ 
/* 1511 */           if (!hasMatchingReturnType(beanMethod, method))
/*      */           {
/* 1513 */             fireSpecViolationEvent(entity, method, new Section("12.2.10.d"));
/*      */ 
/* 1515 */             status = false;
/*      */           }
/*      */ 
/* 1518 */           if (!hasMatchingExceptions(beanMethod, method))
/*      */           {
/* 1520 */             fireSpecViolationEvent(entity, method, new Section("12.2.10.e"));
/*      */ 
/* 1523 */             status = false;
/*      */           }
/*      */         }
/*      */         catch (NoSuchMethodException ignored)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1532 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyEntityRemote(EntityMetaData entity)
/*      */   {
/* 1540 */     boolean status = true;
/*      */ 
/* 1547 */     if (!hasEJBObjectInterface(this.remote))
/*      */     {
/* 1549 */       fireSpecViolationEvent(entity, new Section("9.2.7.a"));
/* 1550 */       status = false;
/*      */     }
/*      */ 
/* 1564 */     Iterator it = Arrays.asList(this.remote.getMethods()).iterator();
/* 1565 */     while (it.hasNext())
/*      */     {
/* 1567 */       Method method = (Method)it.next();
/*      */ 
/* 1569 */       if (!hasLegalRMIIIOPArguments(method))
/*      */       {
/* 1571 */         fireSpecViolationEvent(entity, method, new Section("9.2.7.b"));
/* 1572 */         status = false;
/*      */       }
/*      */ 
/* 1575 */       if (!hasLegalRMIIIOPReturnType(method))
/*      */       {
/* 1577 */         fireSpecViolationEvent(entity, method, new Section("9.2.7.c"));
/* 1578 */         status = false;
/*      */       }
/*      */ 
/* 1581 */       if (!hasLegalRMIIIOPExceptionTypes(method))
/*      */       {
/* 1583 */         fireSpecViolationEvent(entity, method, new Section("9.2.7.h"));
/* 1584 */         status = false;
/*      */       }
/*      */ 
/* 1587 */       if (!throwsRemoteException(method))
/*      */       {
/* 1589 */         fireSpecViolationEvent(entity, method, new Section("9.2.7.d"));
/* 1590 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1608 */     it = Arrays.asList(this.remote.getMethods()).iterator();
/* 1609 */     while (it.hasNext())
/*      */     {
/* 1611 */       Method method = (Method)it.next();
/*      */ 
/* 1614 */       if (method.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) {
/*      */         continue;
/*      */       }
/* 1617 */       if (!hasMatchingMethod(this.bean, method))
/*      */       {
/* 1619 */         fireSpecViolationEvent(entity, method, new Section("9.2.7.e"));
/* 1620 */         status = false;
/*      */       }
/*      */ 
/* 1623 */       if (hasMatchingMethod(this.bean, method))
/*      */       {
/*      */         try
/*      */         {
/* 1627 */           Method beanMethod = this.bean.getMethod(method.getName(), method.getParameterTypes());
/*      */ 
/* 1630 */           if (!hasMatchingReturnType(beanMethod, method))
/*      */           {
/* 1632 */             fireSpecViolationEvent(entity, method, new Section("9.2.7.f"));
/*      */ 
/* 1634 */             status = false;
/*      */           }
/*      */ 
/* 1637 */           if (!hasMatchingExceptions(beanMethod, method))
/*      */           {
/* 1639 */             fireSpecViolationEvent(entity, method, new Section("9.2.7.g"));
/*      */ 
/* 1641 */             status = false;
/*      */           }
/*      */         }
/*      */         catch (NoSuchMethodException ignored)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1650 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyCMPEntityBean(EntityMetaData entity)
/*      */   {
/* 1658 */     boolean status = true;
/*      */ 
/* 1665 */     if (!hasEntityBeanInterface(this.bean))
/*      */     {
/* 1667 */       fireSpecViolationEvent(entity, new Section("10.6.2.a"));
/* 1668 */       status = false;
/*      */     }
/*      */ 
/* 1675 */     if ((!isPublic(this.bean)) || (!isAbstract(this.bean)))
/*      */     {
/* 1677 */       fireSpecViolationEvent(entity, new Section("10.6.2.b"));
/* 1678 */       status = false;
/*      */     }
/*      */ 
/* 1686 */     if (!hasDefaultConstructor(this.bean))
/*      */     {
/* 1688 */       fireSpecViolationEvent(entity, new Section("10.6.2.c"));
/* 1689 */       status = false;
/*      */     }
/*      */ 
/* 1696 */     if (hasFinalizer(this.bean))
/*      */     {
/* 1698 */       fireSpecViolationEvent(entity, new Section("10.6.2.d"));
/* 1699 */       status = false;
/*      */     }
/*      */ 
/* 1715 */     if (hasEJBCreateMethod(this.bean, false))
/*      */     {
/* 1717 */       Iterator it = getEJBCreateMethods(this.bean);
/* 1718 */       while (it.hasNext())
/*      */       {
/* 1720 */         Method ejbCreate = (Method)it.next();
/* 1721 */         if (!isPublic(ejbCreate))
/*      */         {
/* 1723 */           fireSpecViolationEvent(entity, ejbCreate, new Section("10.6.4.b"));
/*      */ 
/* 1725 */           status = false;
/*      */         }
/*      */ 
/* 1728 */         if ((isFinal(ejbCreate)) || (isStatic(ejbCreate)))
/*      */         {
/* 1730 */           fireSpecViolationEvent(entity, ejbCreate, new Section("10.6.4.c"));
/*      */ 
/* 1732 */           status = false;
/*      */         }
/*      */ 
/* 1735 */         if (!hasPrimaryKeyReturnType(entity, ejbCreate))
/*      */         {
/* 1737 */           fireSpecViolationEvent(entity, ejbCreate, new Section("10.6.4.d"));
/*      */ 
/* 1739 */           status = false;
/*      */         }
/*      */ 
/* 1756 */         if (!throwsCreateException(ejbCreate))
/*      */         {
/* 1758 */           fireSpecViolationEvent(entity, ejbCreate, new Section("10.6.4.g"));
/*      */ 
/* 1760 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1778 */     if (hasEJBCreateMethod(this.bean, false))
/*      */     {
/* 1780 */       Iterator it = getEJBCreateMethods(this.bean);
/*      */ 
/* 1782 */       while (it.hasNext())
/*      */       {
/* 1784 */         Method ejbCreate = (Method)it.next();
/*      */ 
/* 1786 */         if (!hasMatchingEJBPostCreate(this.bean, ejbCreate))
/*      */         {
/* 1788 */           fireSpecViolationEvent(entity, ejbCreate, new Section("10.6.5.a"));
/*      */ 
/* 1790 */           status = false;
/*      */         }
/*      */ 
/* 1793 */         if (hasMatchingEJBPostCreate(this.bean, ejbCreate))
/*      */         {
/* 1795 */           Method ejbPostCreate = getMatchingEJBPostCreate(this.bean, ejbCreate);
/*      */ 
/* 1798 */           if (!isPublic(ejbPostCreate))
/*      */           {
/* 1800 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("10.6.5.b"));
/*      */ 
/* 1802 */             status = false;
/*      */           }
/*      */ 
/* 1805 */           if (isStatic(ejbPostCreate))
/*      */           {
/* 1807 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("10.6.5.c"));
/*      */ 
/* 1809 */             status = false;
/*      */           }
/*      */ 
/* 1812 */           if (isFinal(ejbPostCreate))
/*      */           {
/* 1814 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("10.6.5.d"));
/*      */ 
/* 1816 */             status = false;
/*      */           }
/*      */ 
/* 1819 */           if (!hasVoidReturnType(ejbPostCreate))
/*      */           {
/* 1821 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("10.6.5.e"));
/*      */ 
/* 1823 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1838 */     Iterator it = getEjbHomeMethods(this.bean);
/* 1839 */     while (it.hasNext())
/*      */     {
/* 1841 */       Method ejbHome = (Method)it.next();
/* 1842 */       if (!isPublic(ejbHome))
/*      */       {
/* 1844 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.a"));
/* 1845 */         status = false;
/*      */       }
/*      */ 
/* 1848 */       if (isStatic(ejbHome))
/*      */       {
/* 1850 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.b"));
/* 1851 */         status = false;
/*      */       }
/*      */ 
/* 1854 */       if (throwsRemoteException(ejbHome))
/*      */       {
/* 1856 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.c"));
/* 1857 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1866 */     it = entity.getCMPFields();
/* 1867 */     while (it.hasNext())
/*      */     {
/* 1869 */       String fieldName = (String)it.next();
/* 1870 */       String getName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
/*      */ 
/* 1872 */       Class fieldType = null;
/*      */       try
/*      */       {
/* 1876 */         Method m = this.bean.getMethod(getName, new Class[0]);
/* 1877 */         fieldType = m.getReturnType();
/*      */ 
/* 1881 */         if (fieldType == Void.TYPE)
/*      */         {
/* 1883 */           fireSpecViolationEvent(entity, new Section("jb.7.1.b", "Field: " + fieldName));
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (NoSuchMethodException nsme)
/*      */       {
/* 1889 */         fireSpecViolationEvent(entity, new Section("10.6.2.g", "Field: " + fieldName));
/*      */ 
/* 1891 */         status = false;
/*      */       }
/*      */ 
/* 1894 */       String setName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
/*      */ 
/* 1896 */       Class[] args = new Class[1];
/* 1897 */       args[0] = fieldType;
/*      */       try
/*      */       {
/* 1901 */         Method m = this.bean.getMethod(setName, args);
/* 1902 */         fieldType = m.getReturnType();
/*      */ 
/* 1906 */         if (fieldType != Void.TYPE)
/*      */         {
/* 1908 */           fireSpecViolationEvent(entity, new Section("jb.7.1.a", "Field: " + fieldName));
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (NoSuchMethodException nsme)
/*      */       {
/*      */         try
/*      */         {
/* 1920 */           args[0] = this.classloader.loadClass("java.util.Collection");
/* 1921 */           m = this.bean.getMethod(setName, args);
/*      */         }
/*      */         catch (NoSuchMethodException nsme2)
/*      */         {
/*      */           Method m;
/* 1925 */           fireSpecViolationEvent(entity, new Section("10.6.2.h", "Field: " + fieldName));
/*      */ 
/* 1927 */           status = false;
/*      */         }
/*      */         catch (ClassNotFoundException cnfe)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1945 */     it = getEjbSelectMethods(this.bean);
/* 1946 */     while (it.hasNext())
/*      */     {
/* 1948 */       Method ejbSelect = (Method)it.next();
/*      */ 
/* 1950 */       if (!isPublic(ejbSelect))
/*      */       {
/* 1952 */         fireSpecViolationEvent(entity, ejbSelect, new Section("10.6.7.a"));
/* 1953 */         status = false;
/*      */       }
/*      */ 
/* 1956 */       if (!isAbstract(ejbSelect))
/*      */       {
/* 1958 */         fireSpecViolationEvent(entity, ejbSelect, new Section("10.6.7.b"));
/* 1959 */         status = false;
/*      */       }
/*      */ 
/* 1962 */       if (!throwsFinderException(ejbSelect))
/*      */       {
/* 1964 */         fireSpecViolationEvent(entity, ejbSelect, new Section("10.6.7.c"));
/* 1965 */         status = false;
/*      */       }
/*      */ 
/* 1968 */       if (!hasMatchingQuery(ejbSelect, entity))
/*      */       {
/* 1970 */         fireSpecViolationEvent(entity, ejbSelect, new Section("10.5.7"));
/* 1971 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1979 */     if (hasFinderMethod(this.bean))
/*      */     {
/* 1981 */       fireSpecViolationEvent(entity, new Section("10.6.2.i"));
/* 1982 */       status = false;
/*      */     }
/*      */ 
/* 1985 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyBMPEntityBean(EntityMetaData entity)
/*      */   {
/* 1993 */     boolean status = true;
/*      */ 
/* 2000 */     if (!hasEntityBeanInterface(this.bean))
/*      */     {
/* 2002 */       fireSpecViolationEvent(entity, new Section("12.2.2.a"));
/* 2003 */       status = false;
/*      */     }
/*      */ 
/* 2010 */     if ((!isPublic(this.bean)) || (isAbstract(this.bean)))
/*      */     {
/* 2012 */       fireSpecViolationEvent(entity, new Section("12.2.2.b"));
/* 2013 */       status = false;
/*      */     }
/*      */ 
/* 2020 */     if (isFinal(this.bean))
/*      */     {
/* 2022 */       fireSpecViolationEvent(entity, new Section("12.2.2.c"));
/* 2023 */       status = false;
/*      */     }
/*      */ 
/* 2031 */     if (!hasDefaultConstructor(this.bean))
/*      */     {
/* 2033 */       fireSpecViolationEvent(entity, new Section("12.2.2.d"));
/* 2034 */       status = false;
/*      */     }
/*      */ 
/* 2041 */     if (hasFinalizer(this.bean))
/*      */     {
/* 2043 */       fireSpecViolationEvent(entity, new Section("12.2.2.e"));
/* 2044 */       status = false;
/*      */     }
/*      */ 
/* 2059 */     if (hasEJBCreateMethod(this.bean, false))
/*      */     {
/* 2061 */       Iterator it = getEJBCreateMethods(this.bean);
/* 2062 */       while (it.hasNext())
/*      */       {
/* 2064 */         Method ejbCreate = (Method)it.next();
/* 2065 */         if (!isPublic(ejbCreate))
/*      */         {
/* 2067 */           fireSpecViolationEvent(entity, ejbCreate, new Section("12.2.3.a"));
/*      */ 
/* 2069 */           status = false;
/*      */         }
/*      */ 
/* 2072 */         if ((isFinal(ejbCreate)) || (isStatic(ejbCreate)))
/*      */         {
/* 2074 */           fireSpecViolationEvent(entity, ejbCreate, new Section("12.2.3.b"));
/*      */ 
/* 2076 */           status = false;
/*      */         }
/*      */ 
/* 2079 */         if (!hasPrimaryKeyReturnType(entity, ejbCreate))
/*      */         {
/* 2081 */           fireSpecViolationEvent(entity, ejbCreate, new Section("12.2.3.c"));
/*      */ 
/* 2083 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2114 */     if (hasEJBCreateMethod(this.bean, false))
/*      */     {
/* 2116 */       Iterator it = getEJBCreateMethods(this.bean);
/* 2117 */       while (it.hasNext())
/*      */       {
/* 2119 */         Method ejbCreate = (Method)it.next();
/*      */ 
/* 2121 */         if (!hasMatchingEJBPostCreate(this.bean, ejbCreate))
/*      */         {
/* 2123 */           fireSpecViolationEvent(entity, ejbCreate, new Section("12.2.4.a"));
/*      */ 
/* 2125 */           status = false;
/*      */         }
/*      */ 
/* 2128 */         if (hasMatchingEJBPostCreate(this.bean, ejbCreate))
/*      */         {
/* 2130 */           Method ejbPostCreate = getMatchingEJBPostCreate(this.bean, ejbCreate);
/*      */ 
/* 2133 */           if (!isPublic(ejbPostCreate))
/*      */           {
/* 2135 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("12.2.4.b"));
/*      */ 
/* 2137 */             status = false;
/*      */           }
/*      */ 
/* 2140 */           if ((isStatic(ejbPostCreate)) || (isFinal(ejbPostCreate)))
/*      */           {
/* 2142 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("12.2.4.c"));
/*      */ 
/* 2144 */             status = false;
/*      */           }
/*      */ 
/* 2147 */           if (!hasVoidReturnType(ejbPostCreate))
/*      */           {
/* 2149 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("12.2.4.d"));
/*      */ 
/* 2151 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2166 */     if (!hasEJBFindByPrimaryKey(this.bean))
/*      */     {
/* 2168 */       fireSpecViolationEvent(entity, new Section("12.2.5.e"));
/* 2169 */       status = false;
/*      */     }
/*      */ 
/* 2172 */     if (hasEJBFindByPrimaryKey(this.bean))
/*      */     {
/* 2174 */       Method ejbFindByPrimaryKey = getEJBFindByPrimaryKey(this.bean);
/*      */ 
/* 2176 */       if (!hasPrimaryKeyReturnType(entity, ejbFindByPrimaryKey))
/*      */       {
/* 2178 */         fireSpecViolationEvent(entity, ejbFindByPrimaryKey, new Section("12.2.5.e1"));
/*      */ 
/* 2180 */         status = false;
/*      */       }
/*      */ 
/* 2183 */       if (!isSingleObjectFinder(entity, ejbFindByPrimaryKey))
/*      */       {
/* 2185 */         fireSpecViolationEvent(entity, ejbFindByPrimaryKey, new Section("12.2.5.e2"));
/*      */ 
/* 2187 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2206 */     if (hasFinderMethod(this.bean))
/*      */     {
/* 2208 */       Iterator it = getEJBFindMethods(this.bean);
/* 2209 */       while (it.hasNext())
/*      */       {
/* 2211 */         Method finder = (Method)it.next();
/*      */ 
/* 2213 */         if (!isPublic(finder))
/*      */         {
/* 2215 */           fireSpecViolationEvent(entity, finder, new Section("12.2.5.a"));
/* 2216 */           status = false;
/*      */         }
/*      */ 
/* 2219 */         if ((isFinal(finder)) || (isStatic(finder)))
/*      */         {
/* 2221 */           fireSpecViolationEvent(entity, finder, new Section("12.2.5.b"));
/* 2222 */           status = false;
/*      */         }
/*      */ 
/* 2234 */         if ((!isSingleObjectFinder(entity, finder)) && (!isMultiObjectFinder(finder)))
/*      */         {
/* 2237 */           fireSpecViolationEvent(entity, finder, new Section("12.2.5.d"));
/* 2238 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2252 */     Iterator it = getEjbHomeMethods(this.bean);
/* 2253 */     while (it.hasNext())
/*      */     {
/* 2255 */       Method ejbHome = (Method)it.next();
/*      */ 
/* 2257 */       if (!isPublic(ejbHome))
/*      */       {
/* 2259 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.a"));
/* 2260 */         status = false;
/*      */       }
/*      */ 
/* 2263 */       if (isStatic(ejbHome))
/*      */       {
/* 2265 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.b"));
/* 2266 */         status = false;
/*      */       }
/*      */ 
/* 2269 */       if (throwsRemoteException(ejbHome))
/*      */       {
/* 2271 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.c"));
/* 2272 */         status = false;
/*      */       }
/*      */     }
/*      */ 
/* 2276 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyPrimaryKey(EntityMetaData entity)
/*      */   {
/* 2284 */     boolean status = true;
/* 2285 */     boolean cmp = entity.isCMP();
/*      */ 
/* 2287 */     if ((entity.getPrimaryKeyClass() == null) || (entity.getPrimaryKeyClass().length() == 0))
/*      */     {
/* 2290 */       if (cmp)
/* 2291 */         fireSpecViolationEvent(entity, new Section("10.6.1.a"));
/*      */       else {
/* 2293 */         fireSpecViolationEvent(entity, new Section("12.2.1.a"));
/*      */       }
/*      */ 
/* 2296 */       return false;
/*      */     }
/*      */ 
/* 2304 */     Class cls = null;
/*      */     try
/*      */     {
/* 2307 */       cls = this.classloader.loadClass(entity.getPrimaryKeyClass());
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/* 2311 */       if (cmp)
/* 2312 */         fireSpecViolationEvent(entity, new Section("10.6.13.a"));
/*      */       else {
/* 2314 */         fireSpecViolationEvent(entity, new Section("12.2.12.a"));
/*      */       }
/*      */ 
/* 2317 */       return false;
/*      */     }
/*      */ 
/* 2324 */     if (!isRMIIDLValueType(cls))
/*      */     {
/* 2326 */       if (cmp)
/* 2327 */         fireSpecViolationEvent(entity, new Section("10.6.13.b"));
/*      */       else
/* 2329 */         fireSpecViolationEvent(entity, new Section("12.2.12.b"));
/* 2330 */       status = false;
/*      */     }
/*      */ 
/* 2334 */     if ((entity.getPrimKeyField() == null) || (entity.getPrimKeyField().length() == 0))
/*      */     {
/* 2341 */       if (!cls.getName().equals("java.lang.Object"))
/*      */       {
/*      */         try
/*      */         {
/* 2347 */           Object one = cls.newInstance();
/* 2348 */           Object two = cls.newInstance();
/*      */           try
/*      */           {
/* 2351 */             if (!one.equals(two))
/*      */             {
/* 2353 */               if (cmp)
/*      */               {
/* 2356 */                 log.warn("Default instances of primary key: " + cls + " do not equate, check your equals method");
/*      */               }
/*      */               else
/*      */               {
/* 2362 */                 log.warn("Default instances of primary key: " + cls + " do not equate, check your equals method");
/*      */               }
/*      */ 
/* 2365 */               status = true;
/*      */             }
/*      */ 
/*      */           }
/*      */           catch (NullPointerException e)
/*      */           {
/*      */           }
/*      */ 
/*      */           try
/*      */           {
/* 2376 */             if (one.hashCode() != two.hashCode())
/*      */             {
/* 2378 */               if (cmp)
/*      */               {
/* 2381 */                 log.warn("Default instances of primary key: " + cls + " do not have the same hash, check your hashCode method");
/*      */               }
/*      */               else
/*      */               {
/* 2387 */                 log.warn("Default instances of primary key: " + cls + " do not have the same hash, check your hashCode method");
/*      */               }
/*      */ 
/* 2390 */               status = true;
/*      */             }
/*      */ 
/*      */           }
/*      */           catch (NullPointerException e)
/*      */           {
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (IllegalAccessException e)
/*      */         {
/* 2403 */           if (cmp)
/*      */           {
/* 2405 */             fireSpecViolationEvent(entity, new Section("10.8.2.a"));
/* 2406 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (InstantiationException e)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 2422 */       if (entity.isBMP())
/*      */       {
/* 2424 */         fireSpecViolationEvent(entity, new Section("dd.a"));
/* 2425 */         status = false;
/*      */       }
/*      */ 
/* 2433 */       boolean found = false;
/* 2434 */       Iterator it = entity.getCMPFields();
/* 2435 */       while (it.hasNext())
/*      */       {
/* 2437 */         String fieldName = (String)it.next();
/* 2438 */         if (fieldName.equals(entity.getPrimKeyField()))
/*      */         {
/* 2440 */           found = true;
/* 2441 */           break;
/*      */         }
/*      */       }
/*      */ 
/* 2445 */       if (!found)
/*      */       {
/* 2447 */         status = false;
/* 2448 */         fireSpecViolationEvent(entity, new Section("10.8.1.b"));
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 2460 */         String pkField = entity.getPrimKeyField();
/* 2461 */         String methodName = "get" + pkField.substring(0, 1).toUpperCase() + pkField.substring(1);
/*      */ 
/* 2464 */         Method method = this.bean.getMethod(methodName, new Class[0]);
/* 2465 */         if (!entity.getPrimaryKeyClass().equals(method.getReturnType().getName()))
/*      */         {
/* 2468 */           status = false;
/* 2469 */           fireSpecViolationEvent(entity, new Section("10.8.1.a"));
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (NoSuchMethodException e)
/*      */       {
/* 2480 */         status = false;
/* 2481 */         fireSpecViolationEvent(entity, new Section("10.8.1.b"));
/*      */       }
/*      */     }
/*      */ 
/* 2485 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifyMessageDrivenBean(MessageDrivenMetaData mdBean)
/*      */   {
/* 2493 */     boolean status = true;
/*      */ 
/* 2500 */     if (!hasMessageDrivenBeanInterface(this.bean))
/*      */     {
/* 2502 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.a"));
/* 2503 */       status = false;
/*      */     }
/*      */ 
/* 2511 */     if (!hasMessageListenerInterface(this.bean))
/*      */     {
/* 2513 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.b"));
/* 2514 */       status = false;
/*      */     }
/*      */ 
/* 2521 */     if (!isPublic(this.bean))
/*      */     {
/* 2523 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.c1"));
/* 2524 */       status = false;
/*      */     }
/*      */ 
/* 2531 */     if (isFinal(this.bean))
/*      */     {
/* 2533 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.c2"));
/* 2534 */       status = false;
/*      */     }
/*      */ 
/* 2541 */     if (isAbstract(this.bean))
/*      */     {
/* 2543 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.c3"));
/* 2544 */       status = false;
/*      */     }
/*      */ 
/* 2552 */     if (!hasDefaultConstructor(this.bean))
/*      */     {
/* 2554 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.d"));
/* 2555 */       status = false;
/*      */     }
/*      */ 
/* 2562 */     if (hasFinalizer(this.bean))
/*      */     {
/* 2564 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.e"));
/* 2565 */       status = false;
/*      */     }
/*      */ 
/* 2580 */     if (hasEJBCreateMethod(this.bean, false))
/*      */     {
/* 2582 */       Iterator it = getEJBCreateMethods(this.bean);
/* 2583 */       Method ejbCreate = (Method)it.next();
/*      */ 
/* 2585 */       if (!isPublic(ejbCreate))
/*      */       {
/* 2587 */         fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.b"));
/* 2588 */         status = false;
/*      */       }
/*      */ 
/* 2591 */       if ((isFinal(ejbCreate)) || (isStatic(ejbCreate)))
/*      */       {
/* 2593 */         fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.c"));
/* 2594 */         status = false;
/*      */       }
/*      */ 
/* 2597 */       if (!hasVoidReturnType(ejbCreate))
/*      */       {
/* 2599 */         fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.d"));
/* 2600 */         status = false;
/*      */       }
/*      */ 
/* 2603 */       if (!hasNoArguments(ejbCreate))
/*      */       {
/* 2605 */         fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.e"));
/* 2606 */         status = false;
/*      */       }
/*      */ 
/* 2609 */       if (!throwsNoException(ejbCreate))
/*      */       {
/* 2611 */         fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.f"));
/* 2612 */         status = false;
/*      */       }
/*      */ 
/* 2615 */       if (it.hasNext())
/*      */       {
/* 2617 */         fireSpecViolationEvent(mdBean, new Section("15.7.3.a"));
/* 2618 */         status = false;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 2623 */       fireSpecViolationEvent(mdBean, new Section("15.7.3.a"));
/* 2624 */       status = false;
/*      */     }
/*      */ 
/* 2640 */     if (hasOnMessageMethod(this.bean))
/*      */     {
/* 2642 */       Iterator it = getOnMessageMethods(this.bean);
/* 2643 */       Method onMessage = (Method)it.next();
/*      */ 
/* 2645 */       if (!isPublic(onMessage))
/*      */       {
/* 2647 */         fireSpecViolationEvent(mdBean, onMessage, new Section("15.7.4.b"));
/* 2648 */         status = false;
/*      */       }
/*      */ 
/* 2651 */       if ((isFinal(onMessage)) || (isStatic(onMessage)))
/*      */       {
/* 2653 */         fireSpecViolationEvent(mdBean, onMessage, new Section("15.7.4.c"));
/* 2654 */         status = false;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 2659 */         Class message = this.classloader.loadClass("javax.jms.Message");
/* 2660 */         if (!hasSingleArgument(onMessage, message))
/*      */         {
/* 2662 */           fireSpecViolationEvent(mdBean, onMessage, new Section("15.7.4.e"));
/*      */ 
/* 2664 */           status = false;
/*      */         }
/*      */ 
/* 2667 */         if (!throwsNoException(onMessage))
/*      */         {
/* 2669 */           fireSpecViolationEvent(mdBean, onMessage, new Section("15.7.4.f"));
/*      */ 
/* 2671 */           status = false;
/*      */         }
/*      */ 
/* 2674 */         if (it.hasNext())
/*      */         {
/* 2676 */           fireSpecViolationEvent(mdBean, new Section("15.7.4.a"));
/* 2677 */           status = false;
/*      */         }
/*      */       }
/*      */       catch (ClassNotFoundException cnfe)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 2687 */       fireSpecViolationEvent(mdBean, new Section("15.7.4.a"));
/* 2688 */       status = false;
/*      */     }
/*      */ 
/* 2703 */     if (hasEJBRemoveMethod(this.bean))
/*      */     {
/* 2705 */       Iterator it = getEJBRemoveMethods(this.bean);
/* 2706 */       Method ejbRemove = (Method)it.next();
/*      */ 
/* 2708 */       if (!isPublic(ejbRemove))
/*      */       {
/* 2710 */         fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.b"));
/* 2711 */         status = false;
/*      */       }
/*      */ 
/* 2714 */       if ((isFinal(ejbRemove)) || (isStatic(ejbRemove)))
/*      */       {
/* 2716 */         fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.c"));
/* 2717 */         status = false;
/*      */       }
/*      */ 
/* 2720 */       if (!hasVoidReturnType(ejbRemove))
/*      */       {
/* 2722 */         fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.d"));
/* 2723 */         status = false;
/*      */       }
/*      */ 
/* 2726 */       if (!hasNoArguments(ejbRemove))
/*      */       {
/* 2728 */         fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.e"));
/* 2729 */         status = false;
/*      */       }
/*      */ 
/* 2732 */       if (!throwsNoException(ejbRemove))
/*      */       {
/* 2734 */         fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.f"));
/* 2735 */         status = false;
/*      */       }
/*      */ 
/* 2738 */       if (it.hasNext())
/*      */       {
/* 2740 */         fireSpecViolationEvent(mdBean, new Section("15.7.5.a"));
/* 2741 */         status = false;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 2746 */       fireSpecViolationEvent(mdBean, new Section("15.7.5.a"));
/* 2747 */       status = false;
/*      */     }
/*      */ 
/* 2750 */     return status;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.verifier.strategy.EJBVerifier20
 * JD-Core Version:    0.6.0
 */