/*     */ package org.jboss.virtual.plugins.context.file;
/*     */ 
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import org.jboss.virtual.VFSUtils;
/*     */ import org.jboss.virtual.plugins.context.AbstractURLHandler;
/*     */ import org.jboss.virtual.plugins.context.DelegatingHandler;
/*     */ import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;
/*     */ import org.jboss.virtual.spi.LinkInfo;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VFSContextFactory;
/*     */ import org.jboss.virtual.spi.VFSContextFactoryLocator;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class LinkHandler extends AbstractURLHandler
/*     */   implements StructuredVirtualFileHandler
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private List<LinkInfo> links;
/*  58 */   private HashMap<String, VirtualFileHandler> linkTargets = new HashMap(3);
/*     */ 
/*     */   public LinkHandler(FileSystemContext context, VirtualFileHandler parent, URI uri, String name, List<LinkInfo> links)
/*     */     throws IOException, URISyntaxException
/*     */   {
/* 124 */     super(context, parent, uri.toURL(), name);
/* 125 */     this.links = links;
/* 126 */     this.vfsUrl = new URL("vfs" + uri.toURL().toString());
/*     */ 
/* 128 */     for (LinkInfo link : links)
/*     */     {
/* 130 */       String linkName = link.getName();
/* 131 */       if (linkName == null)
/* 132 */         linkName = VFSUtils.getName(link.getLinkTarget());
/* 133 */       if (linkName != null)
/*     */       {
/* 135 */         String[] paths = PathTokenizer.getTokens(linkName);
/* 136 */         int n = 0;
/* 137 */         VirtualFileHandler linkParent = this;
/*     */ 
/* 140 */         for (; n < paths.length - 1; n++)
/*     */         {
/* 142 */           String atom = paths[n];
/*     */           try
/*     */           {
/* 145 */             linkParent = linkParent.findChild(atom);
/*     */           }
/*     */           catch (IOException e)
/*     */           {
/* 149 */             break;
/*     */           }
/*     */         }
/*     */ 
/* 153 */         for (; n < paths.length - 1; n++)
/*     */         {
/* 155 */           String atom = paths[n];
/* 156 */           URL polURL = new URL(linkParent.toURI().toURL(), atom);
/* 157 */           ParentOfLink pol = new ParentOfLink(getVFSContext(), linkParent, polURL, atom);
/* 158 */           if (linkParent == this)
/*     */           {
/* 160 */             this.linkTargets.put(atom, pol);
/*     */           }
/*     */           else
/*     */           {
/* 164 */             ParentOfLink prevPOL = (ParentOfLink)linkParent;
/* 165 */             prevPOL.addChild(pol, atom);
/*     */           }
/* 167 */           linkParent = pol;
/*     */         }
/*     */ 
/* 171 */         String atom = paths[n];
/* 172 */         VirtualFileHandler linkHandler = createLinkHandler(linkParent, atom, link.getLinkTarget());
/* 173 */         if (linkParent == this)
/*     */         {
/* 175 */           this.linkTargets.put(atom, linkHandler);
/*     */         }
/*     */         else
/*     */         {
/* 179 */           ParentOfLink prevPOL = (ParentOfLink)linkParent;
/* 180 */           prevPOL.addChild(linkHandler, atom);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isLeaf()
/*     */   {
/* 188 */     return false;
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException
/*     */   {
/* 193 */     return new ArrayList(this.linkTargets.values());
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(String path) throws IOException
/*     */   {
/* 198 */     return structuredFindChild(path);
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler createChildHandler(String name) throws IOException
/*     */   {
/* 203 */     VirtualFileHandler handler = (VirtualFileHandler)this.linkTargets.get(name);
/* 204 */     if (handler == null)
/*     */     {
/* 206 */       throw new FileNotFoundException("Failed to find link for: " + name + ", parent: " + this);
/*     */     }
/* 208 */     return handler;
/*     */   }
/*     */ 
/*     */   protected void doClose()
/*     */   {
/* 214 */     super.doClose();
/* 215 */     this.links.clear();
/*     */   }
/*     */ 
/*     */   protected VirtualFileHandler createLinkHandler(VirtualFileHandler parent, String name, URI linkURI)
/*     */     throws IOException
/*     */   {
/* 221 */     VFSContextFactory factory = VFSContextFactoryLocator.getFactory(linkURI);
/* 222 */     VFSContext context = factory.getVFS(linkURI);
/* 223 */     VirtualFileHandler rootHandler = context.getRoot();
/*     */ 
/* 226 */     return new DelegatingHandler(getVFSContext(), parent, name, rootHandler);
/*     */   }
/*     */ 
/*     */   class ParentOfLink extends AbstractURLHandler
/*     */     implements StructuredVirtualFileHandler
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*  65 */     private HashMap<String, VirtualFileHandler> children = new HashMap(1);
/*     */ 
/*     */     public ParentOfLink(VFSContext context, VirtualFileHandler parent, URL url, String name)
/*     */     {
/*  70 */       super(parent, url, name);
/*     */       try
/*     */       {
/*  73 */         this.vfsUrl = new URL("vfs" + url.toString());
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/*  77 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*     */ 
/*     */     void addChild(VirtualFileHandler child, String name)
/*     */     {
/*  83 */       this.children.put(name, child);
/*     */     }
/*     */ 
/*     */     public VirtualFileHandler findChild(String path) throws IOException
/*     */     {
/*  88 */       return structuredFindChild(path);
/*     */     }
/*     */ 
/*     */     public VirtualFileHandler createChildHandler(String name) throws IOException
/*     */     {
/*  93 */       return (VirtualFileHandler)this.children.get(name);
/*     */     }
/*     */ 
/*     */     public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException
/*     */     {
/*  98 */       return null;
/*     */     }
/*     */ 
/*     */     public boolean isLeaf() throws IOException
/*     */     {
/* 103 */       return false;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.file.LinkHandler
 * JD-Core Version:    0.6.0
 */