/*     */ package org.jboss.virtual.plugins.context.jar;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.net.JarURLConnection;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.jar.JarEntry;
/*     */ import java.util.jar.JarFile;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.plugins.context.AbstractURLHandler;
/*     */ import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class AbstractJarHandler extends AbstractURLHandler
/*     */   implements StructuredVirtualFileHandler
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private transient JarFile jar;
/*     */   private transient List<VirtualFileHandler> entries;
/*     */   private transient Map<String, VirtualFileHandler> entryMap;
/*     */ 
/*     */   protected static String getEntryName(JarEntry entry)
/*     */   {
/*  83 */     if (entry == null)
/*  84 */       throw new IllegalArgumentException("Null entry");
/*  85 */     return entry.getName();
/*     */   }
/*     */ 
/*     */   protected AbstractJarHandler(VFSContext context, VirtualFileHandler parent, URL url, String name)
/*     */     throws IOException
/*     */   {
/* 100 */     super(context, parent, url, name);
/*     */   }
/*     */ 
/*     */   public JarFile getJar()
/*     */   {
/* 110 */     return this.jar;
/*     */   }
/*     */ 
/*     */   protected void initJarFile(JarFile jarFile)
/*     */     throws IOException
/*     */   {
/* 127 */     this.jar = jarFile;
/*     */ 
/* 129 */     Enumeration enumeration = this.jar.entries();
/* 130 */     if (!enumeration.hasMoreElements())
/*     */     {
/* 132 */       this.entries = Collections.emptyList();
/* 133 */       this.entryMap = Collections.emptyMap();
/* 134 */       return;
/*     */     }
/*     */ 
/* 138 */     Map parentMap = new HashMap();
/* 139 */     ArrayList levelMapList = new ArrayList();
/* 140 */     this.entries = new ArrayList();
/* 141 */     this.entryMap = new HashMap();
/* 142 */     boolean trace = log.isTraceEnabled();
/* 143 */     while (enumeration.hasMoreElements())
/*     */     {
/* 145 */       JarEntry entry = (JarEntry)enumeration.nextElement();
/* 146 */       String[] paths = entry.getName().split("/");
/* 147 */       int depth = paths.length;
/* 148 */       if (depth >= levelMapList.size())
/*     */       {
/* 150 */         for (int n = levelMapList.size(); n <= depth; n++)
/* 151 */           levelMapList.add(new ArrayList());
/*     */       }
/* 153 */       ArrayList levelMap = (ArrayList)levelMapList.get(depth);
/* 154 */       levelMap.add(entry);
/* 155 */       if (trace) {
/* 156 */         log.trace("added " + entry.getName() + " at depth " + depth);
/*     */       }
/*     */     }
/* 159 */     int level = 0;
/* 160 */     for (ArrayList levels : levelMapList)
/*     */     {
/* 162 */       if (trace)
/* 163 */         log.trace("Level(" + level++ + "): " + levels);
/* 164 */       for (JarEntry entry : levels)
/*     */       {
/* 166 */         String name = entry.getName();
/* 167 */         int slash = entry.isDirectory() ? name.lastIndexOf('/', name.length() - 2) : name.lastIndexOf('/', name.length() - 1);
/*     */ 
/* 169 */         VirtualFileHandler parent = this;
/* 170 */         String entryName = name;
/* 171 */         if (slash >= 0)
/*     */         {
/* 174 */           String parentName = name.substring(0, slash + 1);
/* 175 */           parent = (VirtualFileHandler)parentMap.get(parentName);
/* 176 */           if (parent == null)
/*     */           {
/* 179 */             parent = buildParents(parentName, parentMap, entry);
/*     */           }
/*     */         }
/*     */ 
/* 183 */         int start = slash + 1;
/* 184 */         int end = entry.isDirectory() ? name.length() - 1 : name.length();
/* 185 */         entryName = name.substring(start, end);
/* 186 */         VirtualFileHandler handler = createVirtualFileHandler(parent, entry, entryName);
/* 187 */         if (entry.isDirectory())
/*     */         {
/* 189 */           parentMap.put(name, handler);
/* 190 */           if (trace)
/* 191 */             log.trace("Added parent: " + name);
/*     */         }
/* 193 */         if (parent == this)
/*     */         {
/* 196 */           this.entries.add(handler);
/* 197 */           this.entryMap.put(entryName, handler);
/*     */         }
/* 199 */         else if ((parent instanceof JarEntryHandler))
/*     */         {
/* 202 */           JarEntryHandler ehandler = (JarEntryHandler)parent;
/* 203 */           ehandler.addChild(handler);
/*     */         }
/* 205 */         else if ((parent instanceof SynthenticDirEntryHandler))
/*     */         {
/* 208 */           SynthenticDirEntryHandler ehandler = (SynthenticDirEntryHandler)parent;
/* 209 */           ehandler.addChild(handler);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected VirtualFileHandler buildParents(String parentName, Map<String, VirtualFileHandler> parentMap, JarEntry entry)
/*     */     throws IOException
/*     */   {
/* 228 */     VirtualFileHandler parent = this;
/* 229 */     String[] paths = PathTokenizer.getTokens(parentName);
/* 230 */     StringBuilder pathName = new StringBuilder();
/* 231 */     for (String path : paths)
/*     */     {
/* 233 */       VirtualFileHandler next = null;
/* 234 */       pathName.append(path);
/* 235 */       pathName.append('/');
/*     */       try
/*     */       {
/* 238 */         next = parent.findChild(path);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 243 */         URL url = getURL(parent, path, true);
/* 244 */         next = new SynthenticDirEntryHandler(getVFSContext(), parent, path, entry.getTime(), url);
/*     */ 
/* 246 */         parentMap.put(pathName.toString(), next);
/* 247 */         if (parent == this)
/*     */         {
/* 250 */           this.entries.add(next);
/* 251 */           this.entryMap.put(path, next);
/*     */         }
/* 253 */         else if ((parent instanceof JarEntryHandler))
/*     */         {
/* 256 */           JarEntryHandler ehandler = (JarEntryHandler)parent;
/* 257 */           ehandler.addChild(next);
/*     */         }
/* 259 */         else if ((parent instanceof SynthenticDirEntryHandler))
/*     */         {
/* 262 */           SynthenticDirEntryHandler ehandler = (SynthenticDirEntryHandler)parent;
/* 263 */           ehandler.addChild(next);
/*     */         }
/*     */       }
/* 266 */       parent = next;
/*     */     }
/* 268 */     return parent;
/*     */   }
/*     */ 
/*     */   protected URL getURL(VirtualFileHandler parent, String path, boolean isDirEntry)
/*     */     throws MalformedURLException
/*     */   {
/* 283 */     StringBuilder buffer = new StringBuilder();
/*     */     try
/*     */     {
/* 286 */       String parentUrl = parent.toURL().toString();
/* 287 */       if (((parent instanceof JarEntryHandler)) || ((parent instanceof SynthenticDirEntryHandler)))
/*     */       {
/* 289 */         buffer.append(parentUrl);
/*     */       }
/*     */       else
/*     */       {
/* 293 */         buffer.append("jar:").append(parentUrl).append("!/");
/*     */       }
/*     */ 
/* 296 */       if (buffer.charAt(buffer.length() - 1) != '/')
/* 297 */         buffer.append('/');
/* 298 */       buffer.append(path);
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/* 303 */       throw new MalformedURLException(e.getMessage());
/*     */     }
/*     */ 
/* 306 */     if ((isDirEntry) && (buffer.charAt(buffer.length() - 1) != '/'))
/* 307 */       buffer.append('/');
/* 308 */     URL url = new URL(buffer.toString());
/* 309 */     return url;
/*     */   }
/*     */ 
/*     */   protected void doClose()
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean isLeaf()
/*     */   {
/* 328 */     checkClosed();
/* 329 */     return false;
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException
/*     */   {
/* 334 */     checkClosed();
/* 335 */     return this.entries;
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(String path) throws IOException
/*     */   {
/* 340 */     return structuredFindChild(path);
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler createChildHandler(String name) throws IOException
/*     */   {
/* 345 */     VirtualFileHandler child = (VirtualFileHandler)this.entryMap.get(name);
/* 346 */     if (child == null)
/* 347 */       throw new FileNotFoundException(this + " has no child: " + name);
/* 348 */     return child;
/*     */   }
/*     */ 
/*     */   protected VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, JarEntry entry, String entryName)
/*     */     throws IOException
/*     */   {
/* 365 */     if (parent == null)
/* 366 */       throw new IllegalArgumentException("Null parent");
/* 367 */     if (entry == null) {
/* 368 */       throw new IllegalArgumentException("Null entry");
/*     */     }
/* 370 */     URL url = getURL(parent, entryName, entry.isDirectory());
/* 371 */     VFSContext context = parent.getVFSContext();
/*     */     VirtualFileHandler vfh;
/*     */     VirtualFileHandler vfh;
/* 374 */     if (JarUtils.isArchive(entry.getName()))
/*     */     {
/* 376 */       String flag = (String)context.getOptions().get("useNoCopyJarHandler");
/* 377 */       boolean useNoCopyJarHandler = Boolean.valueOf(flag).booleanValue();
/*     */       VirtualFileHandler vfh;
/* 379 */       if (useNoCopyJarHandler)
/* 380 */         vfh = new NoCopyNestedJarHandler(context, parent, this.jar, entry, url);
/*     */       else
/* 382 */         vfh = NestedJarHandler.create(context, parent, this.jar, entry, url, entryName);
/*     */     }
/*     */     else
/*     */     {
/* 386 */       vfh = new JarEntryHandler(context, parent, this.jar, entry, entryName, url);
/*     */     }
/*     */ 
/* 389 */     return vfh;
/*     */   }
/*     */ 
/*     */   public static JarFile fromURL(URL url)
/*     */     throws IOException
/*     */   {
/*     */     IOException e;
/*     */     try
/*     */     {
/* 403 */       URLConnection connection = url.openConnection();
/*     */       JarURLConnection jarConnection;
/*     */       JarURLConnection jarConnection;
/* 405 */       if ((connection instanceof JarURLConnection))
/*     */       {
/* 407 */         jarConnection = (JarURLConnection)connection;
/*     */       }
/*     */       else
/*     */       {
/* 412 */         URL jarUrl = new URL("jar:" + url + "!/");
/* 413 */         jarConnection = (JarURLConnection)jarUrl.openConnection();
/*     */       }
/* 415 */       jarConnection.setUseCaches(false);
/* 416 */       return jarConnection.getJarFile();
/*     */     }
/*     */     catch (IOException original)
/*     */     {
/* 421 */       e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
/* 422 */       e.setStackTrace(original.getStackTrace());
/* 423 */     }throw e;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 440 */     in.defaultReadObject();
/*     */ 
/* 442 */     URL jarURL = super.getURL();
/* 443 */     String jarAsString = jarURL.toString();
/* 444 */     if (jarAsString.startsWith("file:"))
/*     */     {
/* 446 */       File fp = new File(jarAsString.substring(5));
/* 447 */       this.jar = new JarFile(fp);
/*     */     }
/*     */     else
/*     */     {
/* 451 */       URLConnection conn = jarURL.openConnection();
/* 452 */       if ((conn instanceof JarURLConnection))
/*     */       {
/* 454 */         JarURLConnection jconn = (JarURLConnection)conn;
/* 455 */         this.jar = jconn.getJarFile();
/*     */       }
/*     */       else
/*     */       {
/* 459 */         throw new IOException("Cannot restore from non-JarURLConnection, url: " + jarURL);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.jar.AbstractJarHandler
 * JD-Core Version:    0.6.0
 */