/*     */ package org.jboss.virtual.plugins.context.jar;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.jar.JarEntry;
/*     */ import java.util.jar.JarFile;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class NestedJarHandler extends AbstractJarHandler
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private transient JarEntry entry;
/*     */   private transient File temp;
/*     */   private transient URL original;
/*     */ 
/*     */   private static JarFile createTempJar(File temp, JarFile parentJar, JarEntry entry)
/*     */     throws IOException
/*     */   {
/*  70 */     InputStream inputStream = parentJar.getInputStream(entry);
/*     */     try
/*     */     {
/*  73 */       FileOutputStream outputStream = new FileOutputStream(temp);
/*     */       try
/*     */       {
/*  76 */         byte[] buffer = new byte[8096];
/*  77 */         int read = inputStream.read(buffer);
/*  78 */         while (read != -1)
/*     */         {
/*  80 */           outputStream.write(buffer, 0, read);
/*  81 */           read = inputStream.read(buffer);
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/*  86 */         outputStream.close();
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/*  93 */         inputStream.close();
/*     */       }
/*     */       catch (IOException ignored)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 100 */     return new JarFile(temp);
/*     */   }
/*     */ 
/*     */   public static NestedJarHandler create(VFSContext context, VirtualFileHandler parent, JarFile parentJar, JarEntry entry, URL url, String entryName)
/*     */     throws IOException
/*     */   {
/* 106 */     File temp = null;
/*     */     try
/*     */     {
/* 110 */       temp = File.createTempFile("nestedjar", null);
/* 111 */       temp.deleteOnExit();
/*     */     }
/*     */     catch (IOException original)
/*     */     {
/* 116 */       IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
/* 117 */       e.setStackTrace(original.getStackTrace());
/* 118 */       throw e;
/*     */     }
/* 120 */     return new NestedJarHandler(context, parent, parentJar, entry, url, temp, entryName);
/*     */   }
/*     */ 
/*     */   protected NestedJarHandler(VFSContext context, VirtualFileHandler parent, JarFile parentJar, JarEntry entry, URL original, File temp, String entryName)
/*     */     throws IOException
/*     */   {
/* 140 */     super(context, parent, temp.toURL(), entryName);
/*     */     try
/*     */     {
/* 144 */       String vfsParentUrl = parent.toVfsUrl().toString();
/* 145 */       if (vfsParentUrl.endsWith("/")) this.vfsUrl = new URL(vfsParentUrl + entryName); else
/* 146 */         this.vfsUrl = new URL(vfsParentUrl + "/" + entryName);
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/* 150 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/* 153 */     this.temp = temp;
/* 154 */     this.original = original;
/*     */     try
/*     */     {
/* 158 */       initJarFile(createTempJar(temp, parentJar, entry));
/*     */     }
/*     */     catch (IOException old)
/*     */     {
/* 163 */       IOException e = new IOException("Error opening jar file: " + original + " reason=" + old.getMessage());
/* 164 */       e.setStackTrace(old.getStackTrace());
/* 165 */       throw e;
/*     */     }
/*     */ 
/* 168 */     this.entry = entry;
/*     */   }
/*     */ 
/*     */   protected JarEntry getEntry()
/*     */   {
/* 178 */     checkClosed();
/* 179 */     return this.entry;
/*     */   }
/*     */ 
/*     */   public long getLastModified()
/*     */     throws IOException
/*     */   {
/* 185 */     return getEntry().getTime();
/*     */   }
/*     */ 
/*     */   public long getSize()
/*     */     throws IOException
/*     */   {
/* 191 */     return getEntry().getSize();
/*     */   }
/*     */ 
/*     */   public InputStream openStream()
/*     */     throws IOException
/*     */   {
/* 200 */     FileInputStream fis = new FileInputStream(this.temp);
/* 201 */     return fis;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 214 */     JarFile parentJar = super.getJar();
/*     */ 
/* 216 */     super.initJarFile(parentJar);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.jar.NestedJarHandler
 * JD-Core Version:    0.6.0
 */