/*     */ package org.jboss.virtual.plugins.context.jar;
/*     */ 
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.virtual.plugins.context.AbstractURLHandler;
/*     */ import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class SynthenticDirEntryHandler extends AbstractURLHandler
/*     */   implements StructuredVirtualFileHandler
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private long lastModified;
/*     */   private transient List<VirtualFileHandler> entryChildren;
/*     */   private transient Map<String, VirtualFileHandler> entryMap;
/*     */ 
/*     */   public SynthenticDirEntryHandler(VFSContext context, VirtualFileHandler parent, String entryName, long lastModified, URL url)
/*     */     throws IOException
/*     */   {
/*  72 */     super(context, parent, url, entryName);
/*     */     try
/*     */     {
/*  75 */       URL parentVfsUrl = parent.toVfsUrl();
/*  76 */       String vfsParentUrl = parentVfsUrl.toString();
/*  77 */       if (vfsParentUrl.endsWith("/"))
/*     */       {
/*  79 */         this.vfsUrl = new URL(vfsParentUrl + entryName);
/*     */       }
/*     */       else
/*     */       {
/*  83 */         this.vfsUrl = new URL(vfsParentUrl + "/" + entryName + "/");
/*     */       }
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/*  88 */       throw new RuntimeException(e);
/*     */     }
/*  90 */     this.lastModified = lastModified;
/*     */   }
/*     */ 
/*     */   public synchronized void addChild(VirtualFileHandler child)
/*     */   {
/*  99 */     if (this.entryChildren == null)
/* 100 */       this.entryChildren = new ArrayList();
/* 101 */     this.entryChildren.add(child);
/* 102 */     if (this.entryMap != null)
/* 103 */       this.entryMap.put(child.getName(), child);
/*     */   }
/*     */ 
/*     */   public long getLastModified()
/*     */   {
/* 109 */     return this.lastModified;
/*     */   }
/*     */ 
/*     */   public long getSize()
/*     */   {
/* 115 */     return 0L;
/*     */   }
/*     */ 
/*     */   public boolean exists()
/*     */     throws IOException
/*     */   {
/* 124 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isLeaf()
/*     */   {
/* 129 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isHidden()
/*     */   {
/* 134 */     checkClosed();
/* 135 */     return false;
/*     */   }
/*     */ 
/*     */   public InputStream openStream()
/*     */     throws IOException
/*     */   {
/* 141 */     throw new IOException("Directories cannot be opened");
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException
/*     */   {
/* 146 */     checkClosed();
/* 147 */     List children = this.entryChildren;
/* 148 */     if (this.entryChildren == null)
/* 149 */       children = Collections.emptyList();
/* 150 */     return children;
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(String path) throws IOException
/*     */   {
/* 155 */     return structuredFindChild(path);
/*     */   }
/*     */ 
/*     */   public synchronized VirtualFileHandler createChildHandler(String name)
/*     */     throws IOException
/*     */   {
/* 169 */     if (this.entryChildren == null)
/* 170 */       throw new FileNotFoundException(this + " has no children");
/* 171 */     if (this.entryMap == null)
/*     */     {
/* 173 */       this.entryMap = new HashMap();
/* 174 */       for (VirtualFileHandler child : this.entryChildren)
/* 175 */         this.entryMap.put(child.getName(), child);
/*     */     }
/* 177 */     VirtualFileHandler child = (VirtualFileHandler)this.entryMap.get(name);
/* 178 */     if (child == null)
/* 179 */       throw new FileNotFoundException(this + " has no child: " + name);
/* 180 */     return child;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.jar.SynthenticDirEntryHandler
 * JD-Core Version:    0.6.0
 */