/*     */ package org.jboss.virtual.plugins.context.memory;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VFSContextFactory;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class MemoryContextFactory
/*     */   implements VFSContextFactory
/*     */ {
/*  45 */   private static final String[] PROTOCOLS = { "vfsmemory" };
/*     */ 
/*  47 */   private static MemoryContextFactory instance = new MemoryContextFactory();
/*  48 */   private Map<String, MemoryContext> registry = new ConcurrentHashMap();
/*     */ 
/*     */   public static MemoryContextFactory getInstance()
/*     */   {
/*  60 */     return instance;
/*     */   }
/*     */ 
/*     */   public String[] getProtocols()
/*     */   {
/*  65 */     return PROTOCOLS;
/*     */   }
/*     */ 
/*     */   public VFSContext getVFS(URL rootURL) throws IOException
/*     */   {
/*  70 */     return createRoot(rootURL);
/*     */   }
/*     */ 
/*     */   public VFSContext getVFS(URI rootURI) throws IOException
/*     */   {
/*  75 */     return createRoot(rootURI.toURL());
/*     */   }
/*     */ 
/*     */   public MemoryContext find(String host)
/*     */   {
/*  85 */     return (MemoryContext)this.registry.get(host);
/*     */   }
/*     */ 
/*     */   public VFSContext createRoot(URL url)
/*     */   {
/*     */     try
/*     */     {
/*  99 */       if ((url.getPath() != null) && (url.getPath().length() > 0))
/*     */       {
/* 101 */         throw new IllegalArgumentException("Root can not contain '/'");
/*     */       }
/*     */ 
/* 104 */       String rootName = url.getHost();
/* 105 */       MemoryContext ctx = (MemoryContext)this.registry.get(rootName);
/* 106 */       if (ctx == null)
/*     */       {
/* 108 */         URL ctxURL = new URL("vfsmemory://" + rootName);
/* 109 */         ctx = new MemoryContext(ctxURL);
/* 110 */         this.registry.put(rootName, ctx);
/*     */       }
/*     */ 
/* 113 */       return ctx;
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 117 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (URISyntaxException e) {
/*     */     }
/* 121 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler createDirectory(URL url)
/*     */   {
/* 133 */     String rootName = url.getHost();
/* 134 */     MemoryContext ctx = (MemoryContext)this.registry.get(rootName);
/* 135 */     if (ctx == null)
/*     */     {
/* 137 */       throw new IllegalArgumentException("No MemoryContext exists for " + rootName);
/*     */     }
/*     */ 
/* 140 */     return ctx.createDirectory(url);
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler putFile(URL url, byte[] contents)
/*     */   {
/* 152 */     String rootName = url.getHost();
/* 153 */     MemoryContext ctx = (MemoryContext)this.registry.get(rootName);
/* 154 */     if (ctx == null)
/*     */     {
/* 156 */       throw new RuntimeException("No MemoryContext exists for " + rootName);
/*     */     }
/*     */ 
/* 159 */     return ctx.putFile(url, contents);
/*     */   }
/*     */ 
/*     */   public boolean deleteRoot(URL url)
/*     */   {
/* 170 */     if ((url.getPath() != null) && (url.getPath().length() > 0))
/*     */     {
/* 172 */       throw new IllegalArgumentException("Root can not contain '/'");
/*     */     }
/*     */ 
/* 175 */     String rootName = url.getHost();
/* 176 */     return this.registry.remove(rootName) != null;
/*     */   }
/*     */ 
/*     */   public boolean delete(URL url)
/*     */   {
/*     */     try
/*     */     {
/* 188 */       if ((url.getPath() == null) || (url.getPath().length() == 0))
/*     */       {
/* 190 */         return deleteRoot(url);
/*     */       }
/*     */ 
/* 193 */       String rootName = url.getHost();
/* 194 */       MemoryContext ctx = (MemoryContext)this.registry.get(rootName);
/* 195 */       if (ctx != null)
/*     */       {
/* 197 */         MemoryContextHandler child = (MemoryContextHandler)ctx.findChild(ctx.getRoot(), url.getPath());
/* 198 */         MemoryContextHandler parent = (MemoryContextHandler)child.getParent();
/* 199 */         return parent.deleteChild(child);
/*     */       }
/* 201 */       return false;
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 205 */     throw new RuntimeException(e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.memory.MemoryContextFactory
 * JD-Core Version:    0.6.0
 */