/*     */ package org.jboss.virtual.plugins.context.vfs;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URISyntaxException;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class AssembledContextFactory
/*     */ {
/*  36 */   private ConcurrentHashMap<String, AssembledDirectory> registry = new ConcurrentHashMap();
/*     */   private volatile int count;
/*  38 */   private static AssembledContextFactory instance = new AssembledContextFactory();
/*     */ 
/*     */   public AssembledDirectory create(String name, String rootName)
/*     */   {
/*  50 */     if (this.registry.containsKey(name)) throw new RuntimeException("Assembled context already exists for name: " + name);
/*     */     try
/*     */     {
/*  53 */       AssembledContext context = new AssembledContext(name, rootName);
/*  54 */       AssembledDirectory directory = (AssembledDirectory)context.getRoot().getVirtualFile();
/*  55 */       this.registry.put(name, directory);
/*  56 */       return directory;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  60 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (URISyntaxException e) {
/*     */     }
/*  64 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public AssembledDirectory find(String name)
/*     */   {
/*  76 */     return (AssembledDirectory)this.registry.get(name);
/*     */   }
/*     */ 
/*     */   public AssembledDirectory create(String rootName)
/*     */   {
/*  89 */     String name = "" + System.currentTimeMillis() + "" + this.count++;
/*  90 */     return create(name, rootName);
/*     */   }
/*     */ 
/*     */   public void remove(AssembledDirectory directory)
/*     */   {
/*     */     try
/*     */     {
/* 102 */       if (directory.getParent() != null) throw new RuntimeException("This is not the root of assembly");
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 106 */       throw new RuntimeException(e);
/*     */     }
/* 108 */     this.registry.remove(((AssembledContext)directory.getHandler().getVFSContext()).getName());
/*     */   }
/*     */ 
/*     */   public static AssembledContextFactory getInstance()
/*     */   {
/* 113 */     return instance;
/*     */   }
/*     */ 
/*     */   public static void setInstance(AssembledContextFactory instance)
/*     */   {
/* 118 */     instance = instance;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.vfs.AssembledContextFactory
 * JD-Core Version:    0.6.0
 */