/*     */ package org.jboss.virtual.plugins.context.vfs;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
/*     */ import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ @Assembled
/*     */ public class AssembledDirectoryHandler extends AbstractVirtualFileHandler
/*     */   implements StructuredVirtualFileHandler
/*     */ {
/*  49 */   private long lastModified = System.currentTimeMillis();
/*  50 */   private List<VirtualFileHandler> children = new ArrayList();
/*  51 */   private Map<String, VirtualFileHandler> childrenMap = new HashMap();
/*     */ 
/*     */   public AssembledDirectoryHandler(AssembledContext context, AssembledDirectoryHandler parent, String name) throws IOException
/*     */   {
/*  55 */     super(context, parent, name);
/*  56 */     String path = getPathName();
/*  57 */     if (!path.endsWith("/")) path = path + "/";
/*  58 */     this.vfsUrl = new URL("vfs", context.getName(), -1, path, new AssembledUrlStreamHandler(context));
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler addChild(VirtualFileHandler handler)
/*     */   {
/*  63 */     if (!handler.getClass().isAnnotationPresent(Assembled.class))
/*     */     {
/*     */       try
/*     */       {
/*  67 */         handler = new AssembledFileHandler((AssembledContext)getVFSContext(), this, handler.getName(), handler);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*  71 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*  74 */     this.children.add(handler);
/*  75 */     this.childrenMap.put(handler.getName(), handler);
/*  76 */     this.lastModified = System.currentTimeMillis();
/*  77 */     return handler;
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler getChild(String name)
/*     */   {
/*  82 */     return (VirtualFileHandler)this.childrenMap.get(name);
/*     */   }
/*     */ 
/*     */   public URI toURI() throws URISyntaxException
/*     */   {
/*  87 */     return this.vfsUrl.toURI();
/*     */   }
/*     */ 
/*     */   public long getLastModified() throws IOException
/*     */   {
/*  92 */     return this.lastModified;
/*     */   }
/*     */ 
/*     */   public long getSize() throws IOException
/*     */   {
/*  97 */     return 0L;
/*     */   }
/*     */ 
/*     */   public boolean exists() throws IOException
/*     */   {
/* 102 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isLeaf() throws IOException
/*     */   {
/* 107 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isHidden() throws IOException
/*     */   {
/* 112 */     return false;
/*     */   }
/*     */ 
/*     */   public InputStream openStream() throws IOException
/*     */   {
/* 117 */     throw new RuntimeException("Cannot open stream");
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException
/*     */   {
/* 122 */     return this.children;
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler createChildHandler(String name) throws IOException
/*     */   {
/* 127 */     VirtualFileHandler handler = (VirtualFileHandler)this.childrenMap.get(name);
/* 128 */     if (handler == null) throw new IOException("Could not locate child: " + name);
/* 129 */     return handler;
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(String path) throws IOException
/*     */   {
/* 134 */     return structuredFindChild(path);
/*     */   }
/*     */ 
/*     */   public VirtualFile getVirtualFile()
/*     */   {
/* 140 */     checkClosed();
/* 141 */     increment();
/* 142 */     return new AssembledDirectory(this);
/*     */   }
/*     */ 
/*     */   public URL toURL()
/*     */     throws MalformedURLException, URISyntaxException
/*     */   {
/* 148 */     return this.vfsUrl;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.vfs.AssembledDirectoryHandler
 * JD-Core Version:    0.6.0
 */