/*     */ package org.jboss.virtual.plugins.vfs;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class VirtualFileURLConnection extends URLConnection
/*     */ {
/*  43 */   public static Map<URL, VFS> urlCache = Collections.synchronizedMap(new HashMap());
/*     */   protected VirtualFile file;
/*     */   protected URL vfsurl;
/*     */   protected String relativePath;
/*     */ 
/*     */   public VirtualFileURLConnection(URL url, URL vfsurl, String relativePath)
/*     */   {
/*  51 */     super(url);
/*  52 */     this.vfsurl = vfsurl;
/*  53 */     this.relativePath = relativePath;
/*     */   }
/*     */ 
/*     */   public VirtualFileURLConnection(URL url, VirtualFile file)
/*     */   {
/*  58 */     super(url);
/*  59 */     this.file = file;
/*     */   }
/*     */ 
/*     */   public void connect() throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object getContent() throws IOException
/*     */   {
/*  68 */     return getVirtualFile();
/*     */   }
/*     */ 
/*     */   public static VirtualFile resolveCachedVirtualFile(URL vfsurl, String relativePath) throws IOException
/*     */   {
/*  73 */     VFS vfs = (VFS)urlCache.get(vfsurl);
/*  74 */     if (vfs == null)
/*     */     {
/*  76 */       vfs = VFS.getVFS(vfsurl);
/*  77 */       urlCache.put(vfsurl, vfs);
/*     */     }
/*  84 */     else if (vfs.getRoot().getHandler().hasBeenModified())
/*     */     {
/*  86 */       vfs = VFS.getVFS(vfsurl);
/*  87 */       urlCache.put(vfsurl, vfs);
/*     */     }
/*     */ 
/*  90 */     return vfs.findChild(relativePath);
/*     */   }
/*     */ 
/*     */   public static VirtualFile resolveVirtualFile(URL vfsurl, String relativePath) throws IOException
/*     */   {
/*  95 */     VFS vfs = VFS.getVFS(vfsurl);
/*  96 */     return vfs.findChild(relativePath);
/*     */   }
/*     */ 
/*     */   public synchronized VirtualFile getVirtualFile() throws IOException
/*     */   {
/* 101 */     if (this.file == null)
/*     */     {
/* 103 */       if (getUseCaches())
/*     */       {
/* 105 */         this.file = resolveCachedVirtualFile(this.vfsurl, this.relativePath);
/*     */       }
/*     */       else
/*     */       {
/* 109 */         this.file = resolveVirtualFile(this.vfsurl, this.relativePath);
/*     */       }
/*     */     }
/* 112 */     return this.file;
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream() throws IOException
/*     */   {
/* 117 */     return getVirtualFile().openStream();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.vfs.VirtualFileURLConnection
 * JD-Core Version:    0.6.0
 */