/*    */ package org.jboss.virtual.plugins.vfs;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.net.URISyntaxException;
/*    */ import java.net.URL;
/*    */ import java.net.URLConnection;
/*    */ import java.net.URLStreamHandler;
/*    */ import org.jboss.virtual.spi.VFSContext;
/*    */ import org.jboss.virtual.spi.VirtualFileHandler;
/*    */ 
/*    */ public class VirtualFileUrlStreamHandler extends URLStreamHandler
/*    */ {
/*    */   private final VFSContext context;
/*    */ 
/*    */   public VirtualFileUrlStreamHandler(VirtualFileHandler handler)
/*    */   {
/* 45 */     this.context = handler.getVFSContext();
/*    */   }
/*    */ 
/*    */   protected URLConnection openConnection(URL u) throws IOException
/*    */   {
/*    */     String baseRootUrl;
/*    */     try {
/* 53 */       baseRootUrl = this.context.getRoot().toVfsUrl().toString();
/*    */     }
/*    */     catch (URISyntaxException e)
/*    */     {
/* 57 */       throw new RuntimeException(e);
/*    */     }
/*    */     catch (IOException e)
/*    */     {
/* 61 */       throw new RuntimeException(e);
/*    */     }
/* 63 */     String urlString = u.toString();
/* 64 */     int idx = urlString.indexOf(baseRootUrl);
/* 65 */     if (idx == -1) {
/* 66 */       throw new IOException(u.toString() + " does not belong to the same VFS context as " + baseRootUrl);
/*    */     }
/* 68 */     String path = urlString.substring(baseRootUrl.length());
/* 69 */     VirtualFileHandler vf = this.context.getRoot().findChild(path);
/* 70 */     if (vf == null) {
/* 71 */       throw new IOException(path + " was not found in VFS context " + baseRootUrl);
/*    */     }
/* 73 */     return new VirtualFileURLConnection(u, vf.getVirtualFile());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.vfs.VirtualFileUrlStreamHandler
 * JD-Core Version:    0.6.0
 */