/*    */ package org.jboss.virtual.protocol.vfsmemory;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.io.PrintStream;
/*    */ import java.net.URL;
/*    */ import java.net.URLConnection;
/*    */ import java.net.URLStreamHandler;
/*    */ import org.jboss.virtual.VirtualFile;
/*    */ import org.jboss.virtual.plugins.context.memory.MemoryContext;
/*    */ import org.jboss.virtual.plugins.context.memory.MemoryContextFactory;
/*    */ import org.jboss.virtual.plugins.vfs.VirtualFileURLConnection;
/*    */ import org.jboss.virtual.spi.VirtualFileHandler;
/*    */ 
/*    */ public class Handler extends URLStreamHandler
/*    */ {
/*    */   protected URLConnection openConnection(URL u)
/*    */     throws IOException
/*    */   {
/* 45 */     String host = u.getHost();
/* 46 */     MemoryContext ctx = MemoryContextFactory.getInstance().find(host);
/* 47 */     if (ctx == null) {
/* 48 */       throw new IOException("vfs does not exist: " + u.toString());
/*    */     }
/* 50 */     VirtualFile vf = ctx.findChild(ctx.getRoot(), u.getPath()).getVirtualFile();
/* 51 */     if (vf == null) {
/* 52 */       throw new IOException("vfs does not exist: " + u.toString());
/*    */     }
/* 54 */     return new VirtualFileURLConnection(u, vf);
/*    */   }
/*    */ 
/*    */   public static void main(String[] args) throws Exception
/*    */   {
/* 59 */     System.setProperty("java.protocol.handler.pkgs", "org.jboss.virtual.protocol");
/*    */ 
/* 64 */     URL rootURL = new URL("vfsmemory://aopdomain2");
/* 65 */     MemoryContextFactory.getInstance().createRoot(rootURL);
/*    */ 
/* 67 */     URL url = new URL("vfsmemory://aopdomain2/org/foo/Test.class");
/* 68 */     MemoryContextFactory.getInstance().putFile(url, new byte[] { 97, 98, 99 });
/* 69 */     URL url2 = new URL("vfsmemory://aopdomain2/org/bar/Test.class");
/* 70 */     MemoryContextFactory.getInstance().putFile(url2, new byte[] { 100, 101, 102 });
/*    */ 
/* 72 */     System.out.println("---------");
/* 73 */     InputStream is = url.openStream();
/* 74 */     while (is.available() != 0)
/*    */     {
/* 76 */       System.out.print((char)is.read());
/*    */     }
/* 78 */     is.close();
/*    */ 
/* 80 */     System.out.println("---------");
/* 81 */     MemoryContextFactory.getInstance().createRoot(rootURL);
/* 82 */     InputStream is2 = url2.openStream();
/* 83 */     while (is2.available() != 0)
/*    */     {
/* 85 */       System.out.print((char)is2.read());
/*    */     }
/* 87 */     is.close();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.protocol.vfsmemory.Handler
 * JD-Core Version:    0.6.0
 */