/*     */ package org.jboss.web;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ 
/*     */ public class WebApplication
/*     */ {
/*     */   private VFSDeploymentUnit unit;
/*  44 */   protected ClassLoader classLoader = null;
/*     */ 
/*  46 */   protected String name = "";
/*     */   protected String canonicalName;
/*     */   protected URL url;
/*     */   protected JBossWebMetaData metaData;
/*     */   protected Object data;
/*     */   protected String domain;
/*  59 */   protected boolean java2ClassLoadingCompliance = false;
/*     */ 
/*  63 */   protected boolean unpackWars = true;
/*     */ 
/*  68 */   protected boolean lenientEjbLink = false;
/*     */   protected String defaultSecurityDomain;
/*  73 */   protected HashMap vhostToHostNames = new HashMap();
/*     */   protected Object deployerConfig;
/*     */ 
/*     */   public WebApplication()
/*     */   {
/*     */   }
/*     */ 
/*     */   public WebApplication(JBossWebMetaData metaData)
/*     */   {
/*  89 */     this.metaData = metaData;
/*     */   }
/*     */ 
/*     */   public WebApplication(String name, URL url, ClassLoader classLoader)
/*     */   {
/* 100 */     this.name = name;
/* 101 */     this.url = url;
/* 102 */     this.classLoader = classLoader;
/*     */   }
/*     */ 
/*     */   public VFSDeploymentUnit getDeploymentUnit()
/*     */   {
/* 107 */     return this.unit;
/*     */   }
/*     */ 
/*     */   public void setDeploymentUnit(VFSDeploymentUnit unit) {
/* 111 */     this.unit = unit;
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 119 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader classLoader)
/*     */   {
/* 127 */     this.classLoader = classLoader;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 135 */     String n = this.name;
/* 136 */     if (n == null)
/* 137 */       n = this.url.getFile();
/* 138 */     return n;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 146 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getCanonicalName()
/*     */   {
/* 151 */     return this.canonicalName;
/*     */   }
/*     */ 
/*     */   public void setCanonicalName(String canonicalName) {
/* 155 */     this.canonicalName = canonicalName;
/*     */   }
/*     */ 
/*     */   public URL getURL()
/*     */   {
/* 163 */     return this.url;
/*     */   }
/*     */ 
/*     */   public void setURL(URL url)
/*     */   {
/* 171 */     if (url == null)
/* 172 */       throw new IllegalArgumentException("Null URL");
/* 173 */     this.url = url;
/*     */   }
/*     */ 
/*     */   public JBossWebMetaData getMetaData()
/*     */   {
/* 181 */     return this.metaData;
/*     */   }
/*     */ 
/*     */   public void setMetaData(JBossWebMetaData metaData)
/*     */   {
/* 189 */     this.metaData = metaData;
/*     */   }
/*     */ 
/*     */   public Object getAppData()
/*     */   {
/* 194 */     return this.data;
/*     */   }
/*     */ 
/*     */   public void setAppData(Object data)
/*     */   {
/* 199 */     this.data = data;
/*     */   }
/*     */ 
/*     */   public String getDomain()
/*     */   {
/* 205 */     return this.domain;
/*     */   }
/*     */ 
/*     */   public void setDomain(String domain) {
/* 209 */     this.domain = domain;
/*     */   }
/*     */ 
/*     */   public boolean getJava2ClassLoadingCompliance()
/*     */   {
/* 219 */     return this.java2ClassLoadingCompliance;
/*     */   }
/*     */ 
/*     */   public void setJava2ClassLoadingCompliance(boolean flag)
/*     */   {
/* 230 */     this.java2ClassLoadingCompliance = flag;
/*     */   }
/*     */ 
/*     */   public boolean getUnpackWars()
/*     */   {
/* 242 */     return this.unpackWars;
/*     */   }
/*     */ 
/*     */   public void setUnpackWars(boolean flag)
/*     */   {
/* 254 */     this.unpackWars = flag;
/*     */   }
/*     */ 
/*     */   public boolean getLenientEjbLink()
/*     */   {
/* 265 */     return this.lenientEjbLink;
/*     */   }
/*     */ 
/*     */   public void setLenientEjbLink(boolean flag)
/*     */   {
/* 275 */     this.lenientEjbLink = flag;
/*     */   }
/*     */ 
/*     */   public String getDefaultSecurityDomain()
/*     */   {
/* 286 */     return this.defaultSecurityDomain;
/*     */   }
/*     */ 
/*     */   public void setDefaultSecurityDomain(String defaultSecurityDomain)
/*     */   {
/* 298 */     this.defaultSecurityDomain = defaultSecurityDomain;
/*     */   }
/*     */ 
/*     */   public Map getVhostToHostNames()
/*     */   {
/* 303 */     return this.vhostToHostNames;
/*     */   }
/*     */ 
/*     */   public void setVhostToHostNames(Map map) {
/* 307 */     this.vhostToHostNames.clear();
/* 308 */     this.vhostToHostNames.putAll(map);
/*     */   }
/*     */ 
/*     */   public Object getDeployerConfig()
/*     */   {
/* 313 */     return this.deployerConfig;
/*     */   }
/*     */ 
/*     */   public void setDeployerConfig(Object config) {
/* 317 */     this.deployerConfig = config;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 322 */     StringBuffer buffer = new StringBuffer("{WebApplication: ");
/* 323 */     buffer.append(getName());
/* 324 */     buffer.append(", URL: ");
/* 325 */     buffer.append(this.url);
/* 326 */     buffer.append(", classLoader: ");
/* 327 */     buffer.append(this.classLoader);
/* 328 */     buffer.append(':');
/* 329 */     buffer.append(this.classLoader.hashCode());
/* 330 */     buffer.append('}');
/* 331 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.web.WebApplication
 * JD-Core Version:    0.6.0
 */