/*     */ package org.jboss.web;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.security.jacc.PolicyConfiguration;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import javax.security.jacc.WebResourcePermission;
/*     */ import javax.security.jacc.WebRoleRefPermission;
/*     */ import javax.security.jacc.WebUserDataPermission;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
/*     */ import org.jboss.metadata.web.jboss.JBossServletMetaData;
/*     */ import org.jboss.metadata.web.jboss.JBossServletsMetaData;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
/*     */ import org.jboss.metadata.web.spec.TransportGuaranteeType;
/*     */ import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
/*     */ import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;
/*     */ 
/*     */ public class WebPermissionMapping
/*     */ {
/*  65 */   static Logger log = Logger.getLogger(WebPermissionMapping.class);
/*     */   private static final int PREFIX = 1;
/*     */   private static final int EXTENSION = 2;
/*     */   private static final int DEFAULT = 3;
/*     */   private static final int EXACT = 4;
/*     */ 
/*     */   public static void createPermissions(JBossWebMetaData metaData, PolicyConfiguration pc)
/*     */     throws PolicyContextException
/*     */   {
/*  87 */     HashMap patternMap = qualifyURLPatterns(metaData);
/*  88 */     log.debug("Qualified url patterns: " + patternMap);
/*     */ 
/*  90 */     List constraints = metaData.getSecurityContraints();
/*     */     Iterator i$;
/*  91 */     if (constraints != null)
/*     */     {
/*  93 */       for (i$ = constraints.iterator(); i$.hasNext(); ) { sc = (SecurityConstraintMetaData)i$.next();
/*     */ 
/*  95 */         WebResourceCollectionsMetaData resources = sc.getResourceCollections();
/*  96 */         transport = sc.getTransportGuarantee();
/*  97 */         if ((sc.isExcluded()) || (sc.isUnchecked()))
/*     */         {
/* 100 */           if (resources != null) {
/* 101 */             for (WebResourceCollectionMetaData wrc : resources)
/*     */             {
/* 103 */               List httpMethods = wrc.getHttpMethods();
/* 104 */               List urlPatterns = wrc.getUrlPatterns();
/* 105 */               int length = urlPatterns != null ? urlPatterns.size() : 0;
/* 106 */               for (int n = 0; n < length; n++)
/*     */               {
/* 108 */                 String url = (String)urlPatterns.get(n);
/* 109 */                 PatternInfo info = (PatternInfo)patternMap.get(url);
/*     */ 
/* 111 */                 if (!sc.isExcluded())
/*     */                   continue;
/* 113 */                 info.addExcludedMethods(httpMethods);
/*     */               }
/*     */ 
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/* 121 */         else if (resources != null)
/* 122 */           for (WebResourceCollectionMetaData wrc : resources)
/*     */           {
/* 124 */             List httpMethods = wrc.getHttpMethods();
/* 125 */             List urlPatterns = wrc.getUrlPatterns();
/* 126 */             int length = urlPatterns != null ? urlPatterns.size() : 0;
/* 127 */             for (int n = 0; n < length; n++)
/*     */             {
/* 129 */               String url = (String)urlPatterns.get(n);
/*     */ 
/* 131 */               PatternInfo info = (PatternInfo)patternMap.get(url);
/* 132 */               HashSet mappedRoles = new HashSet();
/* 133 */               if (sc.getRoleNames() != null)
/* 134 */                 for (String role : sc.getRoleNames())
/*     */                 {
/* 136 */                   if (role.equals("*"))
/*     */                   {
/* 139 */                     for (SecurityRoleMetaData srmd : metaData.getSecurityRoles())
/*     */                     {
/* 141 */                       role = srmd.getRoleName();
/* 142 */                       mappedRoles.add(role);
/*     */                     }
/*     */                   }
/*     */                   else
/*     */                   {
/* 147 */                     mappedRoles.add(role);
/*     */                   }
/*     */                 }
/* 150 */               info.addRoles(mappedRoles, httpMethods);
/*     */ 
/* 152 */               info.addTransport(transport.name(), httpMethods);
/*     */ 
/* 154 */               if (sc.getAuthConstraint() == null)
/* 155 */                 info.isMissingAuthConstraint = true;
/*     */             }
/*     */           }
/*     */       }
/*     */     }
/*     */     SecurityConstraintMetaData sc;
/*     */     TransportGuaranteeType transport;
/* 163 */     for (PatternInfo info : patternMap.values())
/*     */     {
/* 165 */       String qurl = info.getQualifiedPattern();
/* 166 */       if (info.isOverriden == true)
/*     */       {
/* 168 */         log.debug("Dropping overriden pattern: " + info);
/* 169 */         continue;
/*     */       }
/*     */ 
/* 173 */       String[] httpMethods = info.getExcludedMethods();
/* 174 */       if (httpMethods != null)
/*     */       {
/* 177 */         WebResourcePermission wrp = new WebResourcePermission(qurl, httpMethods);
/* 178 */         WebUserDataPermission wudp = new WebUserDataPermission(qurl, httpMethods, null);
/*     */ 
/* 180 */         pc.addToExcludedPolicy(wrp);
/* 181 */         pc.addToExcludedPolicy(wudp);
/*     */ 
/* 184 */         String excludedString = "!" + getCommaSeparatedString(httpMethods);
/* 185 */         WebResourcePermission wrp1 = new WebResourcePermission(info.pattern, excludedString);
/* 186 */         WebUserDataPermission wudp1 = new WebUserDataPermission(info.pattern, excludedString);
/* 187 */         pc.addToUncheckedPolicy(wrp1);
/* 188 */         pc.addToUncheckedPolicy(wudp1);
/*     */       }
/*     */ 
/* 192 */       Iterator roles = info.getRoleMethods();
/* 193 */       while (roles.hasNext())
/*     */       {
/* 195 */         Map.Entry roleMethods = (Map.Entry)roles.next();
/* 196 */         String role = (String)roleMethods.getKey();
/* 197 */         Set methods = (Set)roleMethods.getValue();
/* 198 */         httpMethods = new String[methods.size()];
/* 199 */         methods.toArray(httpMethods);
/* 200 */         WebResourcePermission wrp = new WebResourcePermission(qurl, httpMethods);
/* 201 */         pc.addToRole(role, wrp);
/*     */ 
/* 204 */         WebResourcePermission wrpUnchecked = new WebResourcePermission(info.pattern, "!" + getCommaSeparatedString(httpMethods));
/*     */ 
/* 206 */         pc.addToUncheckedPolicy(wrpUnchecked);
/*     */       }
/*     */ 
/* 210 */       String[] missingHttpMethods = info.getMissingMethods();
/* 211 */       if (missingHttpMethods.length > 0)
/*     */       {
/* 214 */         WebResourcePermission wrp = new WebResourcePermission(qurl, missingHttpMethods);
/* 215 */         pc.addToUncheckedPolicy(wrp);
/*     */       }
/*     */       else {
/* 218 */         pc.addToUncheckedPolicy(new WebResourcePermission(qurl, (String)null));
/*     */       }
/*     */ 
/* 221 */       if (info.isMissingAuthConstraint)
/*     */       {
/* 223 */         pc.addToUncheckedPolicy(new WebResourcePermission(qurl, (String)null));
/*     */       }
/*     */ 
/* 227 */       Iterator transportContraints = info.getTransportMethods();
/* 228 */       while (transportContraints.hasNext())
/*     */       {
/* 230 */         Map.Entry transportMethods = (Map.Entry)transportContraints.next();
/* 231 */         String transport = (String)transportMethods.getKey();
/* 232 */         Set methods = (Set)transportMethods.getValue();
/* 233 */         httpMethods = new String[methods.size()];
/* 234 */         methods.toArray(httpMethods);
/* 235 */         WebUserDataPermission wudp = new WebUserDataPermission(qurl, httpMethods, transport);
/* 236 */         pc.addToUncheckedPolicy(wudp);
/*     */ 
/* 240 */         if ("NONE".equals(transport))
/*     */         {
/* 242 */           WebUserDataPermission wudp1 = new WebUserDataPermission(info.pattern, null);
/* 243 */           pc.addToUncheckedPolicy(wudp1);
/*     */         }
/*     */         else
/*     */         {
/* 248 */           WebUserDataPermission wudpNonNull = new WebUserDataPermission(info.pattern, "!" + getCommaSeparatedString(httpMethods));
/*     */ 
/* 250 */           pc.addToUncheckedPolicy(wudpNonNull);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 260 */     JBossServletsMetaData servlets = metaData.getServlets();
/* 261 */     for (JBossServletMetaData servlet : servlets)
/*     */     {
/* 263 */       servletName = servlet.getServletName();
/* 264 */       SecurityRoleRefsMetaData roleRefs = servlet.getSecurityRoleRefs();
/*     */ 
/* 266 */       Set unreferencedRoles = metaData.getSecurityRoleNames();
/* 267 */       if (roleRefs != null) {
/* 268 */         for (SecurityRoleRefMetaData roleRef : roleRefs)
/*     */         {
/* 270 */           String roleName = roleRef.getRoleLink();
/* 271 */           WebRoleRefPermission wrrp = new WebRoleRefPermission(servletName, roleRef.getName());
/* 272 */           pc.addToRole(roleName, wrrp);
/*     */ 
/* 277 */           wrrp = new WebRoleRefPermission(servletName, roleName);
/* 278 */           pc.addToRole(roleRef.getName(), wrrp);
/*     */ 
/* 280 */           unreferencedRoles.remove(roleName);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 287 */       if (unreferencedRoles != null)
/* 288 */         for (String unrefRole : unreferencedRoles)
/*     */         {
/* 290 */           WebRoleRefPermission unrefP = new WebRoleRefPermission(servletName, unrefRole);
/* 291 */           pc.addToRole(unrefRole, unrefP);
/*     */         }
/*     */     }
/*     */     String servletName;
/* 295 */     Set unreferencedRoles = metaData.getSecurityRoleNames();
/*     */ 
/* 301 */     if (unreferencedRoles != null) {
/* 302 */       for (String unreferencedRole : unreferencedRoles)
/*     */       {
/* 304 */         WebRoleRefPermission wrrep = new WebRoleRefPermission("", unreferencedRole);
/* 305 */         pc.addToRole(unreferencedRole, wrrep);
/*     */       }
/*     */     }
/*     */ 
/* 309 */     Set servletNames = servlets.keySet();
/*     */     Iterator i$;
/* 310 */     if (servletNames != null)
/* 311 */       for (i$ = servletNames.iterator(); i$.hasNext(); ) { servletName = (String)i$.next();
/*     */ 
/* 313 */         if (unreferencedRoles != null)
/* 314 */           for (String role : unreferencedRoles)
/*     */           {
/* 316 */             WebRoleRefPermission wrrp = new WebRoleRefPermission(servletName, role);
/* 317 */             pc.addToRole(role, wrrp);
/*     */           }
/*     */       }
/*     */     String servletName;
/* 324 */     if (unreferencedRoles != null)
/* 325 */       for (String role : unreferencedRoles)
/*     */       {
/* 327 */         WebRoleRefPermission wrrp = new WebRoleRefPermission("", role);
/* 328 */         pc.addToRole(role, wrrp);
/*     */       }
/*     */   }
/*     */ 
/*     */   static String getCommaSeparatedString(String[] str)
/*     */   {
/* 334 */     int len = str.length;
/* 335 */     Arrays.sort(str);
/*     */ 
/* 337 */     StringBuilder buf = new StringBuilder();
/* 338 */     for (int i = 0; i < len; i++)
/*     */     {
/* 340 */       if (i > 0) buf.append(",");
/* 341 */       buf.append(str[i]);
/*     */     }
/* 343 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   static int getPatternType(String urlPattern)
/*     */   {
/* 353 */     int type = 4;
/* 354 */     if (urlPattern.startsWith("*."))
/* 355 */       type = 2;
/* 356 */     else if ((urlPattern.startsWith("/")) && (urlPattern.endsWith("/*")))
/* 357 */       type = 1;
/* 358 */     else if (urlPattern.equals("/"))
/* 359 */       type = 3;
/* 360 */     return type;
/*     */   }
/*     */ 
/*     */   static HashMap<String, PatternInfo> qualifyURLPatterns(JBossWebMetaData metaData)
/*     */   {
/* 402 */     ArrayList prefixList = new ArrayList();
/* 403 */     ArrayList extensionList = new ArrayList();
/* 404 */     ArrayList exactList = new ArrayList();
/* 405 */     HashMap patternMap = new HashMap();
/* 406 */     PatternInfo defaultInfo = null;
/*     */ 
/* 408 */     List constraints = metaData.getSecurityContraints();
/* 409 */     if (constraints != null)
/*     */     {
/* 411 */       for (SecurityConstraintMetaData sc : constraints)
/*     */       {
/* 413 */         WebResourceCollectionsMetaData resources = sc.getResourceCollections();
/* 414 */         for (WebResourceCollectionMetaData wrc : resources)
/*     */         {
/* 416 */           List urlPatterns = wrc.getUrlPatterns();
/* 417 */           int length = urlPatterns != null ? urlPatterns.size() : 0;
/* 418 */           for (int n = 0; n < length; n++)
/*     */           {
/* 420 */             String url = (String)urlPatterns.get(n);
/* 421 */             int type = getPatternType(url);
/* 422 */             PatternInfo info = (PatternInfo)patternMap.get(url);
/* 423 */             if (info != null)
/*     */               continue;
/* 425 */             info = new PatternInfo(url, type);
/* 426 */             patternMap.put(url, info);
/* 427 */             switch (type)
/*     */             {
/*     */             case 1:
/* 430 */               prefixList.add(info);
/* 431 */               break;
/*     */             case 2:
/* 433 */               extensionList.add(info);
/* 434 */               break;
/*     */             case 4:
/* 436 */               exactList.add(info);
/* 437 */               break;
/*     */             case 3:
/* 439 */               defaultInfo = info;
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 449 */     for (int i = 0; i < prefixList.size(); i++)
/*     */     {
/* 451 */       PatternInfo info = (PatternInfo)prefixList.get(i);
/*     */ 
/* 453 */       for (int j = 0; j < prefixList.size(); j++)
/*     */       {
/* 455 */         if (i == j)
/*     */           continue;
/* 457 */         PatternInfo other = (PatternInfo)prefixList.get(j);
/* 458 */         if (info.matches(other)) {
/* 459 */           info.addQualifier(other);
/*     */         }
/*     */       }
/* 462 */       for (int j = 0; j < exactList.size(); j++)
/*     */       {
/* 464 */         PatternInfo other = (PatternInfo)exactList.get(j);
/* 465 */         if (info.matches(other)) {
/* 466 */           info.addQualifier(other);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 471 */     for (int i = 0; i < extensionList.size(); i++)
/*     */     {
/* 473 */       PatternInfo info = (PatternInfo)extensionList.get(i);
/*     */ 
/* 475 */       for (int j = 0; j < prefixList.size(); j++)
/*     */       {
/* 477 */         PatternInfo other = (PatternInfo)prefixList.get(j);
/*     */ 
/* 480 */         info.addQualifier(other);
/*     */       }
/*     */ 
/* 484 */       for (int j = 0; j < exactList.size(); j++)
/*     */       {
/* 486 */         PatternInfo other = (PatternInfo)exactList.get(j);
/* 487 */         if (info.isExtensionFor(other)) {
/* 488 */           info.addQualifier(other);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 493 */     if (defaultInfo == null)
/*     */     {
/* 495 */       defaultInfo = new PatternInfo("/", 3);
/* 496 */       patternMap.put("/", defaultInfo);
/*     */     }
/* 498 */     Iterator iter = patternMap.values().iterator();
/* 499 */     while (iter.hasNext())
/*     */     {
/* 501 */       PatternInfo info = (PatternInfo)iter.next();
/* 502 */       if (info == defaultInfo)
/*     */         continue;
/* 504 */       defaultInfo.addQualifier(info);
/*     */     }
/*     */ 
/* 507 */     return patternMap;
/*     */   }
/*     */ 
/*     */   static class PatternInfo
/*     */   {
/* 516 */     static final HashMap<String, Set<String>> ALL_TRANSPORTS = new HashMap();
/*     */     String pattern;
/*     */     String qpattern;
/* 527 */     ArrayList<PatternInfo> qualifiers = new ArrayList();
/*     */     int type;
/*     */     HashSet<String> excludedMethods;
/*     */     HashMap<String, Set<String>> roles;
/*     */     HashMap<String, Set<String>> transports;
/* 537 */     HashSet<String> allMethods = new HashSet();
/*     */     boolean isOverriden;
/*     */     boolean isMissingAuthConstraint;
/*     */ 
/*     */     PatternInfo(String pattern, int type)
/*     */     {
/* 554 */       this.pattern = pattern;
/* 555 */       this.type = type;
/*     */     }
/*     */ 
/*     */     void addExcludedMethods(List<String> httpMethods)
/*     */     {
/* 564 */       Collection methods = httpMethods;
/* 565 */       if (methods.size() == 0)
/* 566 */         methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
/* 567 */       if (this.excludedMethods == null)
/* 568 */         this.excludedMethods = new HashSet();
/* 569 */       this.excludedMethods.addAll(methods);
/* 570 */       this.allMethods.addAll(methods);
/*     */     }
/*     */ 
/*     */     public String[] getExcludedMethods()
/*     */     {
/* 579 */       String[] httpMethods = null;
/* 580 */       if (this.excludedMethods != null)
/*     */       {
/* 582 */         httpMethods = new String[this.excludedMethods.size()];
/* 583 */         this.excludedMethods.toArray(httpMethods);
/*     */       }
/* 585 */       return httpMethods;
/*     */     }
/*     */ 
/*     */     public void addRoles(HashSet<String> mappedRoles, List<String> httpMethods)
/*     */     {
/* 595 */       Collection methods = httpMethods;
/* 596 */       if (methods.size() == 0)
/* 597 */         methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
/* 598 */       this.allMethods.addAll(methods);
/* 599 */       if (this.roles == null) {
/* 600 */         this.roles = new HashMap();
/*     */       }
/* 602 */       for (String role : mappedRoles)
/*     */       {
/* 604 */         Set roleMethods = (Set)this.roles.get(role);
/* 605 */         if (roleMethods == null)
/*     */         {
/* 607 */           roleMethods = new HashSet();
/* 608 */           this.roles.put(role, roleMethods);
/*     */         }
/* 610 */         roleMethods.addAll(methods);
/*     */       }
/*     */     }
/*     */ 
/*     */     public Iterator<Map.Entry<String, Set<String>>> getRoleMethods()
/*     */     {
/* 620 */       HashMap tmp = this.roles;
/* 621 */       if (tmp == null)
/* 622 */         tmp = new HashMap(0);
/* 623 */       Iterator iter = tmp.entrySet().iterator();
/* 624 */       return iter;
/*     */     }
/*     */ 
/*     */     void addTransport(String transport, List<String> httpMethods)
/*     */     {
/* 634 */       Collection methods = httpMethods;
/* 635 */       if (methods.size() == 0)
/* 636 */         methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
/* 637 */       if (this.transports == null) {
/* 638 */         this.transports = new HashMap();
/*     */       }
/* 640 */       Set transportMethods = (Set)this.transports.get(transport);
/* 641 */       if (transportMethods == null)
/*     */       {
/* 643 */         transportMethods = new HashSet();
/* 644 */         this.transports.put(transport, transportMethods);
/*     */       }
/* 646 */       transportMethods.addAll(methods);
/*     */     }
/*     */ 
/*     */     public Iterator<Map.Entry<String, Set<String>>> getTransportMethods()
/*     */     {
/* 655 */       HashMap tmp = this.transports;
/* 656 */       if (tmp == null)
/* 657 */         tmp = ALL_TRANSPORTS;
/* 658 */       Iterator iter = tmp.entrySet().iterator();
/* 659 */       return iter;
/*     */     }
/*     */ 
/*     */     public String[] getMissingMethods()
/*     */     {
/* 670 */       String[] httpMethods = new String[0];
/* 671 */       if (this.allMethods.size() == 0)
/*     */       {
/* 674 */         httpMethods = WebResourceCollectionMetaData.ALL_HTTP_METHOD_NAMES;
/*     */       }
/*     */       else
/*     */       {
/* 678 */         httpMethods = WebResourceCollectionMetaData.getMissingHttpMethods(this.allMethods);
/*     */       }
/* 680 */       return httpMethods;
/*     */     }
/*     */ 
/*     */     void addQualifier(PatternInfo info)
/*     */     {
/* 692 */       if (!this.qualifiers.contains(info))
/*     */       {
/* 695 */         if ((info.type == 1) && (info.matches(this)))
/* 696 */           this.isOverriden = true;
/* 697 */         this.qualifiers.add(info);
/*     */       }
/*     */     }
/*     */ 
/*     */     public String getQualifiedPattern()
/*     */     {
/* 708 */       if (this.qpattern == null)
/*     */       {
/* 710 */         StringBuffer tmp = new StringBuffer(this.pattern);
/* 711 */         for (int n = 0; n < this.qualifiers.size(); n++)
/*     */         {
/* 713 */           tmp.append(':');
/* 714 */           PatternInfo info = (PatternInfo)this.qualifiers.get(n);
/* 715 */           tmp.append(info.pattern);
/*     */         }
/* 717 */         this.qpattern = tmp.toString();
/*     */       }
/* 719 */       return this.qpattern;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 724 */       return this.pattern.hashCode();
/*     */     }
/*     */ 
/*     */     public boolean equals(Object obj)
/*     */     {
/* 729 */       PatternInfo pi = (PatternInfo)obj;
/* 730 */       return this.pattern.equals(pi.pattern);
/*     */     }
/*     */ 
/*     */     public boolean matches(PatternInfo other)
/*     */     {
/* 741 */       int matchLength = this.pattern.length() - 2;
/* 742 */       boolean matches = this.pattern.regionMatches(0, other.pattern, 0, matchLength);
/* 743 */       return matches;
/*     */     }
/*     */ 
/*     */     public boolean isExtensionFor(PatternInfo other)
/*     */     {
/* 754 */       int offset = other.pattern.lastIndexOf('.');
/* 755 */       int length = this.pattern.length() - 1;
/* 756 */       boolean isExtensionFor = false;
/* 757 */       if (offset > 0)
/*     */       {
/* 759 */         isExtensionFor = this.pattern.regionMatches(1, other.pattern, offset, length);
/*     */       }
/* 761 */       return isExtensionFor;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 766 */       StringBuffer tmp = new StringBuffer("PatternInfo[");
/* 767 */       tmp.append("pattern=");
/* 768 */       tmp.append(this.pattern);
/* 769 */       tmp.append(",type=");
/* 770 */       tmp.append(this.type);
/* 771 */       tmp.append(",isOverriden=");
/* 772 */       tmp.append(this.isOverriden);
/* 773 */       tmp.append(",qualifiers=");
/* 774 */       tmp.append(this.qualifiers);
/* 775 */       tmp.append("]");
/* 776 */       return tmp.toString();
/*     */     }
/*     */ 
/*     */     static
/*     */     {
/* 519 */       ALL_TRANSPORTS.put("NONE", WebResourceCollectionMetaData.ALL_HTTP_METHODS);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.web.WebPermissionMapping
 * JD-Core Version:    0.6.0
 */