/*     */ package org.jboss.web.deployers;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.InputStream;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AttachmentLocator;
/*     */ import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
/*     */ import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ear.jboss.JBossAppMetaData;
/*     */ import org.jboss.metadata.ear.spec.ModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.WebModuleMetaData;
/*     */ import org.jboss.metadata.web.jboss.ClassLoadingMetaData;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ import org.jboss.system.metadata.ServiceConstructorMetaData;
/*     */ import org.jboss.system.metadata.ServiceDependencyMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.system.server.ServerConfigLocator;
/*     */ import org.jboss.util.file.Files;
/*     */ import org.jboss.util.file.JarUtils;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.web.WebApplication;
/*     */ 
/*     */ public abstract class AbstractWarDeployer extends AbstractSimpleVFSRealDeployer<JBossWebMetaData>
/*     */ {
/*     */   public static final String DEPLOYER = "org.jboss.web.AbstractWebContainer.deployer";
/*     */   public static final String WEB_APP = "org.jboss.web.AbstractWebContainer.webApp";
/*     */   public static final String WEB_MODULE = "org.jboss.web.AbstractWebContainer.webModule";
/*     */   public static final String ERROR = "org.jboss.web.AbstractWebContainer.error";
/*  91 */   protected HashMap deploymentMap = new HashMap();
/*     */ 
/*  93 */   protected boolean java2ClassLoadingCompliance = false;
/*     */ 
/*  95 */   protected boolean unpackWars = true;
/*     */ 
/*  98 */   protected boolean acceptNonWarDirs = false;
/*     */ 
/* 101 */   protected boolean lenientEjbLink = false;
/*     */ 
/* 104 */   protected String defaultSecurityDomain = "java:/jaas/other";
/*     */ 
/* 106 */   private String subjectAttributeName = null;
/*     */   private MBeanServer server;
/*     */   private MainDeployerStructure mainDeployer;
/*     */ 
/*     */   public AbstractWarDeployer()
/*     */   {
/* 116 */     super(JBossWebMetaData.class);
/* 117 */     setOutput(ServiceMetaData.class);
/*     */   }
/*     */ 
/*     */   public boolean getJava2ClassLoadingCompliance()
/*     */   {
/* 127 */     return this.java2ClassLoadingCompliance;
/*     */   }
/*     */ 
/*     */   public void setJava2ClassLoadingCompliance(boolean flag)
/*     */   {
/* 137 */     this.java2ClassLoadingCompliance = flag;
/*     */   }
/*     */ 
/*     */   public boolean getUnpackWars()
/*     */   {
/* 149 */     return this.unpackWars;
/*     */   }
/*     */ 
/*     */   public void setUnpackWars(boolean flag)
/*     */   {
/* 161 */     this.unpackWars = flag;
/*     */   }
/*     */ 
/*     */   public boolean getAcceptNonWarDirs()
/*     */   {
/* 172 */     return this.acceptNonWarDirs;
/*     */   }
/*     */ 
/*     */   public void setAcceptNonWarDirs(boolean flag)
/*     */   {
/* 182 */     this.acceptNonWarDirs = flag;
/*     */   }
/*     */ 
/*     */   public boolean getLenientEjbLink()
/*     */   {
/* 194 */     return this.lenientEjbLink;
/*     */   }
/*     */ 
/*     */   public void setLenientEjbLink(boolean flag)
/*     */   {
/* 205 */     this.lenientEjbLink = flag;
/*     */   }
/*     */ 
/*     */   public String getDefaultSecurityDomain()
/*     */   {
/* 216 */     return this.defaultSecurityDomain;
/*     */   }
/*     */ 
/*     */   public void setDefaultSecurityDomain(String defaultSecurityDomain)
/*     */   {
/* 227 */     this.defaultSecurityDomain = defaultSecurityDomain;
/*     */   }
/*     */ 
/*     */   public String getSubjectAttributeName()
/*     */   {
/* 235 */     return this.subjectAttributeName;
/*     */   }
/*     */ 
/*     */   public void setSubjectAttributeName(String subjectAttributeName)
/*     */   {
/* 242 */     this.subjectAttributeName = subjectAttributeName;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 248 */     this.server = MBeanServerLocator.locateJBoss();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public abstract AbstractWarDeployment getDeployment(VFSDeploymentUnit paramVFSDeploymentUnit, JBossWebMetaData paramJBossWebMetaData)
/*     */     throws Exception;
/*     */ 
/*     */   public void deploy(VFSDeploymentUnit unit, JBossWebMetaData metaData)
/*     */     throws DeploymentException
/*     */   {
/* 287 */     this.log.debug("Begin deploy, " + metaData);
/*     */ 
/* 290 */     JBossAppMetaData earMetaData = (JBossAppMetaData)AttachmentLocator.search(unit, JBossAppMetaData.class);
/* 291 */     if (earMetaData != null)
/*     */     {
/* 293 */       String path = unit.getRelativePath();
/* 294 */       ModuleMetaData webModule = earMetaData.getModule(path);
/* 295 */       if (webModule != null)
/*     */       {
/* 298 */         String contextRoot = metaData.getContextRoot();
/* 299 */         if (contextRoot == null)
/*     */         {
/* 301 */           WebModuleMetaData wmodule = (WebModuleMetaData)webModule.getValue();
/* 302 */           contextRoot = wmodule.getContextRoot();
/* 303 */           metaData.setContextRoot(contextRoot);
/*     */         }
/*     */ 
/* 307 */         metaData.setAlternativeDD(webModule.getAlternativeDD());
/*     */       }
/*     */ 
/* 311 */       if ((metaData.getSecurityDomain() == null) && (earMetaData.getSecurityDomain() != null)) {
/* 312 */         metaData.setSecurityDomain(earMetaData.getSecurityDomain());
/*     */       }
/* 314 */       metaData.mergeSecurityRoles(earMetaData.getSecurityRoles());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 324 */       String warName = unit.getName();
/*     */ 
/* 329 */       if ((warName.startsWith("jboss:")) && (warName.contains("id="))) {
/* 330 */         return;
/*     */       }
/* 332 */       URL expWarUrl = unit.getRoot().toURL();
/* 333 */       if ((!warName.endsWith("/")) || (warName.endsWith("!/") == true))
/*     */       {
/* 337 */         if (warName.startsWith("jar:"))
/*     */         {
/* 339 */           if (warName.endsWith("!/"))
/* 340 */             warName = warName.substring(4, warName.length() - 2);
/*     */           else
/* 342 */             warName = warName.substring(4, warName.length());
/*     */         }
/* 344 */         URL warURL = new URL(warName);
/* 345 */         ServerConfig config = ServerConfigLocator.locate();
/* 346 */         String prefix = warURL.getFile();
/* 347 */         int lastSlash = prefix.lastIndexOf('/');
/* 348 */         if (lastSlash > 0)
/* 349 */           prefix = prefix.substring(lastSlash + 1);
/* 350 */         int dotWar = prefix.lastIndexOf(".war");
/* 351 */         if (dotWar > 0) {
/* 352 */           prefix = prefix.substring(0, dotWar);
/*     */         }
/* 354 */         File expWarFile = File.createTempFile(prefix, "-exp.war", config.getServerTempDeployDir());
/* 355 */         expWarFile.delete();
/* 356 */         if (!expWarFile.mkdir())
/* 357 */           throw new DeploymentException("Was unable to mkdir: " + expWarFile);
/* 358 */         this.log.debug("Unpacking war to: " + expWarFile);
/* 359 */         VirtualFile root = unit.getRoot();
/* 360 */         InputStream is = root.openStream();
/* 361 */         JarUtils.unjar(is, expWarFile);
/* 362 */         is.close();
/* 363 */         expWarUrl = expWarFile.toURL();
/*     */ 
/* 366 */         VirtualFile warVF = unit.getRoot();
/* 367 */         String warPathName = warVF.getPathName();
/* 368 */         if (!warPathName.endsWith("/"))
/* 369 */           warPathName = warPathName + "/";
/* 370 */         List classpathVFs = unit.getClassPath();
/* 371 */         if (classpathVFs != null)
/*     */         {
/* 373 */           ArrayList classpath = new ArrayList();
/* 374 */           for (VirtualFile vf : classpathVFs)
/*     */           {
/*     */             try
/*     */             {
/* 378 */               String path = vf.getPathName();
/* 379 */               path = path.substring(warPathName.length());
/* 380 */               URL pathURL = new URL(expWarUrl, path);
/* 381 */               classpath.add(pathURL);
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 385 */               this.log.debug("Ignoring path element: " + vf, e);
/*     */             }
/*     */           }
/* 388 */           unit.addAttachment("org.jboss.web.expandedWarClasspath", classpath);
/*     */         }
/*     */ 
/* 392 */         unit.addAttachment("org.jboss.web.expandedWarURL", expWarUrl, URL.class);
/*     */       }
/*     */ 
/* 396 */       String altDDPath = metaData.getAlternativeDD();
/* 397 */       if (altDDPath != null)
/*     */       {
/* 400 */         VirtualFile altDD = unit.getMetaDataFile(altDDPath);
/* 401 */         if (altDD == null)
/*     */         {
/* 404 */           File file = new File(altDDPath);
/* 405 */           if ((!file.exists()) || (!file.isAbsolute()))
/*     */           {
/* 408 */             VFSDeploymentUnit topUnit = unit.getTopLevel();
/* 409 */             if (topUnit == unit)
/* 410 */               throw new DeploymentException("Unable to resolve " + altDDPath + " as WEB-INF path");
/* 411 */             altDD = topUnit.getFile(altDDPath);
/* 412 */             if (altDD == null)
/* 413 */               throw new DeploymentException("Unable to resolve " + altDDPath + " as a deployment path");
/* 414 */             File webInf = new File(expWarUrl.toURI());
/* 415 */             File altDDFile = new File(webInf, "WEB-INF/" + altDD.getName());
/* 416 */             this.log.debug("Copying the altDD to: " + altDDFile);
/* 417 */             Files.copy(altDD.toURL(), altDDFile);
/* 418 */             metaData.setAlternativeDD(altDDFile.getAbsolutePath());
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 423 */       ClassLoadingMetaData classLoading = metaData.getClassLoading();
/* 424 */       if (classLoading == null) {
/* 425 */         classLoading = new ClassLoadingMetaData();
/*     */       }
/* 427 */       if (!classLoading.wasJava2ClassLoadingComplianceSet())
/* 428 */         classLoading.setJava2ClassLoadingCompliance(this.java2ClassLoadingCompliance);
/* 429 */       metaData.setClassLoading(classLoading);
/*     */ 
/* 432 */       String webContext = metaData.getContextRoot();
/* 433 */       webContext = buildWebContext(webContext, warName, metaData, unit);
/* 434 */       metaData.setContextRoot(webContext);
/*     */ 
/* 436 */       AbstractWarDeployment deployment = getDeployment(unit, metaData);
/* 437 */       deployment.setMainDeployer(this.mainDeployer);
/* 438 */       deployWebModule(unit, metaData, deployment);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 442 */       throw new DeploymentException("Failed to create web module", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void undeploy(VFSDeploymentUnit unit, JBossWebMetaData metaData)
/*     */   {
/*     */     try
/*     */     {
/* 455 */       URL warURL = (URL)unit.getAttachment("org.jboss.web.expandedWarURL", URL.class);
/* 456 */       if (warURL != null)
/*     */       {
/* 458 */         File war = new File(warURL.toURI());
/* 459 */         Files.delete(war);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 464 */       this.log.debug("Failed to remove expanded war", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addDeployedApp(String warURL, WebApplication webApp)
/*     */   {
/* 475 */     this.deploymentMap.put(warURL, webApp);
/*     */   }
/*     */ 
/*     */   public WebApplication getDeployedApp(String warUrl)
/*     */   {
/* 484 */     WebApplication appInfo = (WebApplication)this.deploymentMap.get(warUrl);
/* 485 */     return appInfo;
/*     */   }
/*     */ 
/*     */   public WebApplication removeDeployedApp(String warURL) {
/* 489 */     WebApplication appInfo = (WebApplication)this.deploymentMap.remove(warURL);
/* 490 */     return appInfo;
/*     */   }
/*     */ 
/*     */   public Iterator getDeployedApplications()
/*     */   {
/* 499 */     return this.deploymentMap.values().iterator();
/*     */   }
/*     */ 
/*     */   public static URL[] getClassLoaderURLs(ClassLoader cl)
/*     */   {
/* 508 */     URL[] urls = new URL[0];
/*     */     try
/*     */     {
/* 511 */       Class returnType = urls.getClass();
/* 512 */       Class[] parameterTypes = new Class[0];
/* 513 */       Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
/* 514 */       if (returnType.isAssignableFrom(getURLs.getReturnType()))
/*     */       {
/* 516 */         Object[] args = new Object[0];
/* 517 */         urls = (URL[])(URL[])getURLs.invoke(cl, args);
/*     */       }
/* 519 */       if ((urls == null) || (urls.length == 0))
/*     */       {
/* 521 */         getURLs = cl.getClass().getMethod("getAllURLs", parameterTypes);
/* 522 */         if (returnType.isAssignableFrom(getURLs.getReturnType()))
/*     */         {
/* 524 */           Object[] args = new Object[0];
/* 525 */           urls = (URL[])(URL[])getURLs.invoke(cl, args);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/* 532 */     return urls;
/*     */   }
/*     */ 
/*     */   protected String buildWebContext(String ctxPath, String warName, JBossWebMetaData metaData, VFSDeploymentUnit unit)
/*     */   {
/* 548 */     String webContext = ctxPath;
/*     */ 
/* 551 */     if (webContext == null)
/*     */     {
/* 554 */       webContext = warName;
/* 555 */       webContext = webContext.replace('\\', '/');
/* 556 */       if (webContext.endsWith("/"))
/* 557 */         webContext = webContext.substring(0, webContext.length() - 1);
/* 558 */       int prefix = webContext.lastIndexOf('/');
/* 559 */       if (prefix > 0)
/* 560 */         webContext = webContext.substring(prefix + 1);
/* 561 */       int suffix = webContext.lastIndexOf(".war");
/* 562 */       if (suffix > 0) {
/* 563 */         webContext = webContext.substring(0, suffix);
/*     */       }
/* 565 */       int index = 0;
/* 566 */       for (; index < webContext.length(); index++)
/*     */       {
/* 568 */         char c = webContext.charAt(index);
/* 569 */         if ((!Character.isDigit(c)) && (c != '.'))
/*     */           break;
/*     */       }
/* 572 */       webContext = webContext.substring(index);
/*     */     }
/*     */ 
/* 576 */     if ((webContext.length() > 0) && (webContext.charAt(0) != '/')) {
/* 577 */       webContext = "/" + webContext;
/*     */     }
/* 579 */     else if (webContext.equals("/"))
/* 580 */       webContext = "";
/* 581 */     return webContext;
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   protected MBeanServer getServer()
/*     */   {
/* 591 */     return this.server;
/*     */   }
/*     */ 
/*     */   public MainDeployerStructure getMainDeployer()
/*     */   {
/* 596 */     return this.mainDeployer;
/*     */   }
/*     */ 
/*     */   public void setMainDeployer(MainDeployerStructure mainDeployer)
/*     */   {
/* 601 */     this.mainDeployer = mainDeployer;
/*     */   }
/*     */ 
/*     */   protected String getObjectName(JBossWebMetaData metaData)
/*     */   {
/* 614 */     String ctxPath = metaData.getContextRoot();
/*     */ 
/* 616 */     if ((ctxPath == null) || (ctxPath.length() == 0))
/* 617 */       ctxPath = "/";
/* 618 */     String objectName = "jboss.web.deployment:war=" + ctxPath;
/* 619 */     return objectName;
/*     */   }
/*     */ 
/*     */   protected void deployWebModule(VFSDeploymentUnit unit, JBossWebMetaData metaData, AbstractWarDeployment deployment)
/*     */     throws Exception
/*     */   {
/* 635 */     this.log.debug("deployWebModule");
/*     */     try
/*     */     {
/* 638 */       ServiceMetaData webModule = new ServiceMetaData();
/* 639 */       String name = getObjectName(metaData);
/* 640 */       ObjectName objectName = new ObjectName(name);
/* 641 */       webModule.setObjectName(objectName);
/* 642 */       webModule.setCode(WebModule.class.getName());
/*     */ 
/* 644 */       ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
/* 645 */       constructor.setSignature(new String[] { VFSDeploymentUnit.class.getName(), AbstractWarDeployer.class.getName(), AbstractWarDeployment.class.getName() });
/*     */ 
/* 647 */       constructor.setParameters(new Object[] { unit, this, deployment });
/* 648 */       webModule.setConstructor(constructor);
/*     */ 
/* 651 */       Collection depends = metaData.getDepends();
/* 652 */       List dependencies = new ArrayList();
/* 653 */       if (depends != null)
/*     */       {
/* 655 */         for (String iDependOn : depends)
/*     */         {
/* 657 */           ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
/* 658 */           sdmd.setIDependOn(iDependOn);
/*     */         }
/*     */       }
/* 661 */       webModule.setDependencies(dependencies);
/*     */ 
/* 665 */       unit.addAttachment(ServiceMetaData.class, webModule);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 669 */       throw DeploymentException.rethrowAsDeploymentException("Error creating rar deployment " + unit.getName(), e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.web.deployers.AbstractWarDeployer
 * JD-Core Version:    0.6.0
 */