/*     */ package org.jboss.ws.core;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.ws.handler.MessageContext.Scope;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.soap.attachment.SwapableMemoryDataSource;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ 
/*     */ public abstract class CommonMessageContext
/*     */   implements Map<String, Object>
/*     */ {
/*  53 */   private static Logger log = Logger.getLogger(CommonMessageContext.class);
/*     */ 
/*  57 */   public static String ALLOW_EXPAND_TO_DOM = "org.jboss.ws.allow.expand.dom";
/*     */ 
/*  59 */   public static String REMOTING_METADATA = "org.jboss.ws.remoting.metadata";
/*     */   private SerializationContext serContext;
/*     */   private EndpointMetaData epMetaData;
/*     */   private OperationMetaData opMetaData;
/*     */   private MessageAbstraction message;
/*  70 */   protected Map<String, ScopedProperty> scopedProps = new HashMap();
/*     */ 
/*  72 */   protected MessageContext.Scope currentScope = MessageContext.Scope.APPLICATION;
/*     */   private boolean isModified;
/*     */ 
/*     */   public CommonMessageContext()
/*     */   {
/*     */   }
/*     */ 
/*     */   public CommonMessageContext(CommonMessageContext msgContext)
/*     */   {
/*  83 */     this.epMetaData = msgContext.epMetaData;
/*  84 */     this.opMetaData = msgContext.opMetaData;
/*  85 */     this.message = msgContext.message;
/*  86 */     this.serContext = msgContext.serContext;
/*  87 */     this.scopedProps = new HashMap(msgContext.scopedProps);
/*  88 */     this.currentScope = msgContext.currentScope;
/*     */   }
/*     */ 
/*     */   public MessageContext.Scope getCurrentScope()
/*     */   {
/*  93 */     return this.currentScope;
/*     */   }
/*     */ 
/*     */   public void setCurrentScope(MessageContext.Scope currentScope)
/*     */   {
/*  98 */     this.currentScope = currentScope;
/*     */   }
/*     */ 
/*     */   public EndpointMetaData getEndpointMetaData()
/*     */   {
/* 103 */     if ((this.epMetaData == null) && (this.opMetaData != null)) {
/* 104 */       this.epMetaData = this.opMetaData.getEndpointMetaData();
/*     */     }
/* 106 */     return this.epMetaData;
/*     */   }
/*     */ 
/*     */   public void setEndpointMetaData(EndpointMetaData epMetaData)
/*     */   {
/* 111 */     this.epMetaData = epMetaData;
/*     */   }
/*     */ 
/*     */   public OperationMetaData getOperationMetaData()
/*     */   {
/* 116 */     return this.opMetaData;
/*     */   }
/*     */ 
/*     */   public void setOperationMetaData(OperationMetaData opMetaData)
/*     */   {
/* 121 */     this.opMetaData = opMetaData;
/*     */   }
/*     */ 
/*     */   public SOAPMessage getSOAPMessage()
/*     */   {
/* 126 */     if ((this.message != null) && (!(this.message instanceof SOAPMessage)))
/* 127 */       throw new UnsupportedOperationException("No SOAPMessage avilable. Current message context carries " + this.message.getClass());
/* 128 */     return (SOAPMessage)this.message;
/*     */   }
/*     */ 
/*     */   public void setSOAPMessage(SOAPMessage soapMessage)
/*     */   {
/* 133 */     this.message = ((MessageAbstraction)soapMessage);
/* 134 */     setModified(true);
/*     */   }
/*     */ 
/*     */   public MessageAbstraction getMessageAbstraction()
/*     */   {
/* 139 */     return this.message;
/*     */   }
/*     */ 
/*     */   public void setMessageAbstraction(MessageAbstraction message)
/*     */   {
/* 144 */     this.message = message;
/*     */   }
/*     */ 
/*     */   public SerializationContext getSerializationContext()
/*     */   {
/* 149 */     if (this.serContext == null)
/*     */     {
/* 151 */       this.serContext = createSerializationContext();
/*     */     }
/* 153 */     return this.serContext;
/*     */   }
/*     */ 
/*     */   public abstract SerializationContext createSerializationContext();
/*     */ 
/*     */   public void setSerializationContext(SerializationContext serContext) {
/* 160 */     this.serContext = serContext;
/*     */   }
/*     */ 
/*     */   public NamespaceRegistry getNamespaceRegistry()
/*     */   {
/* 166 */     return getSerializationContext().getNamespaceRegistry();
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 173 */     return this.scopedProps.size();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 178 */     return this.scopedProps.isEmpty();
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/* 183 */     ScopedProperty prop = (ScopedProperty)this.scopedProps.get(key);
/* 184 */     return isValidInScope(prop);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object value)
/*     */   {
/* 189 */     boolean valueFound = false;
/* 190 */     for (ScopedProperty prop : this.scopedProps.values())
/*     */     {
/* 192 */       if ((prop.getValue().equals(value)) && (isValidInScope(prop)))
/*     */       {
/* 194 */         valueFound = true;
/* 195 */         break;
/*     */       }
/*     */     }
/* 198 */     return valueFound;
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 203 */     Object value = null;
/*     */ 
/* 205 */     ScopedProperty scopedProp = (ScopedProperty)this.scopedProps.get(key);
/* 206 */     if (log.isTraceEnabled()) {
/* 207 */       log.trace("get(" + key + "): " + scopedProp);
/*     */     }
/* 209 */     if (isValidInScope(scopedProp)) {
/* 210 */       value = scopedProp.getValue();
/*     */     }
/* 212 */     return value;
/*     */   }
/*     */ 
/*     */   public Object put(String key, Object value)
/*     */   {
/* 217 */     ScopedProperty prevProp = (ScopedProperty)this.scopedProps.get(key);
/* 218 */     if ((prevProp != null) && (!isValidInScope(prevProp))) {
/* 219 */       throw new IllegalArgumentException("Cannot set value for HANDLER scoped property: " + key);
/*     */     }
/* 221 */     ScopedProperty newProp = new ScopedProperty(key, value, this.currentScope);
/* 222 */     if (log.isTraceEnabled()) {
/* 223 */       log.trace("put: " + newProp);
/*     */     }
/* 225 */     this.scopedProps.put(key, newProp);
/* 226 */     return prevProp != null ? prevProp.getValue() : null;
/*     */   }
/*     */ 
/*     */   public Object remove(Object key)
/*     */   {
/* 231 */     ScopedProperty prevProp = (ScopedProperty)this.scopedProps.get(key);
/* 232 */     if ((prevProp != null) && (!isValidInScope(prevProp))) {
/* 233 */       throw new IllegalArgumentException("Cannot set remove for HANDLER scoped property: " + key);
/*     */     }
/* 235 */     return this.scopedProps.remove(key);
/*     */   }
/*     */ 
/*     */   public void putAll(Map<? extends String, ? extends Object> srcMap)
/*     */   {
/* 240 */     for (String key : srcMap.keySet())
/*     */     {
/*     */       try
/*     */       {
/* 244 */         Object value = srcMap.get(key);
/* 245 */         put(key, value);
/*     */       }
/*     */       catch (IllegalArgumentException ex)
/*     */       {
/* 249 */         log.debug("Ignore: " + ex.getMessage());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 256 */     this.scopedProps.clear();
/*     */   }
/*     */ 
/*     */   public boolean isModified()
/*     */   {
/* 262 */     if ((XOPContext.isXOPEncodedRequest()) && (!XOPContext.isXOPMessage()))
/*     */     {
/* 264 */       log.debug("Disregard changes from XOP/Handler interactions");
/* 265 */       return false;
/*     */     }
/* 267 */     return this.isModified;
/*     */   }
/*     */ 
/*     */   public void setModified(boolean modified)
/*     */   {
/* 283 */     this.isModified = modified;
/*     */   }
/*     */ 
/*     */   public Set<String> keySet()
/*     */   {
/* 288 */     Set keys = new HashSet(this.scopedProps.size());
/* 289 */     for (ScopedProperty prop : this.scopedProps.values())
/*     */     {
/* 291 */       if (isValidInScope(prop))
/* 292 */         keys.add(prop.getName());
/*     */     }
/* 294 */     return keys;
/*     */   }
/*     */ 
/*     */   public Collection<Object> values()
/*     */   {
/* 299 */     Collection values = new HashSet(this.scopedProps.size());
/* 300 */     for (ScopedProperty prop : this.scopedProps.values())
/*     */     {
/* 302 */       if (isValidInScope(prop))
/* 303 */         values.add(prop.getValue());
/*     */     }
/* 305 */     return values;
/*     */   }
/*     */ 
/*     */   public Set<Map.Entry<String, Object>> entrySet()
/*     */   {
/* 310 */     Set entries = new HashSet();
/* 311 */     for (ScopedProperty prop : this.scopedProps.values())
/*     */     {
/* 313 */       if (isValidInScope(prop))
/*     */       {
/* 315 */         String name = prop.getName();
/* 316 */         Object value = prop.getValue();
/* 317 */         Map.Entry entry = new ImmutableEntry(name, value);
/* 318 */         entries.add(entry);
/*     */       }
/*     */     }
/* 321 */     return entries;
/*     */   }
/*     */ 
/*     */   private boolean isValidInScope(ScopedProperty prop)
/*     */   {
/* 327 */     boolean valid = (prop != null) && ((prop.getScope() == MessageContext.Scope.APPLICATION) || (this.currentScope == MessageContext.Scope.HANDLER));
/* 328 */     return valid;
/*     */   }
/*     */ 
/*     */   public static void cleanupAttachments(CommonMessageContext messageContext)
/*     */   {
/* 334 */     MessageAbstraction msg = messageContext.getMessageAbstraction();
/*     */ 
/* 336 */     if ((msg != null) && ((msg instanceof SOAPMessage)))
/*     */     {
/* 338 */       Iterator it = ((SOAPMessage)msg).getAttachments();
/* 339 */       while (it.hasNext())
/*     */       {
/* 341 */         AttachmentPart attachment = (AttachmentPart)it.next();
/*     */         try
/*     */         {
/* 344 */           if ((attachment.getDataHandler().getDataSource() instanceof SwapableMemoryDataSource))
/*     */           {
/* 346 */             SwapableMemoryDataSource swapFile = (SwapableMemoryDataSource)attachment.getDataHandler().getDataSource();
/* 347 */             swapFile.cleanup();
/*     */           }
/*     */         }
/*     */         catch (SOAPException e)
/*     */         {
/* 352 */           log.warn("Failed to cleanup attachment part", e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class ScopedProperty
/*     */   {
/*     */     private MessageContext.Scope scope;
/*     */     private String name;
/*     */     private Object value;
/*     */ 
/*     */     public ScopedProperty(String name, Object value, MessageContext.Scope scope)
/*     */     {
/* 393 */       this.scope = scope;
/* 394 */       this.name = name;
/* 395 */       this.value = value;
/*     */     }
/*     */ 
/*     */     public String getName()
/*     */     {
/* 400 */       return this.name;
/*     */     }
/*     */ 
/*     */     public MessageContext.Scope getScope()
/*     */     {
/* 405 */       return this.scope;
/*     */     }
/*     */ 
/*     */     public Object getValue()
/*     */     {
/* 410 */       return this.value;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 415 */       return this.scope + ":" + this.name + "=" + this.value;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ImmutableEntry<K, V>
/*     */     implements Map.Entry<K, V>
/*     */   {
/*     */     final K k;
/*     */     final V v;
/*     */ 
/*     */     ImmutableEntry(K key, V value)
/*     */     {
/* 365 */       this.k = key;
/* 366 */       this.v = value;
/*     */     }
/*     */ 
/*     */     public K getKey()
/*     */     {
/* 371 */       return this.k;
/*     */     }
/*     */ 
/*     */     public V getValue()
/*     */     {
/* 376 */       return this.v;
/*     */     }
/*     */ 
/*     */     public V setValue(V value)
/*     */     {
/* 381 */       throw new UnsupportedOperationException();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.CommonMessageContext
 * JD-Core Version:    0.6.0
 */