/*    */ package org.jboss.ws.core;
/*    */ 
/*    */ import java.util.Set;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.soap.SOAPConstants;
/*    */ import javax.xml.soap.SOAPException;
/*    */ import javax.xml.soap.SOAPHeaderElement;
/*    */ import org.jboss.ws.core.soap.MessageFactoryImpl;
/*    */ import org.jboss.ws.core.soap.SOAPFaultImpl;
/*    */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*    */ 
/*    */ public abstract class CommonSOAP12Binding extends CommonSOAPBinding
/*    */ {
/*    */   private MessageFactoryImpl msgFactory;
/*    */ 
/*    */   public CommonSOAP12Binding()
/*    */   {
/* 50 */     this.msgFactory = new MessageFactoryImpl();
/* 51 */     this.msgFactory.setEnvNamespace("http://www.w3.org/2003/05/soap-envelope");
/*    */   }
/*    */ 
/*    */   protected MessageAbstraction createMessage(OperationMetaData opMetaData)
/*    */     throws SOAPException
/*    */   {
/* 57 */     return (MessageAbstraction)this.msgFactory.createMessage();
/*    */   }
/*    */ 
/*    */   protected abstract Set<String> getRoles();
/*    */ 
/*    */   protected void verifyUnderstoodHeader(SOAPHeaderElement element) throws Exception
/*    */   {
/* 65 */     QName name = new QName(element.getNamespaceURI(), element.getLocalName());
/* 66 */     String actor = element.getActor();
/* 67 */     Set roles = getRoles();
/*    */ 
/* 69 */     boolean isActor = (actor == null) || (actor.length() == 0) || ("http://schemas.xmlsoap.org/soap/actor/next".equals(actor)) || (roles.contains(actor));
/* 70 */     if ((isActor) && (!this.headerSource.getHeaders().contains(name)))
/*    */     {
/* 73 */       QName faultCode = SOAPConstants.SOAP_MUSTUNDERSTAND_FAULT;
/* 74 */       SOAPFaultImpl fault = new SOAPFaultImpl();
/* 75 */       fault.setFaultCode(faultCode);
/* 76 */       fault.setFaultString("SOAP header blocks not understood");
/* 77 */       throwFaultException(fault);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.CommonSOAP12Binding
 * JD-Core Version:    0.6.0
 */