/*     */ package org.jboss.ws.core;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxrpc.ParameterWrapping;
/*     */ import org.jboss.ws.core.soap.SOAPContentElement;
/*     */ import org.jboss.ws.core.utils.HolderUtils;
/*     */ import org.jboss.ws.core.utils.MimeUtils;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class EndpointInvocation
/*     */ {
/*  60 */   private static final Logger log = Logger.getLogger(EndpointInvocation.class);
/*     */   private OperationMetaData opMetaData;
/*  65 */   private Map<QName, Object> reqPayload = new LinkedHashMap();
/*     */ 
/*  67 */   private Map<QName, Object> resPayload = new LinkedHashMap();
/*     */   private Object returnValue;
/*  71 */   private Map<Integer, Object> outParameters = new HashMap();
/*     */ 
/*     */   public EndpointInvocation(OperationMetaData opMetaData)
/*     */   {
/*  75 */     this.opMetaData = opMetaData;
/*     */   }
/*     */ 
/*     */   public OperationMetaData getOperationMetaData()
/*     */   {
/*  80 */     return this.opMetaData;
/*     */   }
/*     */ 
/*     */   public Method getJavaMethod()
/*     */   {
/*  85 */     return this.opMetaData.getJavaMethod();
/*     */   }
/*     */ 
/*     */   public Map<Integer, Object> getOutParameters()
/*     */   {
/*  90 */     return this.outParameters;
/*     */   }
/*     */ 
/*     */   public List<QName> getRequestParamNames()
/*     */   {
/*  95 */     List xmlNames = new ArrayList();
/*  96 */     xmlNames.addAll(this.reqPayload.keySet());
/*  97 */     return xmlNames;
/*     */   }
/*     */ 
/*     */   public void setRequestParamValue(QName xmlName, Object value)
/*     */   {
/* 102 */     if (log.isDebugEnabled())
/* 103 */       log.debug("setRequestParamValue: [name=" + xmlName + ",value=" + getTypeName(value) + "]");
/* 104 */     this.reqPayload.put(xmlName, value);
/*     */   }
/*     */ 
/*     */   public Object getRequestParamValue(QName xmlName)
/*     */   {
/* 109 */     if (log.isDebugEnabled())
/* 110 */       log.debug("getRequestParamValue: " + xmlName);
/* 111 */     Object paramValue = this.reqPayload.get(xmlName);
/* 112 */     ParameterMetaData paramMetaData = this.opMetaData.getParameter(xmlName);
/*     */     try
/*     */     {
/* 115 */       paramValue = transformPayloadValue(paramMetaData, paramValue);
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/* 119 */       throw new WSException(ex);
/*     */     }
/* 121 */     return paramValue;
/*     */   }
/*     */ 
/*     */   public Object[] getRequestPayload()
/*     */   {
/* 128 */     log.debug("getRequestPayload");
/* 129 */     List xmlNames = getRequestParamNames();
/*     */ 
/* 131 */     Object[] payload = new Object[this.opMetaData.getJavaMethod().getParameterTypes().length];
/* 132 */     for (int i = 0; i < xmlNames.size(); i++)
/*     */     {
/* 134 */       QName xmlName = (QName)xmlNames.get(i);
/* 135 */       Object paramValue = getRequestParamValue(xmlName);
/*     */ 
/* 137 */       ParameterMetaData paramMetaData = this.opMetaData.getParameter(xmlName);
/* 138 */       syncEndpointInputParam(paramMetaData, paramValue, payload);
/*     */     }
/*     */ 
/* 141 */     return payload;
/*     */   }
/*     */ 
/*     */   public List<QName> getResponseParamNames()
/*     */   {
/* 146 */     List xmlNames = new ArrayList();
/* 147 */     xmlNames.addAll(this.resPayload.keySet());
/* 148 */     return xmlNames;
/*     */   }
/*     */ 
/*     */   public void setResponseParamValue(QName xmlName, Object value)
/*     */   {
/* 153 */     if (log.isDebugEnabled())
/* 154 */       log.debug("setResponseParamValue: [name=" + xmlName + ",value=" + getTypeName(value) + "]");
/* 155 */     this.resPayload.put(xmlName, value);
/*     */   }
/*     */ 
/*     */   public Object getResponseParamValue(QName xmlName) throws SOAPException
/*     */   {
/* 160 */     if (log.isDebugEnabled())
/* 161 */       log.debug("getResponseParamValue: " + xmlName);
/* 162 */     Object paramValue = this.resPayload.get(xmlName);
/* 163 */     ParameterMetaData paramMetaData = this.opMetaData.getParameter(xmlName);
/* 164 */     paramValue = transformPayloadValue(paramMetaData, paramValue);
/* 165 */     if (paramValue != null)
/*     */     {
/* 167 */       Class valueType = paramValue.getClass();
/* 168 */       if (HolderUtils.isHolderType(valueType))
/*     */       {
/* 170 */         paramValue = HolderUtils.getHolderValue(paramValue);
/*     */       }
/*     */     }
/* 173 */     return paramValue;
/*     */   }
/*     */ 
/*     */   public void setReturnValue(Object value)
/*     */   {
/* 178 */     ParameterMetaData retMetaData = this.opMetaData.getReturnParameter();
/* 179 */     if ((value != null) && (retMetaData == null)) {
/* 180 */       throw new WSException("Operation does not have a return value: " + this.opMetaData.getQName());
/*     */     }
/* 182 */     if (log.isDebugEnabled())
/* 183 */       log.debug("setReturnValue: " + getTypeName(value));
/* 184 */     this.returnValue = value;
/*     */   }
/*     */ 
/*     */   public Object getReturnValue()
/*     */   {
/* 189 */     if (log.isDebugEnabled())
/* 190 */       log.debug("getReturnValue");
/* 191 */     Object paramValue = this.returnValue;
/* 192 */     ParameterMetaData paramMetaData = this.opMetaData.getReturnParameter();
/* 193 */     if (paramMetaData != null)
/*     */     {
/*     */       try
/*     */       {
/* 197 */         paramValue = transformPayloadValue(paramMetaData, paramValue);
/*     */       }
/*     */       catch (SOAPException ex)
/*     */       {
/* 201 */         throw new WSException(ex);
/*     */       }
/*     */     }
/* 204 */     return paramValue;
/*     */   }
/*     */ 
/*     */   private Object transformPayloadValue(ParameterMetaData paramMetaData, Object paramValue) throws SOAPException
/*     */   {
/* 209 */     QName xmlName = paramMetaData.getXmlName();
/* 210 */     QName xmlType = paramMetaData.getXmlType();
/* 211 */     Class javaType = paramMetaData.getJavaType();
/* 212 */     String javaName = paramMetaData.getJavaTypeName();
/*     */ 
/* 214 */     if (xmlType == null) {
/* 215 */       throw new IllegalStateException("Cannot obtain xml type for: [xmlName=" + xmlName + ",javaName=" + javaName + "]");
/*     */     }
/* 217 */     Object retValue = paramValue;
/*     */ 
/* 220 */     if ((paramValue instanceof AttachmentPart))
/*     */     {
/* 222 */       AttachmentPart part = (AttachmentPart)paramValue;
/*     */ 
/* 224 */       Set mimeTypes = paramMetaData.getMimeTypes();
/* 225 */       if ((DataHandler.class.isAssignableFrom(javaType)) && (!javaType.equals(Object.class)))
/*     */       {
/* 227 */         DataHandler handler = part.getDataHandler();
/* 228 */         String mimeType = MimeUtils.getBaseMimeType(handler.getContentType());
/*     */ 
/* 233 */         if ((mimeTypes != null) && (!MimeUtils.isMemberOf(mimeType, mimeTypes))) {
/* 234 */           log.warn("Mime type " + mimeType + " not allowed for parameter " + xmlName + " allowed types are " + mimeTypes);
/*     */         }
/* 236 */         retValue = part.getDataHandler();
/*     */       }
/*     */       else
/*     */       {
/* 240 */         retValue = part.getContent();
/* 241 */         String mimeType = MimeUtils.getBaseMimeType(part.getContentType());
/*     */ 
/* 243 */         if ((mimeTypes != null) && (!MimeUtils.isMemberOf(mimeType, mimeTypes))) {
/* 244 */           throw new SOAPException("Mime type " + mimeType + " not allowed for parameter " + xmlName + " allowed types are " + mimeTypes);
/*     */         }
/* 246 */         if (retValue != null)
/*     */         {
/* 248 */           Class valueType = retValue.getClass();
/* 249 */           if (!JavaUtils.isAssignableFrom(javaType, valueType))
/* 250 */             throw new SOAPException("javaType [" + javaType.getName() + "] is not assignable from attachment content: " + valueType.getName());
/*     */         }
/*     */       }
/*     */     }
/* 254 */     else if ((paramValue instanceof SOAPContentElement))
/*     */     {
/* 260 */       if (!Element.class.isAssignableFrom(javaType))
/*     */       {
/* 262 */         SOAPContentElement soapElement = (SOAPContentElement)paramValue;
/* 263 */         retValue = soapElement.getObjectValue();
/*     */       }
/*     */     }
/*     */ 
/* 267 */     if (log.isDebugEnabled())
/* 268 */       log.debug("transformPayloadValue: " + getTypeName(paramValue) + " -> " + getTypeName(retValue));
/* 269 */     return retValue;
/*     */   }
/*     */ 
/*     */   public void initInputParams(Object[] inputParams)
/*     */   {
/* 277 */     for (ParameterMetaData paramMetaData : this.opMetaData.getParameters())
/*     */     {
/* 279 */       int index = paramMetaData.getIndex();
/*     */ 
/* 282 */       if (index < 0) {
/*     */         continue;
/*     */       }
/* 285 */       QName xmlName = paramMetaData.getXmlName();
/* 286 */       Class javaType = paramMetaData.getJavaType();
/*     */       Object value;
/*     */       Object value;
/* 289 */       if ((this.opMetaData.isDocumentWrapped()) && (!paramMetaData.isInHeader()) && (!paramMetaData.isSwA()))
/*     */       {
/* 291 */         value = ParameterWrapping.wrapRequestParameters(paramMetaData, inputParams);
/*     */       }
/*     */       else
/*     */       {
/* 295 */         value = inputParams[index];
/* 296 */         if (value != null)
/*     */         {
/* 298 */           Class inputType = value.getClass();
/*     */ 
/* 300 */           if (HolderUtils.isHolderType(inputType))
/*     */           {
/* 304 */             value = HolderUtils.getHolderValue(value);
/* 305 */             inputType = value == null ? null : value.getClass();
/*     */           }
/*     */ 
/* 310 */           if ((value != null) && (!paramMetaData.isSwA()) && (!paramMetaData.isXOP()))
/*     */           {
/* 312 */             if (!JavaUtils.isAssignableFrom(javaType, inputType)) {
/* 313 */               throw new WSException("Parameter '" + javaType + "' not assignable from: " + inputType);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 318 */       setRequestParamValue(xmlName, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void syncEndpointInputParam(ParameterMetaData paramMetaData, Object paramValue, Object[] payload)
/*     */   {
/* 327 */     Object retValue = paramValue;
/* 328 */     Method method = this.opMetaData.getJavaMethod();
/* 329 */     Class[] targetParameterTypes = method.getParameterTypes();
/*     */ 
/* 331 */     if ((this.opMetaData.isDocumentWrapped()) && (!paramMetaData.isInHeader()) && (!paramMetaData.isSwA()) && (!paramMetaData.isMessageType()))
/*     */     {
/* 333 */       this.outParameters = ParameterWrapping.unwrapRequestParameters(paramMetaData, paramValue, payload);
/* 334 */       syncOutWrappedParameters(targetParameterTypes, payload);
/*     */     }
/*     */     else
/*     */     {
/* 339 */       int index = paramMetaData.getIndex();
/* 340 */       Class targetParameterType = targetParameterTypes[index];
/*     */ 
/* 342 */       if ((paramMetaData.getMode() == ParameterMode.INOUT) || (paramMetaData.getMode() == ParameterMode.OUT))
/*     */       {
/* 344 */         retValue = HolderUtils.createHolderInstance(paramValue, targetParameterType);
/*     */ 
/* 346 */         QName xmlName = paramMetaData.getXmlName();
/* 347 */         setResponseParamValue(xmlName, retValue);
/*     */       }
/*     */ 
/* 350 */       if (retValue != null)
/*     */       {
/* 352 */         Class valueType = retValue.getClass();
/* 353 */         if (!JavaUtils.isAssignableFrom(targetParameterType, valueType)) {
/* 354 */           throw new WSException("Parameter " + targetParameterType.getName() + " is not assignable from: " + getTypeName(retValue));
/*     */         }
/* 356 */         if (valueType.isArray()) {
/* 357 */           retValue = JavaUtils.syncArray(retValue, targetParameterType);
/*     */         }
/*     */       }
/* 360 */       if (log.isDebugEnabled())
/* 361 */         log.debug("syncEndpointInputParam: " + getTypeName(paramValue) + " -> " + getTypeName(retValue) + "(" + index + ")");
/* 362 */       payload[index] = retValue;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void syncOutWrappedParameters(Class[] targetParameterTypes, Object[] payload)
/*     */   {
/* 368 */     ParameterMetaData returnMetaData = this.opMetaData.getReturnParameter();
/* 369 */     if (returnMetaData != null)
/*     */     {
/* 371 */       for (WrappedParameter param : returnMetaData.getWrappedParameters())
/*     */       {
/*     */         try
/*     */         {
/* 376 */           if ((param.getIndex() >= 0) && (!this.outParameters.containsKey(Integer.valueOf(param.getIndex()))))
/*     */           {
/* 378 */             Object holder = targetParameterTypes[param.getIndex()].newInstance();
/* 379 */             payload[param.getIndex()] = holder;
/* 380 */             this.outParameters.put(Integer.valueOf(param.getIndex()), holder);
/*     */           }
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 385 */           throw new WSException("Could not add output param: " + param.getName(), e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getTypeName(Object value)
/*     */   {
/* 394 */     String valueType = value != null ? value.getClass().getName() : null;
/* 395 */     return valueType;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.EndpointInvocation
 * JD-Core Version:    0.6.0
 */