/*     */ package org.jboss.ws.core.client;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.soap.SOAPMessageMarshaller;
/*     */ import org.jboss.ws.core.soap.SOAPMessageUnMarshaller;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ 
/*     */ public class SOAPRemotingConnection extends RemotingConnectionImpl
/*     */ {
/*     */   protected UnMarshaller getUnmarshaller()
/*     */   {
/*  56 */     return new SOAPMessageUnMarshaller();
/*     */   }
/*     */ 
/*     */   protected Marshaller getMarshaller()
/*     */   {
/*  61 */     return new SOAPMessageMarshaller();
/*     */   }
/*     */ 
/*     */   public MessageAbstraction invoke(MessageAbstraction reqMessage, Object endpoint, boolean oneway) throws IOException
/*     */   {
/*     */     IOException io;
/*     */     try
/*     */     {
/*  70 */       XOPContext.eagerlyCreateAttachments();
/*     */ 
/*  73 */       SOAPMessage soapMessage = (SOAPMessage)reqMessage;
/*  74 */       if ((reqMessage != null) && (soapMessage.saveRequired())) {
/*  75 */         soapMessage.saveChanges();
/*     */       }
/*  77 */       return super.invoke(reqMessage, endpoint, oneway);
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/*  81 */       io = new IOException();
/*  82 */       io.initCause(ex);
/*  83 */     }throw io;
/*     */   }
/*     */ 
/*     */   protected void populateHeaders(MessageAbstraction reqMessage, Map<String, Object> metadata)
/*     */   {
/*  89 */     super.populateHeaders(reqMessage, metadata);
/*     */ 
/*  91 */     Properties props = (Properties)metadata.get("HEADER");
/*     */ 
/* 102 */     MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
/* 103 */     String[] action = mimeHeaders.getHeader("SOAPAction");
/* 104 */     if ((action != null) && (action.length > 0))
/*     */     {
/* 106 */       String soapAction = action[0];
/*     */ 
/* 109 */       if ((!soapAction.startsWith("\"")) || (!soapAction.endsWith("\""))) {
/* 110 */         soapAction = "\"" + soapAction + "\"";
/*     */       }
/* 112 */       props.put("SOAPAction", soapAction);
/*     */     }
/*     */     else
/*     */     {
/* 116 */       props.put("SOAPAction", "\"\"");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.client.SOAPRemotingConnection
 * JD-Core Version:    0.6.0
 */