/*    */ package org.jboss.ws.core.client;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.HashMap;
/*    */ import java.util.List;
/*    */ import java.util.Map;
/*    */ import javax.naming.spi.ObjectFactory;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.WSException;
/*    */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*    */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*    */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
/*    */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
/*    */ 
/*    */ public abstract class ServiceObjectFactory
/*    */   implements ObjectFactory
/*    */ {
/* 53 */   private static final Logger log = Logger.getLogger(ServiceObjectFactory.class);
/*    */ 
/*    */   protected void narrowPortSelection(UnifiedServiceRefMetaData serviceRef, ServiceMetaData serviceMetaData)
/*    */   {
/*    */     Map pcrefs;
/* 61 */     if (serviceMetaData.getEndpoints().size() > 1)
/*    */     {
/* 63 */       pcrefs = new HashMap();
/* 64 */       for (UnifiedPortComponentRefMetaData pcref : serviceRef.getPortComponentRefs())
/*    */       {
/* 66 */         String seiName = pcref.getServiceEndpointInterface();
/*    */ 
/* 69 */         if (pcrefs.get(seiName) != null) {
/* 70 */           throw new WSException("Within a <service-ref> it's not allowed to use a SEI across different <port-component-ref>'s: " + seiName);
/*    */         }
/* 72 */         pcrefs.put(seiName, pcref);
/*    */       }
/*    */ 
/* 76 */       for (String sei : pcrefs.keySet())
/*    */       {
/* 79 */         List narrowedEndpoints = new ArrayList();
/*    */ 
/* 81 */         UnifiedPortComponentRefMetaData pcref = (UnifiedPortComponentRefMetaData)pcrefs.get(sei);
/*    */ 
/* 84 */         if ((pcref.getServiceEndpointInterface() != null) && (pcref.getPortQName() != null))
/*    */         {
/* 86 */           List pcRef2EndpointMapping = new ArrayList();
/* 87 */           for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints())
/*    */           {
/* 89 */             if (pcref.getServiceEndpointInterface().equals(epMetaData.getServiceEndpointInterfaceName()))
/*    */             {
/* 91 */               pcRef2EndpointMapping.add(epMetaData.getPortName());
/*    */             }
/*    */           }
/*    */ 
/* 95 */           for (QName q : pcRef2EndpointMapping)
/*    */           {
/* 97 */             EndpointMetaData mappedEndpoint = serviceMetaData.getEndpoint(q);
/* 98 */             if (!pcref.getPortQName().equals(mappedEndpoint.getPortName())) {
/* 99 */               narrowedEndpoints.add(q);
/*    */             }
/*    */           }
/*    */ 
/* 103 */           if ((pcRef2EndpointMapping.size() > 0) && (pcRef2EndpointMapping.size() == narrowedEndpoints.size())) {
/* 104 */             throw new WSException("Failed to narrow available endpoints by <port-component-ref> declaration");
/*    */           }
/* 106 */           for (QName q : narrowedEndpoints)
/*    */           {
/* 108 */             EndpointMetaData removed = serviceMetaData.removeEndpoint(q);
/* 109 */             log.debug("Narrowed endpoint " + q + "(" + removed + ")");
/*    */           }
/*    */ 
/*    */         }
/*    */         else
/*    */         {
/* 115 */           log.warn("Unable to narrow port selection for " + pcref);
/*    */         }
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.client.ServiceObjectFactory
 * JD-Core Version:    0.6.0
 */