/*     */ package org.jboss.ws.core.jaxrpc;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.net.URI;
/*     */ import java.util.Calendar;
/*     */ import java.util.Date;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.core.jaxrpc.binding.Base64DeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.Base64SerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.CalendarDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.CalendarSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.DateDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.DateSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.ElementDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.ElementSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.HexDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.HexSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.QNameDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.QNameSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.SOAPElementDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.SOAPElementSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.SimpleDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.SimpleSerializerFactory;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class EncodedTypeMapping extends TypeMappingImpl
/*     */ {
/*     */   public EncodedTypeMapping()
/*     */   {
/*  79 */     registerStandardLiteralTypes();
/*  80 */     registerStandardSOAP11EncodedTypes();
/*     */ 
/*  83 */     register(SOAPElement.class, Constants.TYPE_LITERAL_ANYTYPE, new SOAPElementSerializerFactory(), new SOAPElementDeserializerFactory());
/*  84 */     register(Element.class, Constants.TYPE_LITERAL_ANYTYPE, new ElementSerializerFactory(), new ElementDeserializerFactory());
/*     */ 
/*  87 */     register(SOAPElement.class, Constants.TYPE_SOAP11_ANYTYPE, new SOAPElementSerializerFactory(), new SOAPElementDeserializerFactory());
/*  88 */     register(Element.class, Constants.TYPE_SOAP11_ANYTYPE, new ElementSerializerFactory(), new ElementDeserializerFactory());
/*     */   }
/*     */ 
/*     */   private void registerStandardSOAP11EncodedTypes()
/*     */   {
/*  93 */     register(BigDecimal.class, Constants.TYPE_SOAP11_DECIMAL, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/*  95 */     register(BigInteger.class, Constants.TYPE_SOAP11_POSITIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*  96 */     register(BigInteger.class, Constants.TYPE_SOAP11_NEGATIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*  97 */     register(BigInteger.class, Constants.TYPE_SOAP11_NONPOSITIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*  98 */     register(BigInteger.class, Constants.TYPE_SOAP11_NONNEGATIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*  99 */     register(BigInteger.class, Constants.TYPE_SOAP11_UNSIGNEDLONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 100 */     register(BigInteger.class, Constants.TYPE_SOAP11_INTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 102 */     register(Date.class, Constants.TYPE_SOAP11_DATETIME, new DateSerializerFactory(), new DateDeserializerFactory());
/*     */ 
/* 104 */     register(Calendar.class, Constants.TYPE_SOAP11_DATE, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
/* 105 */     register(Calendar.class, Constants.TYPE_SOAP11_TIME, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
/* 106 */     register(Calendar.class, Constants.TYPE_SOAP11_DATETIME, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
/*     */ 
/* 108 */     register(QName.class, Constants.TYPE_SOAP11_QNAME, new QNameSerializerFactory(), new QNameDeserializerFactory());
/*     */ 
/* 110 */     register(String.class, Constants.TYPE_SOAP11_ANYSIMPLETYPE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 111 */     register(String.class, Constants.TYPE_SOAP11_DURATION, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 112 */     register(String.class, Constants.TYPE_SOAP11_GDAY, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 113 */     register(String.class, Constants.TYPE_SOAP11_GMONTH, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 114 */     register(String.class, Constants.TYPE_SOAP11_GMONTHDAY, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 115 */     register(String.class, Constants.TYPE_SOAP11_GYEAR, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 116 */     register(String.class, Constants.TYPE_SOAP11_GYEARMONTH, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 117 */     register(String.class, Constants.TYPE_SOAP11_ID, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 118 */     register(String.class, Constants.TYPE_SOAP11_LANGUAGE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 119 */     register(String.class, Constants.TYPE_SOAP11_NAME, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 120 */     register(String.class, Constants.TYPE_SOAP11_NCNAME, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 121 */     register(String.class, Constants.TYPE_SOAP11_NMTOKEN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 122 */     register(String.class, Constants.TYPE_SOAP11_NORMALIZEDSTRING, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 123 */     register(String.class, Constants.TYPE_SOAP11_TOKEN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 124 */     register(String.class, Constants.TYPE_SOAP11_STRING, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 126 */     register([Ljava.lang.String.class, Constants.TYPE_SOAP11_NMTOKENS, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 128 */     register(URI.class, Constants.TYPE_SOAP11_ANYURI, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 130 */     register(Boolean.TYPE, Constants.TYPE_SOAP11_BOOLEAN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 131 */     register(Boolean.class, Constants.TYPE_SOAP11_BOOLEAN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 133 */     register(Byte.TYPE, Constants.TYPE_SOAP11_BYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 134 */     register(Byte.class, Constants.TYPE_SOAP11_BYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 136 */     register([B.class, Constants.TYPE_SOAP11_HEXBINARY, new HexSerializerFactory(), new HexDeserializerFactory());
/* 137 */     register([Ljava.lang.Byte.class, Constants.TYPE_SOAP11_HEXBINARY, new HexSerializerFactory(), new HexDeserializerFactory());
/* 138 */     register([B.class, Constants.TYPE_SOAP11_BASE64BINARY, new Base64SerializerFactory(), new Base64DeserializerFactory());
/* 139 */     register([Ljava.lang.Byte.class, Constants.TYPE_SOAP11_BASE64BINARY, new Base64SerializerFactory(), new Base64DeserializerFactory());
/* 140 */     register([B.class, Constants.TYPE_SOAP11_BASE64, new Base64SerializerFactory(), new Base64DeserializerFactory());
/* 141 */     register([Ljava.lang.Byte.class, Constants.TYPE_SOAP11_BASE64, new Base64SerializerFactory(), new Base64DeserializerFactory());
/*     */ 
/* 143 */     register(Double.TYPE, Constants.TYPE_SOAP11_DOUBLE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 144 */     register(Double.class, Constants.TYPE_SOAP11_DOUBLE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 146 */     register(Float.TYPE, Constants.TYPE_SOAP11_FLOAT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 147 */     register(Float.class, Constants.TYPE_SOAP11_FLOAT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 149 */     register(Integer.TYPE, Constants.TYPE_SOAP11_UNSIGNEDSHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 150 */     register(Integer.class, Constants.TYPE_SOAP11_UNSIGNEDSHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 151 */     register(Integer.TYPE, Constants.TYPE_SOAP11_INT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 152 */     register(Integer.class, Constants.TYPE_SOAP11_INT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 154 */     register(Long.TYPE, Constants.TYPE_SOAP11_UNSIGNEDINT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 155 */     register(Long.class, Constants.TYPE_SOAP11_UNSIGNEDINT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 156 */     register(Long.TYPE, Constants.TYPE_SOAP11_LONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 157 */     register(Long.class, Constants.TYPE_SOAP11_LONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 159 */     register(Short.TYPE, Constants.TYPE_SOAP11_UNSIGNEDBYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 160 */     register(Short.class, Constants.TYPE_SOAP11_UNSIGNEDBYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 161 */     register(Short.TYPE, Constants.TYPE_SOAP11_SHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 162 */     register(Short.class, Constants.TYPE_SOAP11_SHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */   }
/*     */ 
/*     */   public String[] getSupportedEncodings()
/*     */   {
/* 174 */     return new String[] { "encoded" };
/*     */   }
/*     */ 
/*     */   public void setSupportedEncodings(String[] encodingStyleURIs)
/*     */   {
/* 185 */     throw new NotImplementedException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.EncodedTypeMapping
 * JD-Core Version:    0.6.0
 */