/*     */ package org.jboss.ws.core.jaxrpc;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.JAXRPCException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.tools.JavaToXSD;
/*     */ 
/*     */ public class SchemaGenerator
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(SchemaGenerator.class);
/*     */ 
/*  48 */   private boolean restrictToTargetNamespace = true;
/*     */ 
/*     */   public JBossXSModel generateXSDSchema(QName xmlType, Class javaType)
/*     */   {
/*  52 */     if (log.isDebugEnabled()) log.debug("generateXSDSchema: [xmlType=" + xmlType + ",javaType=" + javaType.getName() + "]");
/*     */     try
/*     */     {
/*  55 */       assertXmlType(xmlType);
/*  56 */       String nsuri = xmlType.getNamespaceURI();
/*  57 */       Class componentType = javaType;
/*  58 */       while (componentType.isArray()) {
/*  59 */         componentType = componentType.getComponentType();
/*     */       }
/*  61 */       JavaToXSD javaToXSD = new JavaToXSD();
/*     */ 
/*  64 */       if (!componentType.isPrimitive())
/*     */       {
/*  66 */         Map namespaceMap = new HashMap();
/*  67 */         namespaceMap.put(componentType.getPackage().getName(), nsuri);
/*  68 */         javaToXSD.setPackageNamespaceMap(namespaceMap);
/*     */       }
/*     */ 
/*  71 */       JBossXSModel xsModel = javaToXSD.generateForSingleType(xmlType, javaType);
/*  72 */       if (xsModel == null) {
/*  73 */         throw new WSException("Cannot generate XSModel");
/*     */       }
/*  75 */       if (log.isDebugEnabled()) log.debug("\n" + xsModel.serialize());
/*  76 */       return xsModel;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/*  80 */       throw rte;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  84 */     throw new JAXRPCException("Cannot generate xsdSchema for: " + xmlType, e);
/*     */   }
/*     */ 
/*     */   public void setRestrictToTargetNamespace(boolean restrictToTargetNamespace)
/*     */   {
/*  95 */     this.restrictToTargetNamespace = restrictToTargetNamespace;
/*     */   }
/*     */ 
/*     */   private void assertXmlType(QName xmlType)
/*     */   {
/* 102 */     String nsURI = xmlType.getNamespaceURI();
/* 103 */     if (nsURI.length() == 0)
/* 104 */       throw new IllegalArgumentException("Invalid namespace for type: " + xmlType);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.SchemaGenerator
 * JD-Core Version:    0.6.0
 */