/*     */ package org.jboss.ws.core.jaxrpc;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.xml.rpc.JAXRPCException;
/*     */ import javax.xml.rpc.encoding.TypeMapping;
/*     */ import javax.xml.rpc.encoding.TypeMappingRegistry;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ 
/*     */ public class TypeMappingRegistryImpl
/*     */   implements TypeMappingRegistry
/*     */ {
/*  46 */   private Map<String, TypeMappingImpl> typeMappings = new HashMap();
/*     */ 
/*     */   public TypeMappingRegistryImpl()
/*     */   {
/*  50 */     this.typeMappings.put("", new LiteralTypeMapping());
/*  51 */     this.typeMappings.put("http://schemas.xmlsoap.org/soap/encoding/", new EncodedTypeMapping());
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*  59 */     this.typeMappings.clear();
/*     */   }
/*     */ 
/*     */   public TypeMapping getDefaultTypeMapping()
/*     */   {
/*  69 */     return (TypeMapping)this.typeMappings.get("");
/*     */   }
/*     */ 
/*     */   public void registerDefault(TypeMapping mapping)
/*     */   {
/*  85 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public TypeMapping createTypeMapping()
/*     */   {
/*  94 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public TypeMapping getTypeMapping(String encodingStyleURI)
/*     */   {
/* 105 */     assertEncodingStyle(encodingStyleURI);
/* 106 */     return (TypeMapping)this.typeMappings.get(encodingStyleURI);
/*     */   }
/*     */ 
/*     */   public String[] getRegisteredEncodingStyleURIs()
/*     */   {
/* 115 */     return new String[] { "", "http://schemas.xmlsoap.org/soap/encoding/" };
/*     */   }
/*     */ 
/*     */   public TypeMapping register(String encodingStyleURI, TypeMapping mapping)
/*     */   {
/* 130 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public TypeMapping unregisterTypeMapping(String encodingStyleURI)
/*     */   {
/* 141 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public boolean removeTypeMapping(TypeMapping mapping)
/*     */   {
/* 156 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   private void assertEncodingStyle(String encURI)
/*     */   {
/* 162 */     if ((!"".equals(encURI)) && (!"http://schemas.xmlsoap.org/soap/encoding/".equals(encURI)))
/* 163 */       throw new JAXRPCException("Unsupported encoding style: " + encURI);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.TypeMappingRegistryImpl
 * JD-Core Version:    0.6.0
 */