/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.transform.Result;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.ws.core.binding.SerializerSupport;
/*    */ import org.jboss.ws.extensions.xop.XOPContext;
/*    */ import org.jboss.ws.extensions.xop.jaxrpc.XOPMarshallerImpl;
/*    */ import org.jboss.wsf.common.JavaUtils;
/*    */ import org.jboss.xb.binding.NamespaceRegistry;
/*    */ import org.jboss.xb.binding.SimpleTypeBindings;
/*    */ import org.jboss.xb.binding.sunday.xop.XOPMarshaller;
/*    */ import org.jboss.xb.binding.sunday.xop.XOPObject;
/*    */ import org.w3c.dom.NamedNodeMap;
/*    */ 
/*    */ public class Base64Serializer extends SerializerSupport
/*    */ {
/* 52 */   private static final Logger log = Logger.getLogger(Base64Serializer.class);
/*    */ 
/*    */   public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException
/*    */   {
/* 56 */     if (log.isDebugEnabled()) {
/* 57 */       log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*    */     }
/* 59 */     String xmlFragment = null;
/* 60 */     NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
/*    */ 
/* 62 */     if (XOPContext.isXOPMessage())
/*    */     {
/* 64 */       XOPMarshaller xopMarshaller = new XOPMarshallerImpl();
/* 65 */       XOPObject xopObject = new XOPObject(value);
/* 66 */       xopObject.setContentType("application/octet-stream");
/* 67 */       String cid = xopMarshaller.addMtomAttachment(xopObject, xmlName.getNamespaceURI(), xmlType.getLocalPart());
/* 68 */       String xopInclude = "<xop:Include xmlns:xop='http://www.w3.org/2004/08/xop/include' href='" + cid + "'/>";
/* 69 */       xmlFragment = wrapValueStr(xmlName, xopInclude, nsRegistry, null, attributes, false);
/*    */     }
/*    */     else
/*    */     {
/* 73 */       value = JavaUtils.getPrimitiveValueArray(value);
/* 74 */       String valueStr = SimpleTypeBindings.marshalBase64((byte[])(byte[])value);
/* 75 */       xmlFragment = wrapValueStr(xmlName, valueStr, nsRegistry, null, attributes, true);
/*    */     }
/* 77 */     return new BufferedStreamResult(xmlFragment);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.Base64Serializer
 * JD-Core Version:    0.6.0
 */