/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.transform.Result;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.ws.core.binding.SerializerSupport;
/*    */ import org.jboss.wsf.common.JavaUtils;
/*    */ import org.jboss.xb.binding.NamespaceRegistry;
/*    */ import org.jboss.xb.binding.SimpleTypeBindings;
/*    */ import org.w3c.dom.NamedNodeMap;
/*    */ 
/*    */ public class HexSerializer extends SerializerSupport
/*    */ {
/* 49 */   private static final Logger log = Logger.getLogger(HexSerializer.class);
/*    */ 
/*    */   public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException
/*    */   {
/* 53 */     if (log.isDebugEnabled()) log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*    */ 
/* 55 */     value = JavaUtils.getPrimitiveValueArray(value);
/* 56 */     String valueStr = SimpleTypeBindings.marshalHexBinary((byte[])(byte[])value);
/*    */ 
/* 58 */     NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
/* 59 */     String xmlFragment = wrapValueStr(xmlName, valueStr, nsRegistry, null, attributes, true);
/* 60 */     return new BufferedStreamResult(xmlFragment);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.HexSerializer
 * JD-Core Version:    0.6.0
 */