/*     */ package org.jboss.ws.core.jaxrpc.binding;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Source;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.binding.DeserializerSupport;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.jboss.xb.binding.SimpleTypeBindings;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public class QNameDeserializer extends DeserializerSupport
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(QNameDeserializer.class);
/*     */ 
/*     */   public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
/*  52 */     return deserialize(xmlName, xmlType, sourceToString(xmlFragment), serContext);
/*     */   }
/*     */ 
/*     */   private Object deserialize(QName xmlName, QName xmlType, String xmlFragment, SerializationContext serContext) throws BindingException
/*     */   {
/*  57 */     if (log.isDebugEnabled()) log.debug("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*     */ 
/*  59 */     QName value = null;
/*     */ 
/*  61 */     NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
/*  62 */     String valueStr = unwrapValueStr(xmlFragment, nsRegistry);
/*  63 */     if (valueStr != null)
/*     */     {
/*  65 */       value = SimpleTypeBindings.unmarshalQName(valueStr, nsRegistry);
/*     */     }
/*     */ 
/*  68 */     return value;
/*     */   }
/*     */ 
/*     */   protected String unwrapValueStr(String xmlFragment, NamespaceRegistry nsRegistry)
/*     */   {
/*  76 */     if (!isEmptyElement(xmlFragment))
/*     */     {
/*     */       try
/*     */       {
/*  81 */         Element el = DOMUtils.parse(xmlFragment);
/*  82 */         NamedNodeMap attribs = el.getAttributes();
/*  83 */         for (int i = 0; i < attribs.getLength(); i++)
/*     */         {
/*  85 */           Node attr = attribs.item(i);
/*  86 */           String nodeName = attr.getNodeName();
/*  87 */           if (!nodeName.startsWith("xmlns:"))
/*     */             continue;
/*  89 */           String prefix = nodeName.substring(6);
/*  90 */           String nsURI = attr.getNodeValue();
/*  91 */           nsRegistry.registerURI(nsURI, prefix);
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*  97 */         throw new IllegalArgumentException("Cannot parse xmlFragment: " + xmlFragment);
/*     */       }
/*     */     }
/*     */ 
/* 101 */     return super.unwrapValueStr(xmlFragment);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.QNameDeserializer
 * JD-Core Version:    0.6.0
 */