/*     */ package org.jboss.ws.core.jaxrpc.client;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.handler.HandlerChain;
/*     */ import javax.xml.rpc.handler.HandlerInfo;
/*     */ import javax.xml.rpc.handler.HandlerRegistry;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.jaxrpc.handler.ClientHandlerChain;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
/*     */ 
/*     */ public class HandlerRegistryImpl
/*     */   implements HandlerRegistry
/*     */ {
/*  65 */   private static Logger log = Logger.getLogger(HandlerRegistryImpl.class);
/*     */ 
/*  68 */   private Map<QName, HandlerChain> handlerChains = new HashMap();
/*     */ 
/*  70 */   private Map<QName, List<HandlerInfo>> handlerInfos = new HashMap();
/*     */   private ServiceMetaData serviceMetaData;
/*     */ 
/*     */   public HandlerRegistryImpl(ServiceMetaData serviceMetaData)
/*     */   {
/*  76 */     this.serviceMetaData = serviceMetaData;
/*     */   }
/*     */ 
/*     */   public List getHandlerChain(QName portName)
/*     */   {
/*  81 */     List list = (List)this.handlerInfos.get(portName);
/*  82 */     if (list == null) {
/*  83 */       list = new ArrayList();
/*     */     }
/*  85 */     return new ArrayList(list);
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(QName portName, List chain)
/*     */   {
/*  90 */     registerClientHandlerChain(portName, chain, null);
/*     */   }
/*     */ 
/*     */   HandlerChain getHandlerChainInstance(QName portName)
/*     */   {
/*  97 */     HandlerChain handlerChain = (HandlerChain)this.handlerChains.get(portName);
/*  98 */     return handlerChain;
/*     */   }
/*     */ 
/*     */   void registerClientHandlerChain(QName portName, List<HandlerInfo> infos, Set<String> roles)
/*     */   {
/* 105 */     ClientHandlerChain chain = new ClientHandlerChain(infos, roles);
/* 106 */     this.handlerChains.put(portName, chain);
/* 107 */     this.handlerInfos.put(portName, infos);
/*     */ 
/* 109 */     EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
/* 110 */     if (epMetaData == null) {
/* 111 */       throw new IllegalStateException("Cannot obtain endpoint meta data for: " + portName);
/*     */     }
/* 113 */     epMetaData.clearHandlers();
/* 114 */     for (HandlerInfo info : infos)
/*     */     {
/* 116 */       HandlerMetaDataJAXRPC handler = new HandlerMetaDataJAXRPC(UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/* 117 */       handler.setEndpointMetaData(epMetaData);
/* 118 */       handler.setHandlerClassName(info.getHandlerClass().getName());
/* 119 */       handler.setSoapRoles(roles);
/*     */ 
/* 122 */       Set headers = new HashSet();
/* 123 */       for (QName header : info.getHeaders())
/* 124 */         headers.add(header);
/* 125 */       handler.setSoapHeaders(headers);
/*     */ 
/* 128 */       List initParams = new ArrayList();
/* 129 */       Iterator entries = info.getHandlerConfig().entrySet().iterator();
/* 130 */       while (entries.hasNext())
/*     */       {
/* 132 */         Map.Entry entry = (Map.Entry)entries.next();
/* 133 */         String key = (String)entry.getKey();
/* 134 */         Object value = entry.getValue();
/* 135 */         if ((value instanceof String))
/* 136 */           initParams.add(new UnifiedInitParamMetaData(key, (String)value));
/*     */       }
/* 138 */       handler.setInitParams(initParams);
/*     */ 
/* 140 */       epMetaData.addHandler(handler);
/* 141 */       log.debug("Add handler to: " + portName + handler);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.client.HandlerRegistryImpl
 * JD-Core Version:    0.6.0
 */