/*     */ package org.jboss.ws.core.jaxrpc.handler;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Observable;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.handler.HandlerChain;
/*     */ import javax.xml.rpc.handler.HandlerInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.RoleSource;
/*     */ import org.jboss.ws.core.server.ServerHandlerDelegate;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaData;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
/*     */ 
/*     */ public class HandlerDelegateJAXRPC extends ServerHandlerDelegate
/*     */   implements RoleSource
/*     */ {
/*  57 */   private static Logger log = Logger.getLogger(HandlerDelegateJAXRPC.class);
/*     */   private ServerHandlerChain preHandlerChain;
/*     */   private ServerHandlerChain jaxrpcHandlerChain;
/*     */   private ServerHandlerChain postHandlerChain;
/*  66 */   Set<QName> headers = new HashSet();
/*     */ 
/*  68 */   Set<String> roles = new HashSet();
/*     */ 
/*     */   public HandlerDelegateJAXRPC(ServerEndpointMetaData sepMetaData)
/*     */   {
/*  72 */     super(sepMetaData);
/*  73 */     sepMetaData.registerConfigObserver(this);
/*     */   }
/*     */ 
/*     */   public UnifiedHandlerMetaData.HandlerType[] getHandlerTypeOrder()
/*     */   {
/*  81 */     return new UnifiedHandlerMetaData.HandlerType[] { UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST };
/*     */   }
/*     */ 
/*     */   public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/*  86 */     SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
/*     */ 
/*  89 */     if (!isInitialized())
/*     */     {
/*  91 */       initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.PRE);
/*  92 */       initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/*  93 */       initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.POST);
/*  94 */       setInitialized(true);
/*     */     }
/*     */ 
/*  97 */     boolean status = true;
/*     */ 
/*  99 */     HandlerChain handlerChain = null;
/* 100 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/* 101 */       handlerChain = this.preHandlerChain;
/* 102 */     else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT)
/* 103 */       handlerChain = this.jaxrpcHandlerChain;
/* 104 */     else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
/* 105 */       handlerChain = this.postHandlerChain;
/*     */     }
/* 107 */     if (handlerChain != null) {
/* 108 */       status = handlerChain.handleRequest(msgContext);
/*     */     }
/* 110 */     return status;
/*     */   }
/*     */ 
/*     */   public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 115 */     SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
/*     */ 
/* 117 */     HandlerChain handlerChain = null;
/* 118 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/* 119 */       handlerChain = this.preHandlerChain;
/* 120 */     else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT)
/* 121 */       handlerChain = this.jaxrpcHandlerChain;
/* 122 */     else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
/* 123 */       handlerChain = this.postHandlerChain;
/*     */     }
/* 125 */     boolean status = handlerChain != null ? handlerChain.handleResponse(msgContext) : true;
/*     */ 
/* 127 */     if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
/* 128 */       XOPContext.visitAndRestoreXOPData();
/*     */     }
/* 130 */     return status;
/*     */   }
/*     */ 
/*     */   public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type, Exception ex)
/*     */   {
/* 135 */     SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
/*     */ 
/* 137 */     HandlerChain handlerChain = null;
/* 138 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/* 139 */       handlerChain = this.preHandlerChain;
/* 140 */     else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT)
/* 141 */       handlerChain = this.jaxrpcHandlerChain;
/* 142 */     else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
/* 143 */       handlerChain = this.postHandlerChain;
/*     */     }
/* 145 */     boolean status = handlerChain != null ? handlerChain.handleFault(msgContext) : true;
/*     */ 
/* 147 */     if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
/* 148 */       XOPContext.visitAndRestoreXOPData();
/*     */     }
/* 150 */     return status;
/*     */   }
/*     */ 
/*     */   public void closeHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/*     */   }
/*     */ 
/*     */   private void initHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 163 */     Set handlerRoles = new HashSet();
/* 164 */     List hInfos = new ArrayList();
/*     */ 
/* 166 */     for (HandlerMetaData handlerMetaData : sepMetaData.getHandlerMetaData(type))
/*     */     {
/* 168 */       HandlerMetaDataJAXRPC jaxrpcMetaData = (HandlerMetaDataJAXRPC)handlerMetaData;
/* 169 */       handlerRoles.addAll(jaxrpcMetaData.getSoapRoles());
/*     */ 
/* 171 */       HashMap hConfig = new HashMap();
/* 172 */       for (UnifiedInitParamMetaData param : jaxrpcMetaData.getInitParams())
/*     */       {
/* 174 */         hConfig.put(param.getParamName(), param.getParamValue());
/*     */       }
/*     */ 
/* 177 */       Set headers = jaxrpcMetaData.getSoapHeaders();
/* 178 */       QName[] headerArr = new QName[headers.size()];
/* 179 */       headers.toArray(headerArr);
/*     */ 
/* 181 */       Class hClass = jaxrpcMetaData.getHandlerClass();
/* 182 */       hConfig.put(UnifiedHandlerMetaData.HandlerType.class.getName(), jaxrpcMetaData.getHandlerType());
/* 183 */       HandlerInfo info = new HandlerInfo(hClass, hConfig, headerArr);
/*     */ 
/* 185 */       if (log.isDebugEnabled())
/* 186 */         log.debug("Adding server side handler to service '" + sepMetaData.getPortName() + "': " + info);
/* 187 */       hInfos.add(info);
/*     */     }
/*     */ 
/* 190 */     initHandlerChain(sepMetaData, hInfos, handlerRoles, type);
/*     */   }
/*     */ 
/*     */   private void initHandlerChain(ServerEndpointMetaData sepMetaData, List<HandlerInfo> hInfos, Set<String> handlerRoles, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 195 */     if (log.isDebugEnabled()) {
/* 196 */       log.debug("Init handler chain with [" + hInfos.size() + "] handlers");
/*     */     }
/* 198 */     ServerHandlerChain handlerChain = new ServerHandlerChain(hInfos, handlerRoles, type);
/* 199 */     if (type == UnifiedHandlerMetaData.HandlerType.PRE)
/* 200 */       this.preHandlerChain = handlerChain;
/* 201 */     else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT)
/* 202 */       this.jaxrpcHandlerChain = handlerChain;
/* 203 */     else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
/* 204 */       this.postHandlerChain = handlerChain;
/*     */     }
/* 206 */     if (handlerChain.getState() == 1)
/*     */     {
/* 209 */       handlerChain.init(null);
/*     */     }
/* 211 */     handlerChain.pullHeaders(this.headers);
/* 212 */     Collections.addAll(this.roles, handlerChain.getRoles());
/*     */   }
/*     */ 
/*     */   public Set<String> getRoles()
/*     */   {
/* 217 */     return this.roles;
/*     */   }
/*     */ 
/*     */   public Set<QName> getHeaders()
/*     */   {
/* 222 */     return this.headers;
/*     */   }
/*     */ 
/*     */   public void update(Observable observable, Object object)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.handler.HandlerDelegateJAXRPC
 * JD-Core Version:    0.6.0
 */