/*     */ package org.jboss.ws.core.jaxrpc.handler;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.jaxrpc.SerializationContextJAXRPC;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ 
/*     */ public abstract class MessageContextJAXRPC extends CommonMessageContext
/*     */   implements MessageContext
/*     */ {
/*  54 */   private static Logger log = Logger.getLogger(MessageContextJAXRPC.class);
/*     */   public static final String SERVLET_CONTEXT = "javax.xml.ws.servlet.context";
/*     */   public static final String SERVLET_REQUEST = "javax.xml.ws.servlet.request";
/*     */   public static final String SERVLET_RESPONSE = "javax.xml.ws.servlet.response";
/*     */ 
/*     */   public MessageContextJAXRPC()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MessageContextJAXRPC(CommonMessageContext msgContext)
/*     */   {
/*  66 */     super(msgContext);
/*     */   }
/*     */ 
/*     */   public SerializationContext createSerializationContext()
/*     */   {
/*  73 */     EndpointMetaData epMetaData = getEndpointMetaData();
/*  74 */     ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
/*     */ 
/*  76 */     SerializationContextJAXRPC jaxrpcContext = new SerializationContextJAXRPC();
/*  77 */     jaxrpcContext.setTypeMapping(serviceMetaData.getTypeMapping());
/*  78 */     jaxrpcContext.setJavaWsdlMapping(serviceMetaData.getJavaWsdlMapping());
/*  79 */     return jaxrpcContext;
/*     */   }
/*     */ 
/*     */   public NamespaceRegistry getNamespaceRegistry()
/*     */   {
/*  85 */     return getSerializationContext().getNamespaceRegistry();
/*     */   }
/*     */ 
/*     */   public static CommonMessageContext processPivot(CommonMessageContext requestContext)
/*     */   {
/*  90 */     log.debug("Begin response processing");
/*  91 */     cleanupAttachments(requestContext);
/*  92 */     return requestContext;
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getProperties()
/*     */   {
/*  98 */     Map props = new HashMap();
/*  99 */     for (String key : keySet())
/*     */     {
/* 101 */       Object value = get(key);
/* 102 */       props.put(key, value);
/*     */     }
/* 104 */     return props;
/*     */   }
/*     */ 
/*     */   public boolean containsProperty(String name)
/*     */   {
/* 112 */     return containsKey(name);
/*     */   }
/*     */ 
/*     */   public Object getProperty(String name)
/*     */   {
/* 120 */     return get(name);
/*     */   }
/*     */ 
/*     */   public Iterator getPropertyNames()
/*     */   {
/* 128 */     return keySet().iterator();
/*     */   }
/*     */ 
/*     */   public void removeProperty(String name)
/*     */   {
/* 136 */     remove(name);
/*     */   }
/*     */ 
/*     */   public void setProperty(String name, Object value)
/*     */   {
/* 145 */     put(name, value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.handler.MessageContextJAXRPC
 * JD-Core Version:    0.6.0
 */