/*     */ package org.jboss.ws.core.jaxws;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.SortedMap;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.LoaderClassPath;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.bytecode.ClassFile;
/*     */ import javassist.bytecode.ConstPool;
/*     */ import javax.xml.bind.annotation.XmlAccessType;
/*     */ import javax.xml.bind.annotation.XmlAccessorType;
/*     */ import javax.xml.bind.annotation.XmlAttachmentRef;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlMimeType;
/*     */ import javax.xml.bind.annotation.XmlRootElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.utils.JavassistUtils;
/*     */ import org.jboss.ws.core.utils.JavassistUtils.Annotation;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
/*     */ import org.jboss.ws.metadata.umdm.TypesMetaData;
/*     */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class DynamicWrapperGenerator extends AbstractWrapperGenerator
/*     */ {
/*  54 */   private static Logger log = Logger.getLogger(DynamicWrapperGenerator.class);
/*     */   protected ClassPool pool;
/*  57 */   protected boolean prune = true;
/*     */ 
/*     */   public DynamicWrapperGenerator(ClassLoader loader)
/*     */   {
/*  61 */     super(loader);
/*  62 */     init(loader);
/*     */   }
/*     */ 
/*     */   private void init(ClassLoader loader)
/*     */   {
/*  67 */     this.pool = new ClassPool(true);
/*  68 */     this.pool.appendClassPath(new LoaderClassPath(loader));
/*     */   }
/*     */ 
/*     */   public void reset(ClassLoader loader)
/*     */   {
/*  74 */     super.reset(loader);
/*  75 */     init(loader);
/*     */   }
/*     */ 
/*     */   public void generate(ParameterMetaData pmd)
/*     */   {
/*  87 */     String wrapperName = pmd.getJavaTypeName();
/*     */ 
/*  89 */     List wrappedParameters = pmd.getWrappedParameters();
/*  90 */     OperationMetaData opMetaData = pmd.getOperationMetaData();
/*     */ 
/*  92 */     if (!opMetaData.isDocumentWrapped()) {
/*  93 */       throw new WSException("Operation is not document/literal (wrapped)");
/*     */     }
/*  95 */     if (wrappedParameters == null) {
/*  96 */       throw new WSException("Cannot generate a type when their is no wrapper parameters");
/*     */     }
/*  98 */     if (log.isDebugEnabled()) log.debug("Generating wrapper: " + wrapperName);
/*     */ 
/* 100 */     QName xmlName = pmd.getXmlName();
/* 101 */     QName xmlType = pmd.getXmlType();
/*     */     try
/*     */     {
/* 105 */       CtClass clazz = this.pool.makeClass(wrapperName);
/* 106 */       clazz.getClassFile().setVersionToJava5();
/* 107 */       addClassAnnotations(clazz, xmlName, xmlType, null);
/*     */ 
/* 109 */       for (WrappedParameter parameter : wrappedParameters)
/*     */       {
/* 111 */         addProperty(clazz, parameter.getType(), parameter.getName(), parameter.getVariable(), parameter.getTypeArguments(), new boolean[] { parameter.isSwaRef(), parameter.isXop() });
/*     */       }
/*     */ 
/* 118 */       clazz.stopPruning(!this.prune);
/* 119 */       this.pool.toClass(clazz, this.loader);
/* 120 */       JavaUtils.clearBlacklists(this.loader);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 124 */       throw new WSException("Could not generate wrapper type: " + wrapperName, e);
/*     */     }
/*     */ 
/* 128 */     TypesMetaData types = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
/* 129 */     types.addTypeMapping(new TypeMappingMetaData(types, xmlType, wrapperName));
/*     */   }
/*     */ 
/*     */   public void generate(FaultMetaData fmd)
/*     */   {
/* 134 */     String faultBeanName = fmd.getFaultBeanName();
/* 135 */     if (log.isDebugEnabled()) log.debug("Generating fault bean: " + faultBeanName);
/*     */ 
/* 137 */     QName xmlType = fmd.getXmlType();
/*     */ 
/* 139 */     Class exception = fmd.getJavaType();
/*     */     try
/*     */     {
/* 142 */       SortedMap properties = getExceptionProperties(exception);
/* 143 */       String[] propertyOrder = (String[])properties.keySet().toArray(new String[0]);
/*     */ 
/* 145 */       CtClass clazz = this.pool.makeClass(faultBeanName);
/* 146 */       clazz.getClassFile().setVersionToJava5();
/* 147 */       addClassAnnotations(clazz, fmd.getXmlName(), fmd.getXmlType(), propertyOrder);
/*     */ 
/* 149 */       for (String property : propertyOrder) {
/* 150 */         addProperty(clazz, ((Class)properties.get(property)).getName(), new QName(property), property, null, new boolean[] { false, false });
/*     */       }
/*     */ 
/* 156 */       clazz.stopPruning(!this.prune);
/* 157 */       this.pool.toClass(clazz, this.loader);
/* 158 */       JavaUtils.clearBlacklists(this.loader);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 162 */       throw new WSException("Could not generate fault wrapper bean: " + faultBeanName, e);
/*     */     }
/*     */ 
/* 166 */     TypesMetaData types = fmd.getOperationMetaData().getEndpointMetaData().getServiceMetaData().getTypesMetaData();
/* 167 */     types.addTypeMapping(new TypeMappingMetaData(types, xmlType, faultBeanName));
/*     */   }
/*     */ 
/*     */   private static String getterPrefix(CtClass type)
/*     */   {
/* 172 */     return (type == CtClass.booleanType) || ("java.lang.Boolean".equals(type.getName())) ? "is" : "get";
/*     */   }
/*     */ 
/*     */   private String typeSignature(String type, String[] arguments)
/*     */   {
/* 177 */     StringBuilder ret = new StringBuilder(JavaUtils.toSignature(type));
/* 178 */     ret.deleteCharAt(ret.length() - 1).append('<');
/*     */ 
/* 180 */     for (String arg : arguments) {
/* 181 */       ret.append(JavaUtils.toSignature(arg));
/*     */     }
/* 183 */     return ">;";
/*     */   }
/*     */ 
/*     */   private String getterSignature(String type)
/*     */   {
/* 188 */     return "()" + type;
/*     */   }
/*     */ 
/*     */   private String setterSignature(String type)
/*     */   {
/* 193 */     return "(" + type + ")V";
/*     */   }
/*     */ 
/*     */   private void addProperty(CtClass clazz, String typeName, QName name, String variable, String[] typeArguments, boolean[] attachments)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 201 */     ConstPool constPool = clazz.getClassFile().getConstPool();
/* 202 */     String fieldName = JavaUtils.isReservedKeyword(variable) ? "_" + variable : variable;
/* 203 */     CtField field = new CtField(this.pool.get(typeName), fieldName, clazz);
/* 204 */     field.setModifiers(2);
/*     */ 
/* 207 */     String typeSignature = null;
/* 208 */     if (typeArguments != null)
/*     */     {
/* 210 */       typeSignature = typeSignature(typeName, typeArguments);
/* 211 */       JavassistUtils.addSignature(field, typeSignature);
/*     */     }
/*     */ 
/* 215 */     JavassistUtils.Annotation annotation = JavassistUtils.createAnnotation(XmlElement.class, constPool);
/* 216 */     if (name.getNamespaceURI() != null)
/* 217 */       annotation.addParameter("namespace", name.getNamespaceURI());
/* 218 */     annotation.addParameter("name", name.getLocalPart());
/* 219 */     annotation.markField(field);
/*     */ 
/* 221 */     if (attachments[0] != 0)
/*     */     {
/* 223 */       annotation = JavassistUtils.createAnnotation(XmlAttachmentRef.class, constPool);
/* 224 */       annotation.markField(field);
/*     */     }
/*     */ 
/* 227 */     if (attachments[1] != 0)
/*     */     {
/* 229 */       annotation = JavassistUtils.createAnnotation(XmlMimeType.class, constPool);
/* 230 */       annotation.addParameter("value", "application/octet-stream");
/* 231 */       annotation.markField(field);
/*     */     }
/* 233 */     clazz.addField(field);
/*     */ 
/* 236 */     CtMethod getter = CtNewMethod.getter(getterPrefix(field.getType()) + JavaUtils.capitalize(variable), field);
/* 237 */     CtMethod setter = CtNewMethod.setter("set" + JavaUtils.capitalize(variable), field);
/* 238 */     if (typeSignature != null)
/*     */     {
/* 240 */       JavassistUtils.addSignature(getter, getterSignature(typeSignature));
/* 241 */       JavassistUtils.addSignature(setter, setterSignature(typeSignature));
/*     */     }
/* 243 */     clazz.addMethod(getter);
/* 244 */     clazz.addMethod(setter);
/*     */   }
/*     */ 
/*     */   private static void addClassAnnotations(CtClass clazz, QName xmlName, QName xmlType, String[] propertyOrder)
/*     */   {
/* 249 */     ConstPool constPool = clazz.getClassFile().getConstPool();
/*     */ 
/* 252 */     JavassistUtils.Annotation annotation = JavassistUtils.createAnnotation(XmlRootElement.class, constPool);
/* 253 */     if ((xmlName.getNamespaceURI() != null) && (xmlName.getNamespaceURI().length() > 0))
/* 254 */       annotation.addParameter("namespace", xmlName.getNamespaceURI());
/* 255 */     annotation.addParameter("name", xmlName.getLocalPart());
/* 256 */     annotation.markClass(clazz);
/*     */ 
/* 259 */     annotation = JavassistUtils.createAnnotation(XmlType.class, constPool);
/* 260 */     if (((xmlType.getNamespaceURI() != null ? 1 : 0) & (xmlType.getNamespaceURI().length() > 0 ? 1 : 0)) != 0)
/* 261 */       annotation.addParameter("namespace", xmlType.getNamespaceURI());
/* 262 */     annotation.addParameter("name", xmlType.getLocalPart());
/* 263 */     if (propertyOrder != null)
/* 264 */       annotation.addParameter("propOrder", propertyOrder);
/* 265 */     annotation.markClass(clazz);
/*     */ 
/* 268 */     annotation = JavassistUtils.createAnnotation(XmlAccessorType.class, constPool);
/* 269 */     annotation.addParameter("value", XmlAccessType.FIELD);
/* 270 */     annotation.markClass(clazz);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.DynamicWrapperGenerator
 * JD-Core Version:    0.6.0
 */